package org.immutables.fixture.style;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PostData}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutablePostData.builder()}.
 */
@Generated(from = "PostData", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutablePostData implements PostData {
  private final boolean loginAllowed;

  private ImmutablePostData(boolean loginAllowed) {
    this.loginAllowed = loginAllowed;
  }

  /**
   * @return The value of the {@code loginAllowed} attribute
   */
  @JsonProperty("login_allowed")
  @Override
  public boolean isLoginAllowed() {
    return loginAllowed;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PostData#isLoginAllowed() loginAllowed} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for loginAllowed
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePostData withLoginAllowed(boolean value) {
    if (this.loginAllowed == value) return this;
    return new ImmutablePostData(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePostData} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePostData
        && equalTo(0, (ImmutablePostData) another);
  }

  private boolean equalTo(int synthetic, ImmutablePostData another) {
    return loginAllowed == another.loginAllowed;
  }

  /**
   * Computes a hash code from attributes: {@code loginAllowed}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(loginAllowed);
    return h;
  }

  /**
   * Prints the immutable value {@code PostData} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PostData")
        .omitNullValues()
        .add("loginAllowed", loginAllowed)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PostData", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PostData {
    boolean loginAllowed;
    boolean loginAllowedIsSet;
    @JsonProperty("login_allowed")
    public void setLoginAllowed(boolean loginAllowed) {
      this.loginAllowed = loginAllowed;
      this.loginAllowedIsSet = true;
    }
    @Override
    public boolean isLoginAllowed() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePostData fromJson(Json json) {
    ImmutablePostData.Builder builder = ImmutablePostData.builder();
    if (json.loginAllowedIsSet) {
      builder.loginAllowed(json.loginAllowed);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PostData} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PostData instance
   */
  public static ImmutablePostData copyOf(PostData instance) {
    if (instance instanceof ImmutablePostData) {
      return (ImmutablePostData) instance;
    }
    return ImmutablePostData.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutablePostData ImmutablePostData}.
   * <pre>
   * ImmutablePostData.builder()
   *    .loginAllowed(boolean) // optional {@link PostData#isLoginAllowed() loginAllowed}
   *    .build();
   * </pre>
   * @return A new ImmutablePostData builder
   */
  public static ImmutablePostData.Builder builder() {
    return new ImmutablePostData.Builder();
  }

  /**
   * Builds instances of type {@link ImmutablePostData ImmutablePostData}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PostData", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private boolean loginAllowed;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiablePostData} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiablePostData instance) {
      Objects.requireNonNull(instance, "instance");
      loginAllowed(instance.isLoginAllowed());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code PostData} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(PostData instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiablePostData) {
        return from((ModifiablePostData) instance);
      }
      loginAllowed(instance.isLoginAllowed());
      return this;
    }

    /**
     * Initializes the value for the {@link PostData#isLoginAllowed() loginAllowed} attribute.
     * @param loginAllowed The value for loginAllowed 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("login_allowed")
    public final Builder loginAllowed(boolean loginAllowed) {
      this.loginAllowed = loginAllowed;
      return this;
    }

    /**
     * Builds a new {@link ImmutablePostData ImmutablePostData}.
     * @return An immutable instance of PostData
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePostData build() {
      return new ImmutablePostData(loginAllowed);
    }
  }
}
