package org.immutables.fixture.style;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NestingClassOrBuilder.NonPublicBuild}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNonPublicBuild.builder()}.
 */
@Generated(from = "NestingClassOrBuilder.NonPublicBuild", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNonPublicBuild
    implements NestingClassOrBuilder.NonPublicBuild {

  private ImmutableNonPublicBuild(ImmutableNonPublicBuild.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNonPublicBuild} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNonPublicBuild
        && equalTo(0, (ImmutableNonPublicBuild) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableNonPublicBuild another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -591227920;
  }

  /**
   * Prints the immutable value {@code NonPublicBuild}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "NonPublicBuild{}";
  }

  /**
   * Creates an immutable copy of a {@link NestingClassOrBuilder.NonPublicBuild} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NonPublicBuild instance
   */
  public static ImmutableNonPublicBuild copyOf(NestingClassOrBuilder.NonPublicBuild instance) {
    if (instance instanceof ImmutableNonPublicBuild) {
      return (ImmutableNonPublicBuild) instance;
    }
    return ImmutableNonPublicBuild.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNonPublicBuild ImmutableNonPublicBuild}.
   * <pre>
   * ImmutableNonPublicBuild.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableNonPublicBuild builder
   */
  public static ImmutableNonPublicBuild.Builder builder() {
    return new ImmutableNonPublicBuild.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNonPublicBuild ImmutableNonPublicBuild}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NestingClassOrBuilder.NonPublicBuild", generator = "Immutables")
  @NotThreadSafe
  static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NonPublicBuild} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NestingClassOrBuilder.NonPublicBuild instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableNonPublicBuild ImmutableNonPublicBuild}.
     * @return An immutable instance of NonPublicBuild
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNonPublicBuild build() {
      return new ImmutableNonPublicBuild(this);
    }
  }
}
