package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link LazyHasItsOwnPlane}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableLazyHasItsOwnPlane.builder()}.
 */
@Generated(from = "LazyHasItsOwnPlane", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableLazyHasItsOwnPlane extends LazyHasItsOwnPlane {
  private final ImmutableList<String> strings;

  private ImmutableLazyHasItsOwnPlane(ImmutableList<String> strings) {
    this.strings = strings;
  }

  /**
   * @return The value of the {@code strings} attribute
   */
  @Override
  ImmutableList<String> internalStrings() {
    return strings;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LazyHasItsOwnPlane#internalStrings() strings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLazyHasItsOwnPlane withStrings(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLazyHasItsOwnPlane(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link LazyHasItsOwnPlane#internalStrings() strings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of strings elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableLazyHasItsOwnPlane withStrings(Iterable<String> elements) {
    if (this.strings == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableLazyHasItsOwnPlane(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableLazyHasItsOwnPlane} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableLazyHasItsOwnPlane
        && equalTo(0, (ImmutableLazyHasItsOwnPlane) another);
  }

  private boolean equalTo(int synthetic, ImmutableLazyHasItsOwnPlane another) {
    return strings.equals(another.strings);
  }

  /**
   * Computes a hash code from attributes: {@code strings}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + strings.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code LazyHasItsOwnPlane} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("LazyHasItsOwnPlane")
        .omitNullValues()
        .add("strings", strings)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long STRINGS_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient Object[] strings$lazy;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link LazyHasItsOwnPlane#getStrings() strings} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code strings} attribute
   */
  @Override
  public Object[] getStrings() {
    if ((lazyInitBitmap & STRINGS_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & STRINGS_LAZY_INIT_BIT) == 0) {
          this.strings$lazy = Objects.requireNonNull(super.getStrings(), "strings");
          lazyInitBitmap |= STRINGS_LAZY_INIT_BIT;
        }
      }
    }
    return strings$lazy;
  }

  private static final long LENGTH_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient int length;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link LazyHasItsOwnPlane#getLength() length} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code length} attribute
   */
  @Override
  public int getLength() {
    if ((lazyInitBitmap & LENGTH_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & LENGTH_LAZY_INIT_BIT) == 0) {
          this.length = super.getLength();
          lazyInitBitmap |= LENGTH_LAZY_INIT_BIT;
        }
      }
    }
    return length;
  }

  /**
   * Creates an immutable copy of a {@link LazyHasItsOwnPlane} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable LazyHasItsOwnPlane instance
   */
  public static ImmutableLazyHasItsOwnPlane copyOf(LazyHasItsOwnPlane instance) {
    if (instance instanceof ImmutableLazyHasItsOwnPlane) {
      return (ImmutableLazyHasItsOwnPlane) instance;
    }
    return ImmutableLazyHasItsOwnPlane.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableLazyHasItsOwnPlane ImmutableLazyHasItsOwnPlane}.
   * <pre>
   * ImmutableLazyHasItsOwnPlane.builder()
   *    .addStrings|addAllStrings(String) // {@link LazyHasItsOwnPlane#internalStrings() strings} elements
   *    .build();
   * </pre>
   * @return A new ImmutableLazyHasItsOwnPlane builder
   */
  public static ImmutableLazyHasItsOwnPlane.Builder builder() {
    return new ImmutableLazyHasItsOwnPlane.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableLazyHasItsOwnPlane ImmutableLazyHasItsOwnPlane}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "LazyHasItsOwnPlane", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<String> strings = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code LazyHasItsOwnPlane} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(LazyHasItsOwnPlane instance) {
      Objects.requireNonNull(instance, "instance");
      addAllStrings(instance.internalStrings());
      return this;
    }

    /**
     * Adds one element to {@link LazyHasItsOwnPlane#internalStrings() strings} list.
     * @param element A strings element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStrings(String element) {
      this.strings.add(element);
      return this;
    }

    /**
     * Adds elements to {@link LazyHasItsOwnPlane#internalStrings() strings} list.
     * @param elements An array of strings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStrings(String... elements) {
      this.strings.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link LazyHasItsOwnPlane#internalStrings() strings} list.
     * @param elements An iterable of strings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder strings(Iterable<String> elements) {
      this.strings = ImmutableList.builder();
      return addAllStrings(elements);
    }

    /**
     * Adds elements to {@link LazyHasItsOwnPlane#internalStrings() strings} list.
     * @param elements An iterable of strings elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllStrings(Iterable<String> elements) {
      this.strings.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableLazyHasItsOwnPlane ImmutableLazyHasItsOwnPlane}.
     * @return An immutable instance of LazyHasItsOwnPlane
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableLazyHasItsOwnPlane build() {
      return new ImmutableLazyHasItsOwnPlane(strings.build());
    }
  }
}
