package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Chars;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ForceEqualsInWithers}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableForceEqualsInWithers.builder()}.
 */
@Generated(from = "ForceEqualsInWithers", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableForceEqualsInWithers implements ForceEqualsInWithers {
  private final float f;
  private final double d;
  private final String s;
  private final boolean b;
  private final char c;
  private final @Nullable String o;
  private final ImmutableList<Integer> l;
  private final @Nullable ImmutableSet<String> st;
  private final ImmutableMap<String, Integer> mp;

  private ImmutableForceEqualsInWithers(
      float f,
      double d,
      String s,
      boolean b,
      char c,
      @Nullable String o,
      ImmutableList<Integer> l,
      @Nullable ImmutableSet<String> st,
      ImmutableMap<String, Integer> mp) {
    this.f = f;
    this.d = d;
    this.s = s;
    this.b = b;
    this.c = c;
    this.o = o;
    this.l = l;
    this.st = st;
    this.mp = mp;
  }

  /**
   * @return The value of the {@code f} attribute
   */
  @Override
  public float f() {
    return f;
  }

  /**
   * @return The value of the {@code d} attribute
   */
  @Override
  public double d() {
    return d;
  }

  /**
   * @return The value of the {@code s} attribute
   */
  @Override
  public String s() {
    return s;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public boolean b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public char c() {
    return c;
  }

  /**
   * @return The value of the {@code o} attribute
   */
  @Override
  public Optional<String> o() {
    return Optional.ofNullable(o);
  }

  /**
   * @return The value of the {@code l} attribute
   */
  @Override
  public ImmutableList<Integer> l() {
    return l;
  }

  /**
   * @return The value of the {@code st} attribute
   */
  @Override
  public @Nullable ImmutableSet<String> st() {
    return st;
  }

  /**
   * @return The value of the {@code mp} attribute
   */
  @Override
  public ImmutableMap<String, Integer> mp() {
    return mp;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ForceEqualsInWithers#f() f} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for f
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForceEqualsInWithers withF(float value) {
    if (Float.floatToIntBits(this.f) == Float.floatToIntBits(value)) return this;
    return new ImmutableForceEqualsInWithers(value, this.d, this.s, this.b, this.c, this.o, this.l, this.st, this.mp);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ForceEqualsInWithers#d() d} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for d
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForceEqualsInWithers withD(double value) {
    if (Double.doubleToLongBits(this.d) == Double.doubleToLongBits(value)) return this;
    return new ImmutableForceEqualsInWithers(this.f, value, this.s, this.b, this.c, this.o, this.l, this.st, this.mp);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ForceEqualsInWithers#s() s} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for s
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForceEqualsInWithers withS(String value) {
    if (Objects.equals(this.s, value)) return this;
    String newValue = Objects.requireNonNull(value, "s");
    return new ImmutableForceEqualsInWithers(this.f, this.d, newValue, this.b, this.c, this.o, this.l, this.st, this.mp);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ForceEqualsInWithers#b() b} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForceEqualsInWithers withB(boolean value) {
    if (this.b == value) return this;
    return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, value, this.c, this.o, this.l, this.st, this.mp);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ForceEqualsInWithers#c() c} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableForceEqualsInWithers withC(char value) {
    if (this.c == value) return this;
    return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, value, this.o, this.l, this.st, this.mp);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ForceEqualsInWithers#o() o} attribute.
   * @param value The value for o
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForceEqualsInWithers withO(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "o");
    if (Objects.equals(this.o, newValue)) return this;
    return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, newValue, this.l, this.st, this.mp);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ForceEqualsInWithers#o() o} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for o
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForceEqualsInWithers withO(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.o, value)) return this;
    return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, value, this.l, this.st, this.mp);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForceEqualsInWithers#l() l}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForceEqualsInWithers withL(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, this.o, newValue, this.st, this.mp);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForceEqualsInWithers#l() l}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of l elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForceEqualsInWithers withL(Iterable<Integer> elements) {
    if (Objects.equals(this.l, elements)) return this;
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, this.o, newValue, this.st, this.mp);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForceEqualsInWithers#st() st}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForceEqualsInWithers withSt(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, this.o, this.l, null, this.mp);
    }
    @Nullable ImmutableSet<String> newValue = elements == null ? null : ImmutableSet.copyOf(elements);
    return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, this.o, this.l, newValue, this.mp);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ForceEqualsInWithers#st() st}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of st elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForceEqualsInWithers withSt(@Nullable Iterable<String> elements) {
    if (Objects.equals(this.st, elements)) return this;
    @Nullable ImmutableSet<String> newValue = elements == null ? null : ImmutableSet.copyOf(elements);
    return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, this.o, this.l, newValue, this.mp);
  }

  /**
   * Copy the current immutable object by replacing the {@link ForceEqualsInWithers#mp() mp} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the mp map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableForceEqualsInWithers withMp(Map<String, ? extends Integer> entries) {
    if (Objects.equals(this.mp, entries)) return this;
    ImmutableMap<String, Integer> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableForceEqualsInWithers(this.f, this.d, this.s, this.b, this.c, this.o, this.l, this.st, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableForceEqualsInWithers} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableForceEqualsInWithers
        && equalTo(0, (ImmutableForceEqualsInWithers) another);
  }

  private boolean equalTo(int synthetic, ImmutableForceEqualsInWithers another) {
    return Float.floatToIntBits(f) == Float.floatToIntBits(another.f)
        && Double.doubleToLongBits(d) == Double.doubleToLongBits(another.d)
        && s.equals(another.s)
        && b == another.b
        && c == another.c
        && Objects.equals(o, another.o)
        && l.equals(another.l)
        && Objects.equals(st, another.st)
        && mp.equals(another.mp);
  }

  /**
   * Computes a hash code from attributes: {@code f}, {@code d}, {@code s}, {@code b}, {@code c}, {@code o}, {@code l}, {@code st}, {@code mp}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Floats.hashCode(f);
    h += (h << 5) + Doubles.hashCode(d);
    h += (h << 5) + s.hashCode();
    h += (h << 5) + Booleans.hashCode(b);
    h += (h << 5) + Chars.hashCode(c);
    h += (h << 5) + Objects.hashCode(o);
    h += (h << 5) + l.hashCode();
    h += (h << 5) + Objects.hashCode(st);
    h += (h << 5) + mp.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ForceEqualsInWithers} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ForceEqualsInWithers")
        .omitNullValues()
        .add("f", f)
        .add("d", d)
        .add("s", s)
        .add("b", b)
        .add("c", c)
        .add("o", o)
        .add("l", l)
        .add("st", st)
        .add("mp", mp)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ForceEqualsInWithers} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ForceEqualsInWithers instance
   */
  public static ImmutableForceEqualsInWithers copyOf(ForceEqualsInWithers instance) {
    if (instance instanceof ImmutableForceEqualsInWithers) {
      return (ImmutableForceEqualsInWithers) instance;
    }
    return ImmutableForceEqualsInWithers.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableForceEqualsInWithers ImmutableForceEqualsInWithers}.
   * <pre>
   * ImmutableForceEqualsInWithers.builder()
   *    .f(float) // required {@link ForceEqualsInWithers#f() f}
   *    .d(double) // required {@link ForceEqualsInWithers#d() d}
   *    .s(String) // required {@link ForceEqualsInWithers#s() s}
   *    .b(boolean) // required {@link ForceEqualsInWithers#b() b}
   *    .c(char) // required {@link ForceEqualsInWithers#c() c}
   *    .o(String) // optional {@link ForceEqualsInWithers#o() o}
   *    .addL|addAllL(int) // {@link ForceEqualsInWithers#l() l} elements
   *    .st(Set&amp;lt;String&amp;gt; | null) // nullable {@link ForceEqualsInWithers#st() st}
   *    .putMp|putAllMp(String =&gt; int) // {@link ForceEqualsInWithers#mp() mp} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableForceEqualsInWithers builder
   */
  public static ImmutableForceEqualsInWithers.Builder builder() {
    return new ImmutableForceEqualsInWithers.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableForceEqualsInWithers ImmutableForceEqualsInWithers}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ForceEqualsInWithers", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_F = 0x1L;
    private static final long INIT_BIT_D = 0x2L;
    private static final long INIT_BIT_S = 0x4L;
    private static final long INIT_BIT_B = 0x8L;
    private static final long INIT_BIT_C = 0x10L;
    private long initBits = 0x1fL;

    private float f;
    private double d;
    private @Nullable String s;
    private boolean b;
    private char c;
    private @Nullable String o;
    private ImmutableList.Builder<Integer> l = ImmutableList.builder();
    private ImmutableSet.Builder<String> st = null;
    private ImmutableMap.Builder<String, Integer> mp = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ForceEqualsInWithers} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ForceEqualsInWithers instance) {
      Objects.requireNonNull(instance, "instance");
      f(instance.f());
      d(instance.d());
      s(instance.s());
      b(instance.b());
      c(instance.c());
      Optional<String> oOptional = instance.o();
      if (oOptional.isPresent()) {
        o(oOptional);
      }
      addAllL(instance.l());
      @Nullable Set<String> stValue = instance.st();
      if (stValue != null) {
        addAllSt(stValue);
      }
      putAllMp(instance.mp());
      return this;
    }

    /**
     * Initializes the value for the {@link ForceEqualsInWithers#f() f} attribute.
     * @param f The value for f 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder f(float f) {
      this.f = f;
      initBits &= ~INIT_BIT_F;
      return this;
    }

    /**
     * Initializes the value for the {@link ForceEqualsInWithers#d() d} attribute.
     * @param d The value for d 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder d(double d) {
      this.d = d;
      initBits &= ~INIT_BIT_D;
      return this;
    }

    /**
     * Initializes the value for the {@link ForceEqualsInWithers#s() s} attribute.
     * @param s The value for s 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder s(String s) {
      this.s = Objects.requireNonNull(s, "s");
      initBits &= ~INIT_BIT_S;
      return this;
    }

    /**
     * Initializes the value for the {@link ForceEqualsInWithers#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(boolean b) {
      this.b = b;
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link ForceEqualsInWithers#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(char c) {
      this.c = c;
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Initializes the optional value {@link ForceEqualsInWithers#o() o} to o.
     * @param o The value for o
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder o(String o) {
      this.o = Objects.requireNonNull(o, "o");
      return this;
    }

    /**
     * Initializes the optional value {@link ForceEqualsInWithers#o() o} to o.
     * @param o The value for o
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder o(Optional<String> o) {
      this.o = o.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link ForceEqualsInWithers#l() l} list.
     * @param element A l element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addL(int element) {
      this.l.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ForceEqualsInWithers#l() l} list.
     * @param elements An array of l elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addL(int... elements) {
      this.l.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ForceEqualsInWithers#l() l} list.
     * @param elements An iterable of l elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder l(Iterable<Integer> elements) {
      this.l = ImmutableList.builder();
      return addAllL(elements);
    }

    /**
     * Adds elements to {@link ForceEqualsInWithers#l() l} list.
     * @param elements An iterable of l elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllL(Iterable<Integer> elements) {
      this.l.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link ForceEqualsInWithers#st() st} set.
     * @param element A st element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSt(String element) {
      if (this.st == null) {
        this.st = ImmutableSet.builder();
      }
      this.st.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ForceEqualsInWithers#st() st} set.
     * @param elements An array of st elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSt(String... elements) {
      if (this.st == null) {
        this.st = ImmutableSet.builder();
      }
      this.st.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ForceEqualsInWithers#st() st} set.
     * @param elements An iterable of st elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder st(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.st = null;
        return this;
      }
      this.st = ImmutableSet.builder();
      return addAllSt(elements);
    }

    /**
     * Adds elements to {@link ForceEqualsInWithers#st() st} set.
     * @param elements An iterable of st elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSt(Iterable<String> elements) {
      Objects.requireNonNull(elements, "st element");
      if (this.st == null) {
        this.st = ImmutableSet.builder();
      }
      this.st.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link ForceEqualsInWithers#mp() mp} map.
     * @param key The key in the mp map
     * @param value The associated value in the mp map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMp(String key, int value) {
      this.mp.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link ForceEqualsInWithers#mp() mp} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMp(Map.Entry<String, ? extends Integer> entry) {
      this.mp.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ForceEqualsInWithers#mp() mp} map. Nulls are not permitted
     * @param entries The entries that will be added to the mp map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mp(Map<String, ? extends Integer> entries) {
      this.mp = ImmutableMap.builder();
      return putAllMp(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ForceEqualsInWithers#mp() mp} map. Nulls are not permitted
     * @param entries The entries that will be added to the mp map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMp(Map<String, ? extends Integer> entries) {
      this.mp.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableForceEqualsInWithers ImmutableForceEqualsInWithers}.
     * @return An immutable instance of ForceEqualsInWithers
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableForceEqualsInWithers build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableForceEqualsInWithers(f, d, s, b, c, o, l.build(), st == null ? null : st.build(), mp.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_F) != 0) attributes.add("f");
      if ((initBits & INIT_BIT_D) != 0) attributes.add("d");
      if ((initBits & INIT_BIT_S) != 0) attributes.add("s");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      return "Cannot build ForceEqualsInWithers, some of required attributes are not set " + attributes;
    }
  }
}
