package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CanBuild}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new CanBuild.Builder()}.
 */
@Generated(from = "CanBuild", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCanBuild implements CanBuild {
  private final int a;
  private final @Nullable String b;

  private ImmutableCanBuild(int a, @Nullable String b) {
    this.a = a;
    this.b = b;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public Optional<String> b() {
    return Optional.ofNullable(b);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CanBuild#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCanBuild withA(int value) {
    if (this.a == value) return this;
    return new ImmutableCanBuild(value, this.b);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CanBuild#b() b} attribute.
   * @param value The value for b
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCanBuild withB(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "b");
    if (Objects.equals(this.b, newValue)) return this;
    return new ImmutableCanBuild(this.a, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CanBuild#b() b} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for b
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCanBuild withB(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.b, value)) return this;
    return new ImmutableCanBuild(this.a, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCanBuild} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCanBuild
        && equalTo(0, (ImmutableCanBuild) another);
  }

  private boolean equalTo(int synthetic, ImmutableCanBuild another) {
    return a == another.a
        && Objects.equals(b, another.b);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    h += (h << 5) + Objects.hashCode(b);
    return h;
  }

  /**
   * Prints the immutable value {@code CanBuild} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CanBuild")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CanBuild} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CanBuild instance
   */
  public static ImmutableCanBuild copyOf(CanBuild instance) {
    if (instance instanceof ImmutableCanBuild) {
      return (ImmutableCanBuild) instance;
    }
    return new CanBuild.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableCanBuild ImmutableCanBuild}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CanBuild", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private int a;
    private @Nullable String b;

    /**
     * Creates a builder for {@link ImmutableCanBuild ImmutableCanBuild} instances.
     * <pre>
     * new CanBuild.Builder()
     *    .a(int) // required {@link CanBuild#a() a}
     *    .b(String) // optional {@link CanBuild#b() b}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof CanBuild.Builder)) {
        throw new UnsupportedOperationException("Use: new CanBuild.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code CanBuild} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CanBuild.Builder from(CanBuild instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      Optional<String> bOptional = instance.b();
      if (bOptional.isPresent()) {
        b(bOptional);
      }
      return (CanBuild.Builder) this;
    }

    /**
     * Initializes the value for the {@link CanBuild#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CanBuild.Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return (CanBuild.Builder) this;
    }

    /**
     * Initializes the optional value {@link CanBuild#b() b} to b.
     * @param b The value for b
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final CanBuild.Builder b(String b) {
      this.b = Objects.requireNonNull(b, "b");
      return (CanBuild.Builder) this;
    }

    /**
     * Initializes the optional value {@link CanBuild#b() b} to b.
     * @param b The value for b
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final CanBuild.Builder b(Optional<String> b) {
      this.b = b.orElse(null);
      return (CanBuild.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableCanBuild ImmutableCanBuild}.
     * @return An immutable instance of CanBuild
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCanBuild build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCanBuild(a, b);
    }

    /**
     * If all required attributes are set and calling {@link #build()}
     * will return an instance and will not throw {@code IllegalStateException}.
     * @return {@code true} if all mandatory attributes are initialized
     */
    public boolean isBuilderCanBuild() {
      return initBits == 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build CanBuild, some of required attributes are not set " + attributes;
    }
  }
}
