package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BeanStyleDetected}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBeanStyleDetected.builder()}.
 */
@Generated(from = "BeanStyleDetected", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableBeanStyleDetected extends BeanStyleDetected {
  private final int it;
  private final ImmutableList<String> em;

  private ImmutableBeanStyleDetected(int it, ImmutableList<String> em) {
    this.it = it;
    this.em = em;
  }

  /**
   * @return The value of the {@code it} attribute
   */
  @Override
  int isIt() {
    return it;
  }

  /**
   * @return The value of the {@code em} attribute
   */
  @Override
  ImmutableList<String> getEm() {
    return em;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BeanStyleDetected#isIt() it} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for it
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBeanStyleDetected withIt(int value) {
    if (this.it == value) return this;
    return new ImmutableBeanStyleDetected(value, this.em);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BeanStyleDetected#getEm() em}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBeanStyleDetected withEm(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBeanStyleDetected(this.it, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BeanStyleDetected#getEm() em}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of em elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBeanStyleDetected withEm(Iterable<String> elements) {
    if (this.em == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableBeanStyleDetected(this.it, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBeanStyleDetected} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBeanStyleDetected
        && equalTo(0, (ImmutableBeanStyleDetected) another);
  }

  private boolean equalTo(int synthetic, ImmutableBeanStyleDetected another) {
    return it == another.it
        && em.equals(another.em);
  }

  /**
   * Computes a hash code from attributes: {@code it}, {@code em}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + it;
    h += (h << 5) + em.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BeanStyleDetected} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BeanStyleDetected")
        .omitNullValues()
        .add("it", it)
        .add("em", em)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link BeanStyleDetected} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BeanStyleDetected instance
   */
  public static ImmutableBeanStyleDetected copyOf(BeanStyleDetected instance) {
    if (instance instanceof ImmutableBeanStyleDetected) {
      return (ImmutableBeanStyleDetected) instance;
    }
    return ImmutableBeanStyleDetected.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBeanStyleDetected ImmutableBeanStyleDetected}.
   * <pre>
   * ImmutableBeanStyleDetected.builder()
   *    .setIt(int) // required {@link BeanStyleDetected#isIt() it}
   *    .addEm|addAllEm(String) // {@link BeanStyleDetected#getEm() em} elements
   *    .build();
   * </pre>
   * @return A new ImmutableBeanStyleDetected builder
   */
  public static ImmutableBeanStyleDetected.Builder builder() {
    return new ImmutableBeanStyleDetected.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBeanStyleDetected ImmutableBeanStyleDetected}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BeanStyleDetected", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_IT = 0x1L;
    private long initBits = 0x1L;

    private int it;
    private ImmutableList.Builder<String> em = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BeanStyleDetected} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BeanStyleDetected instance) {
      Objects.requireNonNull(instance, "instance");
      setIt(instance.isIt());
      addAllEm(instance.getEm());
      return this;
    }

    /**
     * Initializes the value for the {@link BeanStyleDetected#isIt() it} attribute.
     * @param it The value for it 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder setIt(int it) {
      this.it = it;
      initBits &= ~INIT_BIT_IT;
      return this;
    }

    /**
     * Adds one element to {@link BeanStyleDetected#getEm() em} list.
     * @param element A em element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEm(String element) {
      this.em.add(element);
      return this;
    }

    /**
     * Adds elements to {@link BeanStyleDetected#getEm() em} list.
     * @param elements An array of em elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEm(String... elements) {
      this.em.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BeanStyleDetected#getEm() em} list.
     * @param elements An iterable of em elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder setEm(Iterable<String> elements) {
      this.em = ImmutableList.builder();
      return addAllEm(elements);
    }

    /**
     * Adds elements to {@link BeanStyleDetected#getEm() em} list.
     * @param elements An iterable of em elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllEm(Iterable<String> elements) {
      this.em.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableBeanStyleDetected ImmutableBeanStyleDetected}.
     * @return An immutable instance of BeanStyleDetected
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBeanStyleDetected build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBeanStyleDetected(it, em.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_IT) != 0) attributes.add("it");
      return "Cannot build BeanStyleDetected, some of required attributes are not set " + attributes;
    }
  }
}
