package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.common.base.Ticker;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link com.google.common.base.Ticker}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImTicker.builder()}.
 */
@Generated(from = "com.google.common.base.Ticker", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImTicker extends Ticker {
  private final long read;

  private ImTicker(long read) {
    this.read = read;
  }

  /**
   * @return The value of the {@code read} attribute
   */
  @Override
  public long read() {
    return read;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link com.google.common.base.Ticker#read() read} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for read
   * @return A modified copy of the {@code this} object
   */
  public final ImTicker copyWithRead(long value) {
    if (this.read == value) return this;
    return new ImTicker(value);
  }

  /**
   * This instance is equal to all instances of {@code ImTicker} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImTicker
        && equalTo(0, (ImTicker) another);
  }

  private boolean equalTo(int synthetic, ImTicker another) {
    return read == another.read;
  }

  /**
   * Computes a hash code from attributes: {@code read}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Longs.hashCode(read);
    return h;
  }

  /**
   * Prints the immutable value {@code Ticker} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Ticker")
        .omitNullValues()
        .add("read", read)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link com.google.common.base.Ticker} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Ticker instance
   */
  public static ImTicker copyOf(Ticker instance) {
    if (instance instanceof ImTicker) {
      return (ImTicker) instance;
    }
    return ImTicker.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImTicker ImTicker}.
   * <pre>
   * ImTicker.builder()
   *    .read(long) // required {@link com.google.common.base.Ticker#read() read}
   *    .build();
   * </pre>
   * @return A new ImTicker builder
   */
  public static ImTicker.Builder builder() {
    return new ImTicker.Builder();
  }

  /**
   * Builds instances of type {@link ImTicker ImTicker}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "com.google.common.base.Ticker", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_READ = 0x1L;
    private long initBits = 0x1L;

    private long read;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Ticker} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Ticker instance) {
      Objects.requireNonNull(instance, "instance");
      read(instance.read());
      return this;
    }

    /**
     * Initializes the value for the {@link com.google.common.base.Ticker#read() read} attribute.
     * @param read The value for read 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder read(long read) {
      this.read = read;
      initBits &= ~INIT_BIT_READ;
      return this;
    }

    /**
     * Builds a new {@link ImTicker ImTicker}.
     * @return An immutable instance of Ticker
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImTicker build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImTicker(read);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_READ) != 0) attributes.add("read");
      return "Cannot build Ticker, some of required attributes are not set " + attributes;
    }
  }
}
