package org.immutables.fixture.style;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Builds instances of type {@link AInterfaceBuilder.ImmutableAInterface ImmutableAInterface}.
 * Initialize attributes and then invoke the {@link #build()} method to create an
 * immutable instance.
 * <p><em>{@code AInterfaceBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "AInterface", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
final class AInterfaceBuilder {
  private static final long INIT_BIT_STRING = 0x1L;
  private long initBits = 0x1L;

  private @Nullable String string;

  /**
   * Creates a builder for {@link AInterfaceBuilder.ImmutableAInterface ImmutableAInterface} instances.
   * <pre>
   * new AInterfaceBuilder()
   *    .string(String) // required {@link AInterface#getString() string}
   *    .build();
   * </pre>
   */
  AInterfaceBuilder() {
  }

  /**
   * Fill a builder with attribute values from the provided {@code AInterface} instance.
   * Regular attribute values will be replaced with those from the given instance.
   * Absent optional values will not replace present values.
   * @param instance The instance from which to copy values
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final AInterfaceBuilder from(AInterface instance) {
    Objects.requireNonNull(instance, "instance");
    string(instance.getString());
    return this;
  }

  /**
   * Initializes the value for the {@link AInterface#getString() string} attribute.
   * @param string The value for string 
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final AInterfaceBuilder string(String string) {
    this.string = Objects.requireNonNull(string, "string");
    initBits &= ~INIT_BIT_STRING;
    return this;
  }

  /**
   * Builds a new {@link AInterfaceBuilder.ImmutableAInterface ImmutableAInterface}.
   * @return An immutable instance of AInterface
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public ImmutableAInterface build() {
    if (initBits != 0) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
    return new AInterfaceBuilder.ImmutableAInterface(string);
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if ((initBits & INIT_BIT_STRING) != 0) attributes.add("string");
    return "Cannot build AInterface, some of required attributes are not set " + attributes;
  }

  /**
   * Immutable implementation of {@link AInterface}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code new AInterfaceBuilder()}.
   */
  @Generated(from = "AInterface", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  public static final class ImmutableAInterface implements AInterface {
    private final String string;

    private ImmutableAInterface(String string) {
      this.string = string;
    }

    /**
     * @return The value of the {@code string} attribute
     */
    @Override
    public String getString() {
      return string;
    }

    /**
     * Copy the current immutable object by setting a value for the {@link AInterface#getString() string} attribute.
     * An equals check used to prevent copying of the same value by returning {@code this}.
     * @param value A new value for string
     * @return A modified copy of the {@code this} object
     */
    public final AInterfaceBuilder.ImmutableAInterface withString(String value) {
      String newValue = Objects.requireNonNull(value, "string");
      if (this.string.equals(newValue)) return this;
      return new AInterfaceBuilder.ImmutableAInterface(newValue);
    }

    /**
     * This instance is equal to all instances of {@code ImmutableAInterface} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof AInterfaceBuilder.ImmutableAInterface
          && equalTo(0, (AInterfaceBuilder.ImmutableAInterface) another);
    }

    private boolean equalTo(int synthetic, AInterfaceBuilder.ImmutableAInterface another) {
      return string.equals(another.string);
    }

    /**
     * Computes a hash code from attributes: {@code string}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + string.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code AInterface} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return MoreObjects.toStringHelper("AInterface")
          .omitNullValues()
          .add("string", string)
          .toString();
    }

    /**
     * Creates an immutable copy of a {@link AInterface} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable AInterface instance
     */
    public static AInterfaceBuilder.ImmutableAInterface copyOf(AInterface instance) {
      if (instance instanceof AInterfaceBuilder.ImmutableAInterface) {
        return (AInterfaceBuilder.ImmutableAInterface) instance;
      }
      return new AInterfaceBuilder()
          .from(instance)
          .build();
    }
  }
}
