package org.immutables.fixture.serial;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ClazzSerializable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableClazzSerializable.builder()}.
 */
@Generated(from = "ClazzSerializable", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableClazzSerializable extends ClazzSerializable {
  private final Object obj;

  private ImmutableClazzSerializable(Object obj) {
    this.obj = obj;
  }

  /**
   * @return The value of the {@code obj} attribute
   */
  @JsonProperty("obj")
  @Override
  public Object obj() {
    return obj;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ClazzSerializable#obj() obj} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for obj
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableClazzSerializable withObj(Object value) {
    if (this.obj == value) return this;
    Object newValue = Objects.requireNonNull(value, "obj");
    return new ImmutableClazzSerializable(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableClazzSerializable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableClazzSerializable
        && equalTo(0, (ImmutableClazzSerializable) another);
  }

  private boolean equalTo(int synthetic, ImmutableClazzSerializable another) {
    return obj.equals(another.obj);
  }

  /**
   * Computes a hash code from attributes: {@code obj}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + obj.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ClazzSerializable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ClazzSerializable")
        .omitNullValues()
        .add("obj", obj)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ClazzSerializable", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends ClazzSerializable {

    private static final long serialVersionUID = -8909894915412895697L;
    @Nullable Object obj;
    @JsonProperty("obj")
    public void setObj(Object obj) {
      this.obj = obj;
    }
    @Override
    public Object obj() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableClazzSerializable fromJson(Json json) {
    ImmutableClazzSerializable.Builder builder = ImmutableClazzSerializable.builder();
    if (json.obj != null) {
      builder.obj(json.obj);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ClazzSerializable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ClazzSerializable instance
   */
  public static ImmutableClazzSerializable copyOf(ClazzSerializable instance) {
    if (instance instanceof ImmutableClazzSerializable) {
      return (ImmutableClazzSerializable) instance;
    }
    return ImmutableClazzSerializable.builder()
        .from(instance)
        .build();
  }

  private static final long serialVersionUID = -8909894915412895697L;

  /**
   * The serialized form captures the structural content of the value object,
   * providing the ability to reconstruct values with the capability to migrate
   * data. Uses optional, nullable, and provides flexible handling of
   * collection attributes.
   */
  @Generated(from = "ClazzSerializable", generator = "Immutables")
  private static class SerialForm implements Serializable {
    private static final long serialVersionUID = -8909894915412895697L;
    private final String[] names;
    private final Object[] values;
    SerialForm(ImmutableClazzSerializable instance) {
      List<String> names = new ArrayList<>(1);
      List<Object> values = new ArrayList<>(1);
      names.add("obj");
      values.add(instance.obj());
      this.names = names.toArray(new String[names.size()]);
      this.values = values.toArray();
    }

    Object readResolve() {
      ImmutableClazzSerializable.Builder builder = ImmutableClazzSerializable.builder();

      for (int i = 0; i < names.length; i++) {
        String name = names[i];
        if ("obj".equals(name)) {
          builder.obj(toSingle("obj", values[i]));
          continue;
        }
      }
      return builder.build();
    }

    private static Object toSingle(String attribute, Object value) {
      if (value instanceof Object[]) {
        Object[] elements = (Object[]) value;
        if (elements.length == 1) {
          return elements[0];
        }
        throw new IllegalStateException("Cannot extract scalar value for attribute '"
            + attribute + "' from array of length " + elements.length);
      }
      return value;
    }
  }

  private Object writeReplace() {
    return new SerialForm(this);
  }

  /**
   * Creates a builder for {@link ImmutableClazzSerializable ImmutableClazzSerializable}.
   * <pre>
   * ImmutableClazzSerializable.builder()
   *    .obj(Object) // required {@link ClazzSerializable#obj() obj}
   *    .build();
   * </pre>
   * @return A new ImmutableClazzSerializable builder
   */
  public static ImmutableClazzSerializable.Builder builder() {
    return new ImmutableClazzSerializable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableClazzSerializable ImmutableClazzSerializable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ClazzSerializable", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_OBJ = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Object obj;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ClazzSerializable} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ClazzSerializable instance) {
      Objects.requireNonNull(instance, "instance");
      obj(instance.obj());
      return this;
    }

    /**
     * Initializes the value for the {@link ClazzSerializable#obj() obj} attribute.
     * @param obj The value for obj 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder obj(Object obj) {
      this.obj = Objects.requireNonNull(obj, "obj");
      initBits &= ~INIT_BIT_OBJ;
      return this;
    }

    /**
     * Builds a new {@link ImmutableClazzSerializable ImmutableClazzSerializable}.
     * @return An immutable instance of ClazzSerializable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableClazzSerializable build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableClazzSerializable(obj);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_OBJ) != 0) attributes.add("obj");
      return "Cannot build ClazzSerializable, some of required attributes are not set " + attributes;
    }
  }
}
