package org.immutables.fixture.parcelable;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ParcVal}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableParcVal.builder()}.
 */
@Generated(from = "ParcVal", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableParcVal implements ParcVal {
  private final String a;
  private final byte b;
  private final char c;
  private final double d;
  private final boolean e;
  private final float f;
  private final long g;
  private final short h;
  private final int i;
  private final String[] aa;
  private final byte[] ab;
  private final char[] ac;
  private final double[] ad;
  private final boolean[] ae;
  private final float[] af;
  private final long[] ag;
  private final short[] ah;
  private final int[] ai;
  private final Object[] ao;
  private final @Nullable Integer oi;
  private final @Nullable Double od;

  private ImmutableParcVal(
      String a,
      byte b,
      char c,
      double d,
      boolean e,
      float f,
      long g,
      short h,
      int i,
      String[] aa,
      byte[] ab,
      char[] ac,
      double[] ad,
      boolean[] ae,
      float[] af,
      long[] ag,
      short[] ah,
      int[] ai,
      Object[] ao,
      @Nullable Integer oi,
      @Nullable Double od) {
    this.a = a;
    this.b = b;
    this.c = c;
    this.d = d;
    this.e = e;
    this.f = f;
    this.g = g;
    this.h = h;
    this.i = i;
    this.aa = aa;
    this.ab = ab;
    this.ac = ac;
    this.ad = ad;
    this.ae = ae;
    this.af = af;
    this.ag = ag;
    this.ah = ah;
    this.ai = ai;
    this.ao = ao;
    this.oi = oi;
    this.od = od;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public String a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public byte b() {
    return b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public char c() {
    return c;
  }

  /**
   * @return The value of the {@code d} attribute
   */
  @Override
  public double d() {
    return d;
  }

  /**
   * @return The value of the {@code e} attribute
   */
  @Override
  public boolean e() {
    return e;
  }

  /**
   * @return The value of the {@code f} attribute
   */
  @Override
  public float f() {
    return f;
  }

  /**
   * @return The value of the {@code g} attribute
   */
  @Override
  public long g() {
    return g;
  }

  /**
   * @return The value of the {@code h} attribute
   */
  @Override
  public short h() {
    return h;
  }

  /**
   * @return The value of the {@code i} attribute
   */
  @Override
  public int i() {
    return i;
  }

  /**
   * @return A cloned {@code aa} array
   */
  @Override
  public String[] aa() {
    return aa.clone();
  }

  /**
   * @return A cloned {@code ab} array
   */
  @Override
  public byte[] ab() {
    return ab.clone();
  }

  /**
   * @return A cloned {@code ac} array
   */
  @Override
  public char[] ac() {
    return ac.clone();
  }

  /**
   * @return A cloned {@code ad} array
   */
  @Override
  public double[] ad() {
    return ad.clone();
  }

  /**
   * @return A cloned {@code ae} array
   */
  @Override
  public boolean[] ae() {
    return ae.clone();
  }

  /**
   * @return A cloned {@code af} array
   */
  @Override
  public float[] af() {
    return af.clone();
  }

  /**
   * @return A cloned {@code ag} array
   */
  @Override
  public long[] ag() {
    return ag.clone();
  }

  /**
   * @return A cloned {@code ah} array
   */
  @Override
  public short[] ah() {
    return ah.clone();
  }

  /**
   * @return A cloned {@code ai} array
   */
  @Override
  public int[] ai() {
    return ai.clone();
  }

  /**
   * @return A cloned {@code ao} array
   */
  @Override
  public Object[] ao() {
    return ao.clone();
  }

  /**
   * @return The value of the {@code oi} attribute
   */
  @Override
  public Optional<Integer> oi() {
    return Optional.ofNullable(oi);
  }

  /**
   * @return The value of the {@code od} attribute
   */
  @Override
  public OptionalDouble od() {
    return od != null
        ? OptionalDouble.of(od)
        : OptionalDouble.empty();
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParcVal#a() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParcVal withA(String value) {
    String newValue = Objects.requireNonNull(value, "a");
    if (this.a.equals(newValue)) return this;
    return new ImmutableParcVal(
        newValue,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParcVal#b() b} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParcVal withB(byte value) {
    if (this.b == value) return this;
    return new ImmutableParcVal(
        this.a,
        value,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParcVal#c() c} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParcVal withC(char value) {
    if (this.c == value) return this;
    return new ImmutableParcVal(
        this.a,
        this.b,
        value,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParcVal#d() d} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for d
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParcVal withD(double value) {
    if (Double.doubleToLongBits(this.d) == Double.doubleToLongBits(value)) return this;
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        value,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParcVal#e() e} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for e
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParcVal withE(boolean value) {
    if (this.e == value) return this;
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        value,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParcVal#f() f} attribute.
   * A value strict bits equality used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for f
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParcVal withF(float value) {
    if (Float.floatToIntBits(this.f) == Float.floatToIntBits(value)) return this;
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        value,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParcVal#g() g} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for g
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParcVal withG(long value) {
    if (this.g == value) return this;
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        value,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParcVal#h() h} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for h
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParcVal withH(short value) {
    if (this.h == value) return this;
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        value,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ParcVal#i() i} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for i
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableParcVal withI(int value) {
    if (this.i == value) return this;
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        value,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParcVal#aa() aa}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for aa
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParcVal withAa(String... elements) {
    String[] newValue = elements.clone();
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        newValue,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParcVal#ab() ab}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for ab
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParcVal withAb(byte... elements) {
    byte[] newValue = elements.clone();
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        newValue,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParcVal#ac() ac}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for ac
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParcVal withAc(char... elements) {
    char[] newValue = elements.clone();
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        newValue,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParcVal#ad() ad}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for ad
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParcVal withAd(double... elements) {
    double[] newValue = elements.clone();
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        newValue,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParcVal#ae() ae}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for ae
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParcVal withAe(boolean... elements) {
    boolean[] newValue = elements.clone();
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        newValue,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParcVal#af() af}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for af
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParcVal withAf(float... elements) {
    float[] newValue = elements.clone();
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        newValue,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParcVal#ag() ag}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for ag
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParcVal withAg(long... elements) {
    long[] newValue = elements.clone();
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        newValue,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParcVal#ah() ah}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for ah
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParcVal withAh(short... elements) {
    short[] newValue = elements.clone();
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        newValue,
        this.ai,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParcVal#ai() ai}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for ai
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParcVal withAi(int... elements) {
    int[] newValue = elements.clone();
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        newValue,
        this.ao,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ParcVal#ao() ao}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for ao
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParcVal withAo(Object... elements) {
    Object[] newValue = elements.clone();
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        newValue,
        this.oi,
        this.od);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ParcVal#oi() oi} attribute.
   * @param value The value for oi
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParcVal withOi(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.oi, newValue)) return this;
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        newValue,
        this.od);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ParcVal#oi() oi} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for oi
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParcVal withOi(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.oi, value)) return this;
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        value,
        this.od);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ParcVal#od() od} attribute.
   * @param value The value for od
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParcVal withOd(double value) {
    @Nullable Double newValue = value;
    if (Objects.equals(this.od, newValue)) return this;
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ParcVal#od() od} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for od
   * @return A modified copy of {@code this} object
   */
  public final ImmutableParcVal withOd(OptionalDouble optional) {
    @Nullable Double value = optional.isPresent() ? optional.getAsDouble() : null;
    if (Objects.equals(this.od, value)) return this;
    return new ImmutableParcVal(
        this.a,
        this.b,
        this.c,
        this.d,
        this.e,
        this.f,
        this.g,
        this.h,
        this.i,
        this.aa,
        this.ab,
        this.ac,
        this.ad,
        this.ae,
        this.af,
        this.ag,
        this.ah,
        this.ai,
        this.ao,
        this.oi,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableParcVal} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableParcVal
        && equalTo(0, (ImmutableParcVal) another);
  }

  private boolean equalTo(int synthetic, ImmutableParcVal another) {
    return a.equals(another.a)
        && b == another.b
        && c == another.c
        && Double.doubleToLongBits(d) == Double.doubleToLongBits(another.d)
        && e == another.e
        && Float.floatToIntBits(f) == Float.floatToIntBits(another.f)
        && g == another.g
        && h == another.h
        && i == another.i
        && Arrays.equals(aa, another.aa)
        && Arrays.equals(ab, another.ab)
        && Arrays.equals(ac, another.ac)
        && Arrays.equals(ad, another.ad)
        && Arrays.equals(ae, another.ae)
        && Arrays.equals(af, another.af)
        && Arrays.equals(ag, another.ag)
        && Arrays.equals(ah, another.ah)
        && Arrays.equals(ai, another.ai)
        && Arrays.equals(ao, another.ao)
        && Objects.equals(oi, another.oi)
        && Objects.equals(od, another.od);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code c}, {@code d}, {@code e}, {@code f}, {@code g}, {@code h}, {@code i}, {@code aa}, {@code ab}, {@code ac}, {@code ad}, {@code ae}, {@code af}, {@code ag}, {@code ah}, {@code ai}, {@code ao}, {@code oi}, {@code od}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h$$ = 5381;
    h$$ += (h$$ << 5) + a.hashCode();
    h$$ += (h$$ << 5) + Byte.hashCode(b);
    h$$ += (h$$ << 5) + Character.hashCode(c);
    h$$ += (h$$ << 5) + Double.hashCode(d);
    h$$ += (h$$ << 5) + Boolean.hashCode(e);
    h$$ += (h$$ << 5) + Float.hashCode(f);
    h$$ += (h$$ << 5) + Long.hashCode(g);
    h$$ += (h$$ << 5) + Short.hashCode(h);
    h$$ += (h$$ << 5) + i;
    h$$ += (h$$ << 5) + Arrays.hashCode(aa);
    h$$ += (h$$ << 5) + Arrays.hashCode(ab);
    h$$ += (h$$ << 5) + Arrays.hashCode(ac);
    h$$ += (h$$ << 5) + Arrays.hashCode(ad);
    h$$ += (h$$ << 5) + Arrays.hashCode(ae);
    h$$ += (h$$ << 5) + Arrays.hashCode(af);
    h$$ += (h$$ << 5) + Arrays.hashCode(ag);
    h$$ += (h$$ << 5) + Arrays.hashCode(ah);
    h$$ += (h$$ << 5) + Arrays.hashCode(ai);
    h$$ += (h$$ << 5) + Arrays.hashCode(ao);
    h$$ += (h$$ << 5) + Objects.hashCode(oi);
    h$$ += (h$$ << 5) + Objects.hashCode(od);
    return h$$;
  }

  /**
   * Prints the immutable value {@code ParcVal} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ParcVal{");
    builder.append("a=").append(a);
    builder.append(", ");
    builder.append("b=").append(b);
    builder.append(", ");
    builder.append("c=").append(c);
    builder.append(", ");
    builder.append("d=").append(d);
    builder.append(", ");
    builder.append("e=").append(e);
    builder.append(", ");
    builder.append("f=").append(f);
    builder.append(", ");
    builder.append("g=").append(g);
    builder.append(", ");
    builder.append("h=").append(h);
    builder.append(", ");
    builder.append("i=").append(i);
    builder.append(", ");
    builder.append("aa=").append(Arrays.toString(aa));
    builder.append(", ");
    builder.append("ab=").append(Arrays.toString(ab));
    builder.append(", ");
    builder.append("ac=").append(Arrays.toString(ac));
    builder.append(", ");
    builder.append("ad=").append(Arrays.toString(ad));
    builder.append(", ");
    builder.append("ae=").append(Arrays.toString(ae));
    builder.append(", ");
    builder.append("af=").append(Arrays.toString(af));
    builder.append(", ");
    builder.append("ag=").append(Arrays.toString(ag));
    builder.append(", ");
    builder.append("ah=").append(Arrays.toString(ah));
    builder.append(", ");
    builder.append("ai=").append(Arrays.toString(ai));
    builder.append(", ");
    builder.append("ao=").append(Arrays.toString(ao));
    if (oi != null) {
      builder.append(", ");
      builder.append("oi=").append(oi);
    }
    if (od != null) {
      builder.append(", ");
      builder.append("od=").append(od);
    }
    return builder.append("}").toString();
  }

  /** */
  public static final Parcelable.ClassLoaderCreator<ImmutableParcVal> CREATOR =
      new Parcelable.ClassLoaderCreator<ImmutableParcVal>() {
        public ImmutableParcVal createFromParcel(Parcel in) {
          return createFromParcel(in, this.getClass().getClassLoader());
        }

        @SuppressWarnings("unchecked") 
        public ImmutableParcVal createFromParcel(Parcel in, ClassLoader classLoader) {
          ImmutableParcVal.Builder builder = ImmutableParcVal.builder();
          builder.a(in.readString());
          builder.b(in.readByte());
          builder.c((char) in.readInt());
          builder.d(in.readDouble());
          builder.e(in.readByte() != 0);
          builder.f(in.readFloat());
          builder.g(in.readLong());
          builder.h((short) in.readInt());
          builder.i(in.readInt());
          builder.aa(in.createStringArray());
          builder.ab(in.createByteArray());
          builder.ac(in.createCharArray());
          builder.ad(in.createDoubleArray());
          builder.ae(in.createBooleanArray());
          builder.af(in.createFloatArray());
          builder.ag(in.createLongArray());
          builder.ah(null/* FIXME: Do something with short arrays */);
          builder.ai(in.createIntArray());
          builder.ao((Object[]) in.readArray(classLoader));
          @Nullable Integer oiValue = (Integer) in.readValue(classLoader);
          if (oiValue != null) {
            builder.oi(oiValue);
          }
          @Nullable Double odValue = (Double) in.readValue(classLoader);
          if (odValue != null) {
            builder.od(odValue);
          }
          return builder.build();
        }

        public ImmutableParcVal[] newArray(int size) {
          return new ImmutableParcVal[size];
        }
      };

  /** */
  @Override
  public int describeContents() {
    return 0; //??
  }

  /** */
  @Override
  public void writeToParcel(Parcel out, int flags) {
    out.writeString(this.a);
    out.writeByte(this.b);
    out.writeInt(this.c);
    out.writeDouble(this.d);
    out.writeByte(this.e ? (byte) 1 : (byte) 0);
    out.writeFloat(this.f);
    out.writeLong(this.g);
    out.writeInt(this.h);
    out.writeInt(this.i);
    out.writeStringArray(this.aa);
    out.writeByteArray(this.ab);
    out.writeCharArray(this.ac);
    out.writeDoubleArray(this.ad);
    out.writeBooleanArray(this.ae);
    out.writeFloatArray(this.af);
    out.writeLongArray(this.ag);
    // Do something with short arrays, just for completeness
    // copy it as int array, I dunno
    out.writeIntArray(this.ai);
    out.writeArray(this.ao);
    out.writeValue(this.oi);
    out.writeValue(this.od);
  }

  /**
   * Creates an immutable copy of a {@link ParcVal} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ParcVal instance
   */
  public static ImmutableParcVal copyOf(ParcVal instance) {
    if (instance instanceof ImmutableParcVal) {
      return (ImmutableParcVal) instance;
    }
    return ImmutableParcVal.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableParcVal ImmutableParcVal}.
   * <pre>
   * ImmutableParcVal.builder()
   *    .a(String) // required {@link ParcVal#a() a}
   *    .b(byte) // required {@link ParcVal#b() b}
   *    .c(char) // required {@link ParcVal#c() c}
   *    .d(double) // required {@link ParcVal#d() d}
   *    .e(boolean) // required {@link ParcVal#e() e}
   *    .f(float) // required {@link ParcVal#f() f}
   *    .g(long) // required {@link ParcVal#g() g}
   *    .h(short) // required {@link ParcVal#h() h}
   *    .i(int) // required {@link ParcVal#i() i}
   *    .aa(String) // required {@link ParcVal#aa() aa}
   *    .ab(byte) // required {@link ParcVal#ab() ab}
   *    .ac(char) // required {@link ParcVal#ac() ac}
   *    .ad(double) // required {@link ParcVal#ad() ad}
   *    .ae(boolean) // required {@link ParcVal#ae() ae}
   *    .af(float) // required {@link ParcVal#af() af}
   *    .ag(long) // required {@link ParcVal#ag() ag}
   *    .ah(short) // required {@link ParcVal#ah() ah}
   *    .ai(int) // required {@link ParcVal#ai() ai}
   *    .ao(Object) // required {@link ParcVal#ao() ao}
   *    .oi(Integer) // optional {@link ParcVal#oi() oi}
   *    .od(double) // optional {@link ParcVal#od() od}
   *    .build();
   * </pre>
   * @return A new ImmutableParcVal builder
   */
  public static ImmutableParcVal.Builder builder() {
    return new ImmutableParcVal.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableParcVal ImmutableParcVal}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ParcVal", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long INIT_BIT_B = 0x2L;
    private static final long INIT_BIT_C = 0x4L;
    private static final long INIT_BIT_D = 0x8L;
    private static final long INIT_BIT_E = 0x10L;
    private static final long INIT_BIT_F = 0x20L;
    private static final long INIT_BIT_G = 0x40L;
    private static final long INIT_BIT_H = 0x80L;
    private static final long INIT_BIT_I = 0x100L;
    private static final long INIT_BIT_AA = 0x200L;
    private static final long INIT_BIT_AB = 0x400L;
    private static final long INIT_BIT_AC = 0x800L;
    private static final long INIT_BIT_AD = 0x1000L;
    private static final long INIT_BIT_AE = 0x2000L;
    private static final long INIT_BIT_AF = 0x4000L;
    private static final long INIT_BIT_AG = 0x8000L;
    private static final long INIT_BIT_AH = 0x10000L;
    private static final long INIT_BIT_AI = 0x20000L;
    private static final long INIT_BIT_AO = 0x40000L;
    private long initBits = 0x7ffffL;

    private @Nullable String a;
    private byte b;
    private char c;
    private double d;
    private boolean e;
    private float f;
    private long g;
    private short h;
    private int i;
    private @Nullable String[] aa;
    private @Nullable byte[] ab;
    private @Nullable char[] ac;
    private @Nullable double[] ad;
    private @Nullable boolean[] ae;
    private @Nullable float[] af;
    private @Nullable long[] ag;
    private @Nullable short[] ah;
    private @Nullable int[] ai;
    private @Nullable Object[] ao;
    private @Nullable Integer oi;
    private @Nullable Double od;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ParcVal} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ParcVal instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      b(instance.b());
      c(instance.c());
      d(instance.d());
      e(instance.e());
      f(instance.f());
      g(instance.g());
      h(instance.h());
      i(instance.i());
      aa(instance.aa());
      ab(instance.ab());
      ac(instance.ac());
      ad(instance.ad());
      ae(instance.ae());
      af(instance.af());
      ag(instance.ag());
      ah(instance.ah());
      ai(instance.ai());
      ao(instance.ao());
      Optional<Integer> oiOptional = instance.oi();
      if (oiOptional.isPresent()) {
        oi(oiOptional);
      }
      OptionalDouble odOptional = instance.od();
      if (odOptional.isPresent()) {
        od(odOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(String a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#b() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(byte b) {
      this.b = b;
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#c() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(char c) {
      this.c = c;
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#d() d} attribute.
     * @param d The value for d 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder d(double d) {
      this.d = d;
      initBits &= ~INIT_BIT_D;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#e() e} attribute.
     * @param e The value for e 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder e(boolean e) {
      this.e = e;
      initBits &= ~INIT_BIT_E;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#f() f} attribute.
     * @param f The value for f 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder f(float f) {
      this.f = f;
      initBits &= ~INIT_BIT_F;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#g() g} attribute.
     * @param g The value for g 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder g(long g) {
      this.g = g;
      initBits &= ~INIT_BIT_G;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#h() h} attribute.
     * @param h The value for h 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder h(short h) {
      this.h = h;
      initBits &= ~INIT_BIT_H;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#i() i} attribute.
     * @param i The value for i 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder i(int i) {
      this.i = i;
      initBits &= ~INIT_BIT_I;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#aa() aa} attribute.
     * @param aa The elements for aa
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder aa(String... aa) {
      this.aa = aa.clone();
      initBits &= ~INIT_BIT_AA;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#ab() ab} attribute.
     * @param ab The elements for ab
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ab(byte... ab) {
      this.ab = ab.clone();
      initBits &= ~INIT_BIT_AB;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#ac() ac} attribute.
     * @param ac The elements for ac
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ac(char... ac) {
      this.ac = ac.clone();
      initBits &= ~INIT_BIT_AC;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#ad() ad} attribute.
     * @param ad The elements for ad
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ad(double... ad) {
      this.ad = ad.clone();
      initBits &= ~INIT_BIT_AD;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#ae() ae} attribute.
     * @param ae The elements for ae
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ae(boolean... ae) {
      this.ae = ae.clone();
      initBits &= ~INIT_BIT_AE;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#af() af} attribute.
     * @param af The elements for af
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder af(float... af) {
      this.af = af.clone();
      initBits &= ~INIT_BIT_AF;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#ag() ag} attribute.
     * @param ag The elements for ag
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ag(long... ag) {
      this.ag = ag.clone();
      initBits &= ~INIT_BIT_AG;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#ah() ah} attribute.
     * @param ah The elements for ah
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ah(short... ah) {
      this.ah = ah.clone();
      initBits &= ~INIT_BIT_AH;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#ai() ai} attribute.
     * @param ai The elements for ai
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ai(int... ai) {
      this.ai = ai.clone();
      initBits &= ~INIT_BIT_AI;
      return this;
    }

    /**
     * Initializes the value for the {@link ParcVal#ao() ao} attribute.
     * @param ao The elements for ao
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ao(Object... ao) {
      this.ao = ao.clone();
      initBits &= ~INIT_BIT_AO;
      return this;
    }

    /**
     * Initializes the optional value {@link ParcVal#oi() oi} to oi.
     * @param oi The value for oi
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder oi(int oi) {
      this.oi = oi;
      return this;
    }

    /**
     * Initializes the optional value {@link ParcVal#oi() oi} to oi.
     * @param oi The value for oi
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder oi(Optional<Integer> oi) {
      this.oi = oi.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link ParcVal#od() od} to od.
     * @param od The value for od
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder od(double od) {
      this.od = od;
      return this;
    }

    /**
     * Initializes the optional value {@link ParcVal#od() od} to od.
     * @param od The value for od
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder od(OptionalDouble od) {
      this.od = od.isPresent() ? od.getAsDouble() : null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableParcVal ImmutableParcVal}.
     * @return An immutable instance of ParcVal
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableParcVal build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableParcVal(a, b, c, d, e, f, g, h, i, aa, ab, ac, ad, ae, af, ag, ah, ai, ao, oi, od);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      if ((initBits & INIT_BIT_D) != 0) attributes.add("d");
      if ((initBits & INIT_BIT_E) != 0) attributes.add("e");
      if ((initBits & INIT_BIT_F) != 0) attributes.add("f");
      if ((initBits & INIT_BIT_G) != 0) attributes.add("g");
      if ((initBits & INIT_BIT_H) != 0) attributes.add("h");
      if ((initBits & INIT_BIT_I) != 0) attributes.add("i");
      if ((initBits & INIT_BIT_AA) != 0) attributes.add("aa");
      if ((initBits & INIT_BIT_AB) != 0) attributes.add("ab");
      if ((initBits & INIT_BIT_AC) != 0) attributes.add("ac");
      if ((initBits & INIT_BIT_AD) != 0) attributes.add("ad");
      if ((initBits & INIT_BIT_AE) != 0) attributes.add("ae");
      if ((initBits & INIT_BIT_AF) != 0) attributes.add("af");
      if ((initBits & INIT_BIT_AG) != 0) attributes.add("ag");
      if ((initBits & INIT_BIT_AH) != 0) attributes.add("ah");
      if ((initBits & INIT_BIT_AI) != 0) attributes.add("ai");
      if ((initBits & INIT_BIT_AO) != 0) attributes.add("ao");
      return "Cannot build ParcVal, some of required attributes are not set " + attributes;
    }
  }
}
