package org.immutables.fixture.parcelable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CustomParcelable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCustomParcelable.builder()}.
 */
@Generated(from = "CustomParcelable", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCustomParcelable extends CustomParcelable {

  private ImmutableCustomParcelable(ImmutableCustomParcelable.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCustomParcelable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCustomParcelable
        && equalTo(0, (ImmutableCustomParcelable) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableCustomParcelable another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 1613258438;
  }

  /**
   * Prints the immutable value {@code CustomParcelable}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CustomParcelable{}";
  }

  /**
   * Creates an immutable copy of a {@link CustomParcelable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CustomParcelable instance
   */
  public static ImmutableCustomParcelable copyOf(CustomParcelable instance) {
    if (instance instanceof ImmutableCustomParcelable) {
      return (ImmutableCustomParcelable) instance;
    }
    return ImmutableCustomParcelable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCustomParcelable ImmutableCustomParcelable}.
   * <pre>
   * ImmutableCustomParcelable.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableCustomParcelable builder
   */
  public static ImmutableCustomParcelable.Builder builder() {
    return new ImmutableCustomParcelable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCustomParcelable ImmutableCustomParcelable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CustomParcelable", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CustomParcelable} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CustomParcelable instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableCustomParcelable ImmutableCustomParcelable}.
     * @return An immutable instance of CustomParcelable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCustomParcelable build() {
      return new ImmutableCustomParcelable(this);
    }
  }
}
