package org.immutables.fixture.nullable;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NullableCompact}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNullableCompact.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableNullableCompact.of()}.
 */
@Generated(from = "NullableCompact", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNullableCompact extends NullableCompact {
  private final @Nullable Integer[] array;
  private final @Nullable ImmutableMap<String, Object> map;

  private ImmutableNullableCompact(
      @Nullable Integer[] array,
      @Nullable Map<String, ? extends Object> map) {
    this.array = array;
    this.map = map == null ? null : ImmutableMap.copyOf(map);
  }

  private ImmutableNullableCompact(
      ImmutableNullableCompact original,
      @Nullable Integer[] array,
      @Nullable ImmutableMap<String, Object> map) {
    this.array = array;
    this.map = map;
  }

  /**
   * @return A cloned {@code array} array
   */
  @JsonProperty("array")
  @Override
  public @Nullable Integer[] array() {
    return array;
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @JsonProperty("map")
  @Override
  public @Nullable ImmutableMap<String, Object> map() {
    return map;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullableCompact#array() array}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for array
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableCompact withArray(@Nullable Integer... elements) {
    @Nullable Integer[] newValue = elements == null ? null : elements.clone();
    return new ImmutableNullableCompact(this, newValue, this.map);
  }

  /**
   * Copy the current immutable object by replacing the {@link NullableCompact#map() map} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the map map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableCompact withMap(@Nullable Map<String, ? extends Object> entries) {
    if (this.map == entries) return this;
    @Nullable ImmutableMap<String, Object> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return new ImmutableNullableCompact(this, this.array, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNullableCompact} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNullableCompact
        && equalTo(0, (ImmutableNullableCompact) another);
  }

  private boolean equalTo(int synthetic, ImmutableNullableCompact another) {
    return Arrays.equals(array, another.array)
        && Objects.equals(map, another.map);
  }

  /**
   * Computes a hash code from attributes: {@code array}, {@code map}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Arrays.hashCode(array);
    h += (h << 5) + Objects.hashCode(map);
    return h;
  }

  /**
   * Prints the immutable value {@code NullableCompact} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NullableCompact")
        .omitNullValues()
        .add("array", Arrays.toString(array))
        .add("map", map)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "NullableCompact", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends NullableCompact {
    @Nullable Integer[] array;
    @Nullable Map<String, Object> map = null;
    @JsonProperty("array")
    public void setArray(@Nullable Integer[] array) {
      this.array = array;
    }
    @JsonProperty("map")
    public void setMap(@Nullable Map<String, Object> map) {
      this.map = map;
    }
    @Override
    public Integer[] array() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> map() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableNullableCompact fromJson(Json json) {
    ImmutableNullableCompact.Builder builder = ImmutableNullableCompact.builder();
    if (json.array != null) {
      builder.array(json.array);
    }
    if (json.map != null) {
      builder.putAllMap(json.map);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code NullableCompact} instance.
   * @param array The value for the {@code array} attribute
   * @param map The value for the {@code map} attribute
   * @return An immutable NullableCompact instance
   */
  public static ImmutableNullableCompact of(@Nullable Integer[] array, @Nullable Map<String, ? extends Object> map) {
    return new ImmutableNullableCompact(array, map);
  }

  /**
   * Creates an immutable copy of a {@link NullableCompact} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NullableCompact instance
   */
  public static ImmutableNullableCompact copyOf(NullableCompact instance) {
    if (instance instanceof ImmutableNullableCompact) {
      return (ImmutableNullableCompact) instance;
    }
    return ImmutableNullableCompact.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNullableCompact ImmutableNullableCompact}.
   * <pre>
   * ImmutableNullableCompact.builder()
   *    .array(Integer[] | null) // nullable {@link NullableCompact#array() array}
   *    .map(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link NullableCompact#map() map}
   *    .build();
   * </pre>
   * @return A new ImmutableNullableCompact builder
   */
  public static ImmutableNullableCompact.Builder builder() {
    return new ImmutableNullableCompact.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNullableCompact ImmutableNullableCompact}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NullableCompact", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Integer[] array;
    private ImmutableMap.Builder<String, Object> map = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NullableCompact} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NullableCompact instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Integer[] arrayValue = instance.array();
      if (arrayValue != null) {
        array(arrayValue);
      }
      @Nullable Map<String, Object> mapValue = instance.map();
      if (mapValue != null) {
        putAllMap(mapValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link NullableCompact#array() array} attribute.
     * @param array The elements for array
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("array")
    public final Builder array(Integer... array) {
      this.array = array;
      return this;
    }

    /**
     * Put one entry to the {@link NullableCompact#map() map} map.
     * @param key The key in the map map
     * @param value The associated value in the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(String key, Object value) {
      if (this.map == null) {
        this.map = ImmutableMap.builder();
      }
      this.map.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link NullableCompact#map() map} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(Map.Entry<String, ? extends Object> entry) {
      if (this.map == null) {
        this.map = ImmutableMap.builder();
      }
      this.map.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NullableCompact#map() map} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("map")
    public final Builder map(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.map = null;
        return this;
      }
      this.map = ImmutableMap.builder();
      return putAllMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NullableCompact#map() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMap(Map<String, ? extends Object> entries) {
      if (this.map == null) {
        this.map = ImmutableMap.builder();
      }
      this.map.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableNullableCompact ImmutableNullableCompact}.
     * @return An immutable instance of NullableCompact
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNullableCompact build() {
      return new ImmutableNullableCompact(null, array, map == null ? null : map.build());
    }
  }
}
