package org.immutables.fixture.nullable;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NullableAttributes}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNullableAttributes.builder()}.
 */
@Generated(from = "NullableAttributes", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNullableAttributes implements NullableAttributes {
  private final @Nullable Integer integer;
  private final @Nullable ImmutableList<String> list;
  private final @Nullable ImmutableSet<Integer> set;
  private final @Nullable Integer[] array;
  private final @Nullable Double[] defArray;
  private final @Nullable ImmutableMap<String, Object> map;

  private ImmutableNullableAttributes(ImmutableNullableAttributes.Builder builder) {
    this.integer = builder.integer;
    this.list = builder.list == null ? null : builder.list.build();
    this.array = builder.array;
    this.map = builder.map == null ? null : builder.map.build();
    if (builder.setIsSet()) {
      initShim.set(builder.set == null ? null : builder.set.build());
    }
    if (builder.defArrayIsSet()) {
      initShim.defArray(builder.defArray);
    }
    this.set = initShim.set();
    this.defArray = initShim.defArray();
    this.initShim = null;
  }

  private ImmutableNullableAttributes(
      @Nullable Integer integer,
      @Nullable ImmutableList<String> list,
      @Nullable ImmutableSet<Integer> set,
      @Nullable Integer[] array,
      @Nullable Double[] defArray,
      @Nullable ImmutableMap<String, Object> map) {
    this.integer = integer;
    this.list = list;
    this.set = set;
    this.array = array;
    this.defArray = defArray;
    this.map = map;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "NullableAttributes", generator = "Immutables")
  private final class InitShim {
    private byte setBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<Integer> set;

    ImmutableSet<Integer> set() {
      if (setBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (setBuildStage == STAGE_UNINITIALIZED) {
        setBuildStage = STAGE_INITIALIZING;
        this.set = setInitialize() == null ? null : ImmutableSet.copyOf(setInitialize());
        setBuildStage = STAGE_INITIALIZED;
      }
      return this.set;
    }

    void set(ImmutableSet<Integer> set) {
      this.set = set;
      setBuildStage = STAGE_INITIALIZED;
    }

    private byte defArrayBuildStage = STAGE_UNINITIALIZED;
    private Double[] defArray;

    Double[] defArray() {
      if (defArrayBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defArrayBuildStage == STAGE_UNINITIALIZED) {
        defArrayBuildStage = STAGE_INITIALIZING;
        this.defArray = defArrayInitialize();
        defArrayBuildStage = STAGE_INITIALIZED;
      }
      return this.defArray;
    }

    void defArray(Double[] defArray) {
      this.defArray = defArray;
      defArrayBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (setBuildStage == STAGE_INITIALIZING) attributes.add("set");
      if (defArrayBuildStage == STAGE_INITIALIZING) attributes.add("defArray");
      return "Cannot build NullableAttributes, attribute initializers form cycle " + attributes;
    }
  }

  private @Nullable Set<Integer> setInitialize() {
    return NullableAttributes.super.set();
  }

  private @Nullable Double[] defArrayInitialize() {
    return NullableAttributes.super.defArray();
  }

  /**
   * @return The value of the {@code integer} attribute
   */
  @JsonProperty("integer")
  @Override
  public @Nullable Integer integer() {
    return integer;
  }

  /**
   * @return The value of the {@code list} attribute
   */
  @JsonProperty("list")
  @Override
  public @Nullable ImmutableList<String> list() {
    return list;
  }

  /**
   * @return The value of the {@code set} attribute
   */
  @JsonProperty("set")
  @Override
  public @Nullable ImmutableSet<Integer> set() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.set()
        : this.set;
  }

  /**
   * @return A cloned {@code array} array
   */
  @JsonProperty("array")
  @Override
  public @Nullable Integer[] array() {
    return array;
  }

  /**
   * @return A cloned {@code defArray} array
   */
  @JsonProperty("defArray")
  @Override
  public @Nullable Double[] defArray() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.defArray()
        : this.defArray;
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @JsonProperty("map")
  @Override
  public @Nullable ImmutableMap<String, Object> map() {
    return map;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NullableAttributes#integer() integer} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for integer (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableNullableAttributes withInteger(@Nullable Integer value) {
    if (Objects.equals(this.integer, value)) return this;
    return new ImmutableNullableAttributes(value, this.list, this.set, this.array, this.defArray, this.map);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullableAttributes#list() list}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAttributes withList(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableNullableAttributes(this.integer, null, this.set, this.array, this.defArray, this.map);
    }
    @Nullable ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableNullableAttributes(this.integer, newValue, this.set, this.array, this.defArray, this.map);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullableAttributes#list() list}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of list elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAttributes withList(@Nullable Iterable<String> elements) {
    if (this.list == elements) return this;
    @Nullable ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableNullableAttributes(this.integer, newValue, this.set, this.array, this.defArray, this.map);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullableAttributes#set() set}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAttributes withSet(@Nullable int... elements) {
    if (elements == null) {
      return new ImmutableNullableAttributes(this.integer, this.list, null, this.array, this.defArray, this.map);
    }
    @Nullable ImmutableSet<Integer> newValue = Ints.asList(elements) == null ? null : ImmutableSet.copyOf(Ints.asList(elements));
    return new ImmutableNullableAttributes(this.integer, this.list, newValue, this.array, this.defArray, this.map);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullableAttributes#set() set}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of set elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAttributes withSet(@Nullable Iterable<Integer> elements) {
    if (this.set == elements) return this;
    @Nullable ImmutableSet<Integer> newValue = elements == null ? null : ImmutableSet.copyOf(elements);
    return new ImmutableNullableAttributes(this.integer, this.list, newValue, this.array, this.defArray, this.map);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullableAttributes#array() array}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for array
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAttributes withArray(@Nullable Integer... elements) {
    @Nullable Integer[] newValue = elements == null ? null : elements.clone();
    return new ImmutableNullableAttributes(this.integer, this.list, this.set, newValue, this.defArray, this.map);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NullableAttributes#defArray() defArray}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for defArray
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAttributes withDefArray(@Nullable Double... elements) {
    @Nullable Double[] newValue = elements == null ? null : elements.clone();
    return new ImmutableNullableAttributes(this.integer, this.list, this.set, this.array, newValue, this.map);
  }

  /**
   * Copy the current immutable object by replacing the {@link NullableAttributes#map() map} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the map map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNullableAttributes withMap(@Nullable Map<String, ? extends Object> entries) {
    if (this.map == entries) return this;
    @Nullable ImmutableMap<String, Object> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
    return new ImmutableNullableAttributes(this.integer, this.list, this.set, this.array, this.defArray, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNullableAttributes} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNullableAttributes
        && equalTo(0, (ImmutableNullableAttributes) another);
  }

  private boolean equalTo(int synthetic, ImmutableNullableAttributes another) {
    return Objects.equals(integer, another.integer)
        && Objects.equals(list, another.list)
        && Objects.equals(set, another.set)
        && Arrays.equals(array, another.array)
        && Arrays.equals(defArray, another.defArray)
        && Objects.equals(map, another.map);
  }

  /**
   * Computes a hash code from attributes: {@code integer}, {@code list}, {@code set}, {@code array}, {@code defArray}, {@code map}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(integer);
    h += (h << 5) + Objects.hashCode(list);
    h += (h << 5) + Objects.hashCode(set);
    h += (h << 5) + Arrays.hashCode(array);
    h += (h << 5) + Arrays.hashCode(defArray);
    h += (h << 5) + Objects.hashCode(map);
    return h;
  }

  /**
   * Prints the immutable value {@code NullableAttributes} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NullableAttributes")
        .omitNullValues()
        .add("integer", integer)
        .add("list", list)
        .add("set", set)
        .add("array", Arrays.toString(array))
        .add("defArray", Arrays.toString(defArray))
        .add("map", map)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "NullableAttributes", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements NullableAttributes {
    @Nullable Integer integer;
    @Nullable List<String> list = null;
    @Nullable Set<Integer> set = null;
    boolean setIsSet;
    @Nullable Integer[] array;
    @Nullable Double[] defArray;
    boolean defArrayIsSet;
    @Nullable Map<String, Object> map = null;
    @JsonProperty("integer")
    public void setInteger(@Nullable Integer integer) {
      this.integer = integer;
    }
    @JsonProperty("list")
    public void setList(@Nullable List<String> list) {
      this.list = list;
    }
    @JsonProperty("set")
    public void setSet(@Nullable Set<Integer> set) {
      this.set = set;
      this.setIsSet = true;
    }
    @JsonProperty("array")
    public void setArray(@Nullable Integer[] array) {
      this.array = array;
    }
    @JsonProperty("defArray")
    public void setDefArray(@Nullable Double[] defArray) {
      this.defArray = defArray;
      this.defArrayIsSet = true;
    }
    @JsonProperty("map")
    public void setMap(@Nullable Map<String, Object> map) {
      this.map = map;
    }
    @Override
    public Integer integer() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> list() { throw new UnsupportedOperationException(); }
    @Override
    public Set<Integer> set() { throw new UnsupportedOperationException(); }
    @Override
    public Integer[] array() { throw new UnsupportedOperationException(); }
    @Override
    public Double[] defArray() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> map() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableNullableAttributes fromJson(Json json) {
    ImmutableNullableAttributes.Builder builder = ImmutableNullableAttributes.builder();
    if (json.integer != null) {
      builder.integer(json.integer);
    }
    if (json.list != null) {
      builder.addAllList(json.list);
    }
    if (json.setIsSet) {
      builder.addAllSet(json.set);
    }
    if (json.array != null) {
      builder.array(json.array);
    }
    if (json.defArrayIsSet) {
      builder.defArray(json.defArray);
    }
    if (json.map != null) {
      builder.putAllMap(json.map);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link NullableAttributes} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NullableAttributes instance
   */
  public static ImmutableNullableAttributes copyOf(NullableAttributes instance) {
    if (instance instanceof ImmutableNullableAttributes) {
      return (ImmutableNullableAttributes) instance;
    }
    return ImmutableNullableAttributes.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNullableAttributes ImmutableNullableAttributes}.
   * <pre>
   * ImmutableNullableAttributes.builder()
   *    .integer(Integer | null) // nullable {@link NullableAttributes#integer() integer}
   *    .list(List&amp;lt;String&amp;gt; | null) // nullable {@link NullableAttributes#list() list}
   *    .set(Set&amp;lt;Integer&amp;gt; | null) // nullable {@link NullableAttributes#set() set}
   *    .array(Integer[] | null) // nullable {@link NullableAttributes#array() array}
   *    .defArray(Double[] | null) // nullable {@link NullableAttributes#defArray() defArray}
   *    .map(Map&amp;lt;String, Object&amp;gt; | null) // nullable {@link NullableAttributes#map() map}
   *    .build();
   * </pre>
   * @return A new ImmutableNullableAttributes builder
   */
  public static ImmutableNullableAttributes.Builder builder() {
    return new ImmutableNullableAttributes.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNullableAttributes ImmutableNullableAttributes}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NullableAttributes", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_SET = 0x1L;
    private static final long OPT_BIT_DEF_ARRAY = 0x2L;
    private long optBits;

    private @Nullable Integer integer;
    private ImmutableList.Builder<String> list = null;
    private ImmutableSet.Builder<Integer> set = null;
    private @Nullable Integer[] array;
    private @Nullable Double[] defArray;
    private ImmutableMap.Builder<String, Object> map = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NullableAttributes} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NullableAttributes instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Integer integerValue = instance.integer();
      if (integerValue != null) {
        integer(integerValue);
      }
      @Nullable List<String> listValue = instance.list();
      if (listValue != null) {
        addAllList(listValue);
      }
      @Nullable Set<Integer> setValue = instance.set();
      if (setValue != null) {
        addAllSet(setValue);
      }
      @Nullable Integer[] arrayValue = instance.array();
      if (arrayValue != null) {
        array(arrayValue);
      }
      @Nullable Double[] defArrayValue = instance.defArray();
      if (defArrayValue != null) {
        defArray(defArrayValue);
      }
      @Nullable Map<String, Object> mapValue = instance.map();
      if (mapValue != null) {
        putAllMap(mapValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link NullableAttributes#integer() integer} attribute.
     * @param integer The value for integer (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("integer")
    public final Builder integer(@Nullable Integer integer) {
      this.integer = integer;
      return this;
    }

    /**
     * Adds one element to {@link NullableAttributes#list() list} list.
     * @param element A list element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addList(String element) {
      if (this.list == null) {
        this.list = ImmutableList.builder();
      }
      this.list.add(element);
      return this;
    }

    /**
     * Adds elements to {@link NullableAttributes#list() list} list.
     * @param elements An array of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addList(String... elements) {
      if (this.list == null) {
        this.list = ImmutableList.builder();
      }
      this.list.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NullableAttributes#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("list")
    public final Builder list(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.list = null;
        return this;
      }
      this.list = ImmutableList.builder();
      return addAllList(elements);
    }

    /**
     * Adds elements to {@link NullableAttributes#list() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllList(Iterable<String> elements) {
      Objects.requireNonNull(elements, "list element");
      if (this.list == null) {
        this.list = ImmutableList.builder();
      }
      this.list.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link NullableAttributes#set() set} set.
     * @param element A set element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSet(int element) {
      if (this.set == null) {
        this.set = ImmutableSet.builder();
      }
      this.set.add(element);
      optBits |= OPT_BIT_SET;
      return this;
    }

    /**
     * Adds elements to {@link NullableAttributes#set() set} set.
     * @param elements An array of set elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSet(int... elements) {
      if (this.set == null) {
        this.set = ImmutableSet.builder();
      }
      this.set.addAll(Ints.asList(elements));
      optBits |= OPT_BIT_SET;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NullableAttributes#set() set} set.
     * @param elements An iterable of set elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("set")
    public final Builder set(@Nullable Iterable<Integer> elements) {
      if (elements == null) {
        this.set = null;
        optBits |= OPT_BIT_SET;
        return this;
      }
      this.set = ImmutableSet.builder();
      return addAllSet(elements);
    }

    /**
     * Adds elements to {@link NullableAttributes#set() set} set.
     * @param elements An iterable of set elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSet(Iterable<Integer> elements) {
      Objects.requireNonNull(elements, "set element");
      if (this.set == null) {
        this.set = ImmutableSet.builder();
      }
      this.set.addAll(elements);
      optBits |= OPT_BIT_SET;
      return this;
    }

    /**
     * Initializes the value for the {@link NullableAttributes#array() array} attribute.
     * @param array The elements for array
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("array")
    public final Builder array(Integer... array) {
      this.array = array;
      return this;
    }

    /**
     * Initializes the value for the {@link NullableAttributes#defArray() defArray} attribute.
     * <p><em>If not set, this attribute will have a default value as defined by {@link NullableAttributes#defArray() defArray}.</em>
     * @param defArray The elements for defArray
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("defArray")
    public final Builder defArray(Double... defArray) {
      this.defArray = defArray;
      optBits |= OPT_BIT_DEF_ARRAY;
      return this;
    }

    /**
     * Put one entry to the {@link NullableAttributes#map() map} map.
     * @param key The key in the map map
     * @param value The associated value in the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(String key, Object value) {
      if (this.map == null) {
        this.map = ImmutableMap.builder();
      }
      this.map.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link NullableAttributes#map() map} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(Map.Entry<String, ? extends Object> entry) {
      if (this.map == null) {
        this.map = ImmutableMap.builder();
      }
      this.map.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link NullableAttributes#map() map} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("map")
    public final Builder map(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.map = null;
        return this;
      }
      this.map = ImmutableMap.builder();
      return putAllMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link NullableAttributes#map() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMap(Map<String, ? extends Object> entries) {
      if (this.map == null) {
        this.map = ImmutableMap.builder();
      }
      this.map.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableNullableAttributes ImmutableNullableAttributes}.
     * @return An immutable instance of NullableAttributes
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNullableAttributes build() {
      return new ImmutableNullableAttributes(this);
    }

    private boolean setIsSet() {
      return (optBits & OPT_BIT_SET) != 0;
    }

    private boolean defArrayIsSet() {
      return (optBits & OPT_BIT_DEF_ARRAY) != 0;
    }
  }
}
