package org.immutables.fixture.nullable;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NonnullConstruction}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableNonnullConstruction.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableNonnullConstruction.of()}.
 */
@Generated(from = "NonnullConstruction", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableNonnullConstruction implements NonnullConstruction {
  private final String[] arr;
  private final @Nullable String[] brr;
  private final ImmutableList<String> ax;
  private transient final int a;

  private ImmutableNonnullConstruction(
      String[] arr,
      @Nullable String[] brr,
      Iterable<String> ax) {
    this.arr = arr.clone();
    this.brr = brr;
    initShim.ax(ImmutableList.copyOf(ax));
    this.ax = initShim.ax();
    this.a = initShim.a();
    this.initShim = null;
  }

  private ImmutableNonnullConstruction(ImmutableNonnullConstruction.Builder builder) {
    this.arr = builder.arr;
    this.brr = builder.brr;
    if (builder.axIsSet()) {
      initShim.ax(builder.ax.build());
    }
    this.ax = initShim.ax();
    this.a = initShim.a();
    this.initShim = null;
  }

  private ImmutableNonnullConstruction(
      ImmutableNonnullConstruction original,
      String[] arr,
      @Nullable String[] brr,
      ImmutableList<String> ax) {
    this.arr = arr;
    this.brr = brr;
    initShim.ax(ax);
    this.ax = initShim.ax();
    this.a = initShim.a();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "NonnullConstruction", generator = "Immutables")
  private final class InitShim {
    private byte axBuildStage = STAGE_UNINITIALIZED;
    private ImmutableList<String> ax;

    ImmutableList<String> ax() {
      if (axBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (axBuildStage == STAGE_UNINITIALIZED) {
        axBuildStage = STAGE_INITIALIZING;
        this.ax = ImmutableList.copyOf(axInitialize());
        axBuildStage = STAGE_INITIALIZED;
      }
      return this.ax;
    }

    void ax(ImmutableList<String> ax) {
      this.ax = ax;
      axBuildStage = STAGE_INITIALIZED;
    }

    private byte aBuildStage = STAGE_UNINITIALIZED;
    private int a;

    int a() {
      if (aBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (aBuildStage == STAGE_UNINITIALIZED) {
        aBuildStage = STAGE_INITIALIZING;
        this.a = aInitialize();
        aBuildStage = STAGE_INITIALIZED;
      }
      return this.a;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (axBuildStage == STAGE_INITIALIZING) attributes.add("ax");
      if (aBuildStage == STAGE_INITIALIZING) attributes.add("a");
      return "Cannot build NonnullConstruction, attribute initializers form cycle " + attributes;
    }
  }

  private List<String> axInitialize() {
    return NonnullConstruction.super.ax();
  }

  private int aInitialize() {
    return NonnullConstruction.super.a();
  }

  /**
   * @return A cloned {@code arr} array
   */
  @JsonProperty("arr")
  @Override
  public String[] arr() {
    return arr.clone();
  }

  /**
   * @return A cloned {@code brr} array
   */
  @JsonProperty("brr")
  @Override
  public @Nullable String[] brr() {
    return brr;
  }

  /**
   * @return The value of the {@code ax} attribute
   */
  @JsonProperty("ax")
  @Override
  public ImmutableList<String> ax() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.ax()
        : this.ax;
  }

  /**
   * @return The computed-at-construction value of the {@code a} attribute
   */
  @JsonProperty("a")
  @Override
  public int a() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.a()
        : this.a;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NonnullConstruction#arr() arr}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for arr
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNonnullConstruction withArr(String... elements) {
    String[] newValue = elements.clone();
    return new ImmutableNonnullConstruction(this, newValue, this.brr, this.ax);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NonnullConstruction#brr() brr}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for brr
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNonnullConstruction withBrr(@Nullable String... elements) {
    @Nullable String[] newValue = elements == null ? null : elements.clone();
    return new ImmutableNonnullConstruction(this, this.arr, newValue, this.ax);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NonnullConstruction#ax() ax}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNonnullConstruction withAx(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableNonnullConstruction(this, this.arr, this.brr, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link NonnullConstruction#ax() ax}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ax elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableNonnullConstruction withAx(Iterable<String> elements) {
    if (this.ax == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return new ImmutableNonnullConstruction(this, this.arr, this.brr, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableNonnullConstruction} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableNonnullConstruction
        && equalTo(0, (ImmutableNonnullConstruction) another);
  }

  private boolean equalTo(int synthetic, ImmutableNonnullConstruction another) {
    return Arrays.equals(arr, another.arr)
        && Arrays.equals(brr, another.brr)
        && ax.equals(another.ax)
        && a == another.a;
  }

  /**
   * Computes a hash code from attributes: {@code arr}, {@code brr}, {@code ax}, {@code a}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Arrays.hashCode(arr);
    h += (h << 5) + Arrays.hashCode(brr);
    h += (h << 5) + ax.hashCode();
    h += (h << 5) + a;
    return h;
  }

  /**
   * Prints the immutable value {@code NonnullConstruction} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("NonnullConstruction")
        .omitNullValues()
        .add("arr", Arrays.toString(arr))
        .add("brr", Arrays.toString(brr))
        .add("ax", ax)
        .add("a", a)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "NonnullConstruction", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements NonnullConstruction {
    @Nullable String[] arr;
    @Nullable String[] brr;
    @Nullable List<String> ax = ImmutableList.of();
    boolean axIsSet;
    @JsonProperty("arr")
    public void setArr(String[] arr) {
      this.arr = arr;
    }
    @JsonProperty("brr")
    public void setBrr(@Nullable String[] brr) {
      this.brr = brr;
    }
    @JsonProperty("ax")
    public void setAx(List<String> ax) {
      this.ax = ax;
      this.axIsSet = true;
    }
    @Override
    public String[] arr() { throw new UnsupportedOperationException(); }
    @Override
    public String[] brr() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> ax() { throw new UnsupportedOperationException(); }
    @JsonIgnore
    @Override
    public int a() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableNonnullConstruction fromJson(Json json) {
    ImmutableNonnullConstruction.Builder builder = ImmutableNonnullConstruction.builder();
    if (json.arr != null) {
      builder.arr(json.arr);
    }
    if (json.brr != null) {
      builder.brr(json.brr);
    }
    if (json.axIsSet) {
      builder.addAllAx(json.ax);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code NonnullConstruction} instance.
   * @param arr The value for the {@code arr} attribute
   * @param brr The value for the {@code brr} attribute
   * @param ax The value for the {@code ax} attribute
   * @return An immutable NonnullConstruction instance
   */
  public static ImmutableNonnullConstruction of(String[] arr, @Nullable String[] brr, List<String> ax) {
    return of(arr, brr, (Iterable<String>) ax);
  }

  /**
   * Construct a new immutable {@code NonnullConstruction} instance.
   * @param arr The value for the {@code arr} attribute
   * @param brr The value for the {@code brr} attribute
   * @param ax The value for the {@code ax} attribute
   * @return An immutable NonnullConstruction instance
   */
  public static ImmutableNonnullConstruction of(String[] arr, @Nullable String[] brr, Iterable<String> ax) {
    return new ImmutableNonnullConstruction(arr, brr, ax);
  }

  /**
   * Creates an immutable copy of a {@link NonnullConstruction} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable NonnullConstruction instance
   */
  public static ImmutableNonnullConstruction copyOf(NonnullConstruction instance) {
    if (instance instanceof ImmutableNonnullConstruction) {
      return (ImmutableNonnullConstruction) instance;
    }
    return ImmutableNonnullConstruction.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableNonnullConstruction ImmutableNonnullConstruction}.
   * <pre>
   * ImmutableNonnullConstruction.builder()
   *    .arr(String) // required {@link NonnullConstruction#arr() arr}
   *    .brr(String[] | null) // nullable {@link NonnullConstruction#brr() brr}
   *    .addAx|addAllAx(String) // {@link NonnullConstruction#ax() ax} elements
   *    .build();
   * </pre>
   * @return A new ImmutableNonnullConstruction builder
   */
  public static ImmutableNonnullConstruction.Builder builder() {
    return new ImmutableNonnullConstruction.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableNonnullConstruction ImmutableNonnullConstruction}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "NonnullConstruction", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ARR = 0x1L;
    private static final long OPT_BIT_AX = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable String[] arr;
    private @Nullable String[] brr;
    private ImmutableList.Builder<String> ax = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code NonnullConstruction} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(NonnullConstruction instance) {
      Objects.requireNonNull(instance, "instance");
      arr(instance.arr());
      @Nullable String[] brrValue = instance.brr();
      if (brrValue != null) {
        brr(brrValue);
      }
      addAllAx(instance.ax());
      return this;
    }

    /**
     * Initializes the value for the {@link NonnullConstruction#arr() arr} attribute.
     * @param arr The elements for arr
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("arr")
    public final Builder arr(String... arr) {
      this.arr = arr.clone();
      initBits &= ~INIT_BIT_ARR;
      return this;
    }

    /**
     * Initializes the value for the {@link NonnullConstruction#brr() brr} attribute.
     * @param brr The elements for brr
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("brr")
    public final Builder brr(String... brr) {
      this.brr = brr;
      return this;
    }

    /**
     * Adds one element to {@link NonnullConstruction#ax() ax} list.
     * @param element A ax element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAx(String element) {
      this.ax.add(element);
      optBits |= OPT_BIT_AX;
      return this;
    }

    /**
     * Adds elements to {@link NonnullConstruction#ax() ax} list.
     * @param elements An array of ax elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAx(String... elements) {
      this.ax.add(elements);
      optBits |= OPT_BIT_AX;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link NonnullConstruction#ax() ax} list.
     * @param elements An iterable of ax elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("ax")
    public final Builder ax(Iterable<String> elements) {
      this.ax = ImmutableList.builder();
      return addAllAx(elements);
    }

    /**
     * Adds elements to {@link NonnullConstruction#ax() ax} list.
     * @param elements An iterable of ax elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllAx(Iterable<String> elements) {
      this.ax.addAll(elements);
      optBits |= OPT_BIT_AX;
      return this;
    }

    /**
     * Builds a new {@link ImmutableNonnullConstruction ImmutableNonnullConstruction}.
     * @return An immutable instance of NonnullConstruction
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableNonnullConstruction build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableNonnullConstruction(this);
    }

    private boolean axIsSet() {
      return (optBits & OPT_BIT_AX) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ARR) != 0) attributes.add("arr");
      return "Cannot build NonnullConstruction, some of required attributes are not set " + attributes;
    }
  }
}
