package org.immutables.fixture.nullable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CustomNullableAnnotation}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCustomNullableAnnotation.builder()}.
 */
@Generated(from = "CustomNullableAnnotation", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCustomNullableAnnotation
    implements CustomNullableAnnotation {
  private final @CheckForNull String string1;
  private final String string2;

  private ImmutableCustomNullableAnnotation(@CheckForNull String string1, String string2) {
    this.string1 = string1;
    this.string2 = string2;
  }

  /**
   * @return The value of the {@code string1} attribute
   */
  @Override
  public @CheckForNull String string1() {
    return string1;
  }

  /**
   * @return The value of the {@code string2} attribute
   */
  @Override
  public String string2() {
    return string2;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CustomNullableAnnotation#string1() string1} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for string1 (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCustomNullableAnnotation withString1(@CheckForNull String value) {
    if (Objects.equals(this.string1, value)) return this;
    return new ImmutableCustomNullableAnnotation(value, this.string2);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CustomNullableAnnotation#string2() string2} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for string2
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCustomNullableAnnotation withString2(String value) {
    String newValue = Objects.requireNonNull(value, "string2");
    if (this.string2.equals(newValue)) return this;
    return new ImmutableCustomNullableAnnotation(this.string1, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCustomNullableAnnotation} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCustomNullableAnnotation
        && equalTo(0, (ImmutableCustomNullableAnnotation) another);
  }

  private boolean equalTo(int synthetic, ImmutableCustomNullableAnnotation another) {
    return Objects.equals(string1, another.string1)
        && string2.equals(another.string2);
  }

  /**
   * Computes a hash code from attributes: {@code string1}, {@code string2}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(string1);
    h += (h << 5) + string2.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CustomNullableAnnotation} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CustomNullableAnnotation")
        .omitNullValues()
        .add("string1", string1)
        .add("string2", string2)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CustomNullableAnnotation} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CustomNullableAnnotation instance
   */
  public static ImmutableCustomNullableAnnotation copyOf(CustomNullableAnnotation instance) {
    if (instance instanceof ImmutableCustomNullableAnnotation) {
      return (ImmutableCustomNullableAnnotation) instance;
    }
    return ImmutableCustomNullableAnnotation.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCustomNullableAnnotation ImmutableCustomNullableAnnotation}.
   * <pre>
   * ImmutableCustomNullableAnnotation.builder()
   *    .string1(String | null) // nullable {@link CustomNullableAnnotation#string1() string1}
   *    .string2(String) // required {@link CustomNullableAnnotation#string2() string2}
   *    .build();
   * </pre>
   * @return A new ImmutableCustomNullableAnnotation builder
   */
  public static ImmutableCustomNullableAnnotation.Builder builder() {
    return new ImmutableCustomNullableAnnotation.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCustomNullableAnnotation ImmutableCustomNullableAnnotation}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CustomNullableAnnotation", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_STRING2 = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String string1;
    private @Nullable String string2;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CustomNullableAnnotation} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CustomNullableAnnotation instance) {
      Objects.requireNonNull(instance, "instance");
      @CheckForNull String string1Value = instance.string1();
      if (string1Value != null) {
        string1(string1Value);
      }
      string2(instance.string2());
      return this;
    }

    /**
     * Initializes the value for the {@link CustomNullableAnnotation#string1() string1} attribute.
     * @param string1 The value for string1 (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder string1(@CheckForNull String string1) {
      this.string1 = string1;
      return this;
    }

    /**
     * Initializes the value for the {@link CustomNullableAnnotation#string2() string2} attribute.
     * @param string2 The value for string2 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder string2(String string2) {
      this.string2 = Objects.requireNonNull(string2, "string2");
      initBits &= ~INIT_BIT_STRING2;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCustomNullableAnnotation ImmutableCustomNullableAnnotation}.
     * @return An immutable instance of CustomNullableAnnotation
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCustomNullableAnnotation build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCustomNullableAnnotation(string1, string2);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STRING2) != 0) attributes.add("string2");
      return "Cannot build CustomNullableAnnotation, some of required attributes are not set " + attributes;
    }
  }
}
