package org.immutables.fixture.nullable;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code NullableCompact}.
 * @see ImmutableNullableCompact
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture.nullable", generator = "Gsons")
public final class GsonAdaptersNullableCompact implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (NullableCompactTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new NullableCompactTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersNullableCompact(NullableCompact)";
  }

  @org.immutables.value.Generated(from = "NullableCompact", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class NullableCompactTypeAdapter extends TypeAdapter<NullableCompact> {
    public final Integer arrayTypeSample = null;
    public final Object mapSecondaryTypeSample = null;
    private final TypeAdapter<Integer> arrayTypeAdapter;
    private final TypeAdapter<Object> mapSecondaryTypeAdapter;

    NullableCompactTypeAdapter(Gson gson) {
      this.arrayTypeAdapter = gson.getAdapter( Integer.class);
      this.mapSecondaryTypeAdapter = gson.getAdapter( Object.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return NullableCompact.class == type.getRawType()
          || ImmutableNullableCompact.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, NullableCompact value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeNullableCompact(out, value);
      }
    }

    @Override
    public NullableCompact read(JsonReader in) throws IOException {
      return readNullableCompact(in);
    }

    private void writeNullableCompact(JsonWriter out, NullableCompact instance)
        throws IOException {
      out.beginObject();
      @Nullable Integer[] arrayElements = instance.array();
      if (arrayElements != null) {
        out.name("array");
        out.beginArray();
        for (Integer e : arrayElements) {
          arrayTypeAdapter.write(out, e);
        }
        out.endArray();
      } else if (out.getSerializeNulls()) {
        out.name("array");
        out.nullValue();
      }
      @Nullable Map<String, Object> mapMapping = instance.map();
      if (mapMapping != null) {
        out.name("map");
        out.beginObject();
        for (Map.Entry<String, Object> e : mapMapping.entrySet()) {
          String key = e.getKey();
          out.name(key);
          Object value = e.getValue();
          mapSecondaryTypeAdapter.write(out, value);
        }
        out.endObject();
      } else if (out.getSerializeNulls()) {
        out.name("map");
        out.nullValue();
      }
      out.endObject();
    }

    private  NullableCompact readNullableCompact(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableNullableCompact.Builder builder = ImmutableNullableCompact.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableNullableCompact.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'a':
        if ("array".equals(attributeName)) {
          readInArray(in, builder);
          return;
        }
        break;
      case 'm':
        if ("map".equals(attributeName)) {
          readInMap(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInArray(JsonReader in, ImmutableNullableCompact.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        List<Integer> elements = new ArrayList<Integer>();
        if (in.peek() == JsonToken.BEGIN_ARRAY) {
          in.beginArray();
          while(in.hasNext()) {
            Integer value = arrayTypeAdapter.read(in);
            elements.add(value);
          }
          in.endArray();
        } else if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          Integer value = arrayTypeAdapter.read(in);
          elements.add(value);
        }
        builder.array(elements.toArray(new Integer[elements.size()]));
      }
    }

    private void readInMap(JsonReader in, ImmutableNullableCompact.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        if (in.peek() == JsonToken.NULL) {
          in.nextNull();
        } else {
          in.beginObject();
          boolean empty = true;
          while(in.hasNext()) {
            String rawKey = in.nextName();
            String key = rawKey;
            Object value = mapSecondaryTypeAdapter.read(in);
            builder.putMap(key, value);
            empty = false;
          }
          if (empty) {
            builder.putAllMap(Collections.<String, Object>emptyMap());
          }
          in.endObject();
        }
      }
    }
  }
}
