package org.immutables.fixture.nested;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AbstractSub}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSub.builder()}.
 */
@Generated(from = "AbstractSub", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableSub implements AbstractSub {
  private final String b;
  private final boolean isA;
  private final String c;

  private ImmutableSub(String b, boolean isA, String c) {
    this.b = b;
    this.isA = isA;
    this.c = c;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public String getB() {
    return b;
  }

  /**
   * @return The value of the {@code isA} attribute
   */
  @Override
  public boolean isA() {
    return isA;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public String getC() {
    return c;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSub#getB() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSub withB(String value) {
    String newValue = Objects.requireNonNull(value, "b");
    if (this.b.equals(newValue)) return this;
    return new ImmutableSub(newValue, this.isA, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSub#isA() isA} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for isA
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSub withIsA(boolean value) {
    if (this.isA == value) return this;
    return new ImmutableSub(this.b, value, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSub#getC() c} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSub withC(String value) {
    String newValue = Objects.requireNonNull(value, "c");
    if (this.c.equals(newValue)) return this;
    return new ImmutableSub(this.b, this.isA, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSub} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSub
        && equalTo(0, (ImmutableSub) another);
  }

  private boolean equalTo(int synthetic, ImmutableSub another) {
    return b.equals(another.b)
        && isA == another.isA
        && c.equals(another.c);
  }

  /**
   * Computes a hash code from attributes: {@code b}, {@code isA}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + b.hashCode();
    h += (h << 5) + Booleans.hashCode(isA);
    h += (h << 5) + c.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Sub} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Sub")
        .omitNullValues()
        .add("b", b)
        .add("isA", isA)
        .add("c", c)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link AbstractSub} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Sub instance
   */
  public static ImmutableSub copyOf(AbstractSub instance) {
    if (instance instanceof ImmutableSub) {
      return (ImmutableSub) instance;
    }
    return ImmutableSub.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSub ImmutableSub}.
   * <pre>
   * ImmutableSub.builder()
   *    .b(String) // required {@link AbstractSub#getB() b}
   *    .isA(boolean) // required {@link AbstractSub#isA() isA}
   *    .c(String) // required {@link AbstractSub#getC() c}
   *    .build();
   * </pre>
   * @return A new ImmutableSub builder
   */
  public static ImmutableSub.Builder builder() {
    return new ImmutableSub.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSub ImmutableSub}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractSub", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_B = 0x1L;
    private static final long INIT_BIT_IS_A = 0x2L;
    private static final long INIT_BIT_C = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String b;
    private boolean isA;
    private @Nullable String c;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.nested.BaseFrom} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BaseFrom instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.nested.AbstractSub} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AbstractSub instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof BaseFrom) {
        BaseFrom instance = (BaseFrom) object;
        if ((bits & 0x1L) == 0) {
          b(instance.getB());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          isA(instance.isA());
          bits |= 0x2L;
        }
      }
      if (object instanceof AbstractSub) {
        AbstractSub instance = (AbstractSub) object;
        if ((bits & 0x1L) == 0) {
          b(instance.getB());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          isA(instance.isA());
          bits |= 0x2L;
        }
        c(instance.getC());
      }
    }

    /**
     * Initializes the value for the {@link AbstractSub#getB() b} attribute.
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(String b) {
      this.b = Objects.requireNonNull(b, "b");
      initBits &= ~INIT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSub#isA() isA} attribute.
     * @param isA The value for isA 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder isA(boolean isA) {
      this.isA = isA;
      initBits &= ~INIT_BIT_IS_A;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSub#getC() c} attribute.
     * @param c The value for c 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(String c) {
      this.c = Objects.requireNonNull(c, "c");
      initBits &= ~INIT_BIT_C;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSub ImmutableSub}.
     * @return An immutable instance of Sub
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSub build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSub(b, isA, c);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_B) != 0) attributes.add("b");
      if ((initBits & INIT_BIT_IS_A) != 0) attributes.add("isA");
      if ((initBits & INIT_BIT_C) != 0) attributes.add("c");
      return "Cannot build Sub, some of required attributes are not set " + attributes;
    }
  }
}
