package org.immutables.fixture.nested;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link NonGrouped.Buagra}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableBuagra.of()}.
 */
@Generated(from = "NonGrouped.Buagra", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBuagra extends NonGrouped.Buagra {
  private final @Nullable String buagra;

  private ImmutableBuagra(@Nullable String buagra) {
    this.buagra = buagra;
  }

  /**
   * @return The value of the {@code buagra} attribute
   */
  @Override
  public @Nullable String buagra() {
    return buagra;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link NonGrouped.Buagra#buagra() buagra} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for buagra (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBuagra withBuagra(@Nullable String value) {
    if (Objects.equals(this.buagra, value)) return this;
    return new ImmutableBuagra(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBuagra} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBuagra
        && equalTo(0, (ImmutableBuagra) another);
  }

  private boolean equalTo(int synthetic, ImmutableBuagra another) {
    return Objects.equals(buagra, another.buagra);
  }

  /**
   * Computes a hash code from attributes: {@code buagra}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(buagra);
    return h;
  }

  /**
   * Prints the immutable value {@code Buagra} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Buagra")
        .omitNullValues()
        .add("buagra", buagra)
        .toString();
  }

  /**
   * Construct a new immutable {@code Buagra} instance.
   * @param buagra The value for the {@code buagra} attribute
   * @return An immutable Buagra instance
   */
  public static ImmutableBuagra of(@Nullable String buagra) {
    return new ImmutableBuagra(buagra);
  }

  /**
   * Creates an immutable copy of a {@link NonGrouped.Buagra} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Buagra instance
   */
  public static ImmutableBuagra copyOf(NonGrouped.Buagra instance) {
    if (instance instanceof ImmutableBuagra) {
      return (ImmutableBuagra) instance;
    }
    return ImmutableBuagra.of(instance.buagra());
  }
}
