package org.immutables.fixture.nested;

import com.google.common.base.Optional;
import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code GroupedClasses}.
 * @see ImmutableGroupedClasses.NestedOne
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture.nested", generator = "Gsons")
public final class GsonAdaptersGroupedClasses implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (NestedOneTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new NestedOneTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersGroupedClasses(NestedOne)";
  }

  @org.immutables.value.Generated(from = "GroupedClasses.NestedOne", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class NestedOneTypeAdapter extends TypeAdapter<GroupedClasses.NestedOne> {
    public final GroupedClasses.Other otherTypeSample = null;
    private final TypeAdapter<GroupedClasses.Other> otherTypeAdapter;

    NestedOneTypeAdapter(Gson gson) {
      this.otherTypeAdapter = gson.getAdapter( GroupedClasses.Other.class);
    } 

    static boolean adapts(TypeToken<?> type) {
      return GroupedClasses.NestedOne.class == type.getRawType()
          || ImmutableGroupedClasses.NestedOne.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, GroupedClasses.NestedOne value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeNestedOne(out, value);
      }
    }

    @Override
    public GroupedClasses.NestedOne read(JsonReader in) throws IOException {
      return readNestedOne(in);
    }

    private void writeNestedOne(JsonWriter out, GroupedClasses.NestedOne instance)
        throws IOException {
      out.beginObject();
      Optional<GroupedClasses.Other> otherOptional = instance.other();
      if (otherOptional.isPresent()) {
        out.name("other");
        GroupedClasses.Other otherValue = otherOptional.get();
        otherTypeAdapter.write(out, otherValue);
      } else if (out.getSerializeNulls()) {
        out.name("other");
        out.nullValue();
      }
      out.endObject();
    }

    private  GroupedClasses.NestedOne readNestedOne(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      ImmutableGroupedClasses.NestedOne.Builder builder = ImmutableGroupedClasses.NestedOne.builder();
      in.beginObject();
      while (in.hasNext()) {
        eachAttribute(in, builder);
      }
      in.endObject();
      return builder.build();
    }

    private void eachAttribute(JsonReader in, ImmutableGroupedClasses.NestedOne.Builder builder)
        throws IOException {
      String attributeName = in.nextName();
      switch (attributeName.charAt(0)) {
      case 'o':
        if ("other".equals(attributeName)) {
          readInOther(in, builder);
          return;
        }
        break;
      default:
      }
      in.skipValue();
    }

    private void readInOther(JsonReader in, ImmutableGroupedClasses.NestedOne.Builder builder)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
      } else {
        GroupedClasses.Other value = otherTypeAdapter.read(in);
        builder.other(value);
      }
    }
  }
}
