package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Unit Unit} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * <p><em>ModifiableUnit is not thread-safe</em>
 */
@Generated(from = "Unit", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "Unit"})
@NotThreadSafe
final class ModifiableUnit extends Unit {
  private final ArrayList<Float> prices = new ArrayList<Float>();

  private ModifiableUnit() {}

  /**
   * Construct a modifiable instance of {@code Unit}.
   * @return A new modifiable instance
   */
  public static ModifiableUnit create() {
    return new ModifiableUnit();
  }

  /**
   * @return modifiable list {@code prices}
   */
  @Override
  final List<Float> getPrices() {
    return prices;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableUnit clear() {
    prices.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Unit} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableUnit from(Unit instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableUnit) {
      from((ModifiableUnit) instance);
      return this;
    }
    addAllPrices(instance.getPrices());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Unit} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableUnit from(ModifiableUnit instance) {
    Objects.requireNonNull(instance, "instance");
    addAllPrices(instance.getPrices());
    return this;
  }

  /**
   * Adds one element to {@code prices} list.
   * @param element The prices element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableUnit addPrices(float element) {
    this.prices.add(element);
    return this;
  }

  /**
   * Adds elements to {@code prices} list.
   * @param elements An array of prices elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableUnit addPrices(float... elements) {
    for (float e : elements) {
      addPrices(Objects.requireNonNull(e, "prices element"));
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@code prices} list.
   * @param elements An iterable of prices elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableUnit setPrices(Iterable<Float> elements) {
    this.prices.clear();
    addAllPrices(elements);
    return this;
  }

  /**
   * Adds elements to {@code prices} list.
   * @param elements An iterable of prices elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableUnit addAllPrices(Iterable<Float> elements) {
    for (float e : elements) {
      addPrices(e);
    }
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * This instance is equal to all instances of {@code ModifiableUnit} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableUnit)) return false;
    ModifiableUnit other = (ModifiableUnit) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableUnit another) {
    return prices.equals(another.prices);
  }

  /**
   * Computes a hash code from attributes: {@code prices}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + prices.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code Unit}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableUnit")
        .add("prices", getPrices())
        .toString();
  }
}
