package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Companion.NullableAndDefault NullableAndDefault} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableNullableAndDefault is not thread-safe</em>
 * @see ImmutableNullableAndDefault
 */
@Generated(from = "Companion.NullableAndDefault", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "Companion.NullableAndDefault"})
@NotThreadSafe
public final class ModifiableNullableAndDefault
    implements Companion.NullableAndDefault {
  private static final long OPT_BIT_STR = 0x1L;
  private static final long OPT_BIT_INTS = 0x2L;
  private static final long OPT_BIT_ORDS = 0x4L;
  private static final long OPT_BIT_POLS = 0x8L;
  private static final long OPT_BIT_NAVS = 0x10L;
  private long optBits;

  private ArrayList<String> lst = null;
  private @Nullable ArrayList<String> str = null;
  private LinkedHashSet<Integer> ints = null;
  private int[] arrayInts;
  private @Nullable TreeSet<Integer> ords = null;
  private EnumSet<RetentionPolicy> pols = null;
  private TreeSet<Integer> navs = null;

  private ModifiableNullableAndDefault() {}

  /**
   * Construct a modifiable instance of {@code NullableAndDefault}.
   * @return A new modifiable instance
   */
  public static ModifiableNullableAndDefault create() {
    return new ModifiableNullableAndDefault();
  }

  /**
   * @return modifiable list {@code lst}
   */
  @Override
  public final List<String> lst() {
    if (lst == null) {
      lst = new ArrayList<String>(0);
    }
    return lst;
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code str} attribute
   */
  @Override
  public final @Nullable List<String> str() {
    if (strIsSet()) {
      return str;
    } else {
      return Companion.NullableAndDefault.super.str();
    }
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code ints} attribute
   */
  @Override
  public final Set<Integer> ints() {
    if (intsIsSet()) {
      return ints;
    } else {
      return Companion.NullableAndDefault.super.ints();
    }
  }

  /**
   * @return assigned modifiable {@code arrayInts} array
   */
  @Override
  public final int[] arrayInts() {
    if (arrayIntsIsSet()) {
      return arrayInts;
    } else {
      return Companion.NullableAndDefault.super.arrayInts();
    }
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code ords} attribute
   */
  @Override
  public final @Nullable SortedSet<Integer> ords() {
    if (ordsIsSet()) {
      return ords;
    } else {
      return Companion.NullableAndDefault.super.ords();
    }
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code pols} attribute
   */
  @Override
  public final Set<RetentionPolicy> pols() {
    if (polsIsSet()) {
      return pols;
    } else {
      return Companion.NullableAndDefault.super.pols();
    }
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code navs} attribute
   */
  @Override
  public final NavigableSet<Integer> navs() {
    if (navsIsSet()) {
      return navs;
    } else {
      return Companion.NullableAndDefault.super.navs();
    }
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault clear() {
    optBits = 0;
    if (lst != null) {
      lst.clear();
    }
    str = null;
    if (ints != null) {
      ints.clear();
    }
    arrayInts = null;
    ords = null;
    if (pols != null) {
      pols.clear();
    }
    if (navs != null) {
      navs.clear();
    }
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Companion.NullableAndDefault} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableNullableAndDefault from(Companion.NullableAndDefault instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableNullableAndDefault) {
      from((ModifiableNullableAndDefault) instance);
      return this;
    }
    addAllLst(instance.lst());
    addAllStr(instance.str());
    addAllInts(instance.ints());
    setArrayInts(instance.arrayInts());
    addAllOrds(instance.ords());
    addAllPols(instance.pols());
    addAllNavs(instance.navs());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Companion.NullableAndDefault} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableNullableAndDefault from(ModifiableNullableAndDefault instance) {
    Objects.requireNonNull(instance, "instance");
    addAllLst(instance.lst());
    addAllStr(instance.str());
    addAllInts(instance.ints());
    setArrayInts(instance.arrayInts());
    addAllOrds(instance.ords());
    addAllPols(instance.pols());
    addAllNavs(instance.navs());
    return this;
  }

  /**
   * Adds one element to {@link Companion.NullableAndDefault#lst() lst} list.
   * @param element The lst element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault addLst(String element) {
    if (this.lst == null) {
      this.lst = new ArrayList<String>();
    }
    Objects.requireNonNull(element, "lst element");
    this.lst.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Companion.NullableAndDefault#lst() lst} list.
   * @param elements An array of lst elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableNullableAndDefault addLst(String... elements) {
    for (String e : elements) {
      addLst(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion.NullableAndDefault#lst() lst} list.
   * @param elements An iterable of lst elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault setLst(Iterable<String> elements) {
    if (this.lst == null) {
      this.lst = new ArrayList<String>();
    } else {
      this.lst.clear();
    }
    addAllLst(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion.NullableAndDefault#lst() lst} list.
   * @param elements An iterable of lst elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault addAllLst(Iterable<String> elements) {
    if (elements == null) return this;
    if (this.lst == null) {
      this.lst = new ArrayList<String>();
    }
    for (String e : elements) {
      addLst(e);
    }
    return this;
  }

  /**
   * Adds one element to {@link Companion.NullableAndDefault#str() str} list.
   * @param element The str element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault addStr(String element) {
    if (this.str == null) {
      this.str = new ArrayList<String>();
    }
    Objects.requireNonNull(element, "str element");
    this.str.add(element);
    optBits |= OPT_BIT_STR;
    return this;
  }

  /**
   * Adds elements to {@link Companion.NullableAndDefault#str() str} list.
   * @param elements An array of str elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableNullableAndDefault addStr(String... elements) {
    for (String e : elements) {
      addStr(e);
    }
    optBits |= OPT_BIT_STR;
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion.NullableAndDefault#str() str} list.
   * @param elements An iterable of str elements, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault setStr(@Nullable Iterable<String> elements) {
    if (elements == null) {
      this.str = null;
      optBits |= OPT_BIT_STR;
      return this;
    }
    if (this.str == null) {
      this.str = new ArrayList<String>();
    } else {
      this.str.clear();
    }
    addAllStr(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion.NullableAndDefault#str() str} list.
   * @param elements An iterable of str elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault addAllStr(Iterable<String> elements) {
    if (elements == null) return this;
    if (this.str == null) {
      this.str = new ArrayList<String>();
    }
    for (String e : elements) {
      addStr(e);
    }
    optBits |= OPT_BIT_STR;
    return this;
  }

  /**
   * Adds one element to {@link Companion.NullableAndDefault#ints() ints} set.
   * @param element The ints element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault addInts(int element) {
    if (this.ints == null) {
      this.ints = new LinkedHashSet<Integer>();
    }
    this.ints.add(element);
    optBits |= OPT_BIT_INTS;
    return this;
  }

  /**
   * Adds elements to {@link Companion.NullableAndDefault#ints() ints} set.
   * @param elements An array of ints elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableNullableAndDefault addInts(int... elements) {
    for (int e : elements) {
      addInts(Objects.requireNonNull(e, "ints element"));
    }
    optBits |= OPT_BIT_INTS;
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion.NullableAndDefault#ints() ints} set.
   * @param elements An iterable of ints elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault setInts(Iterable<Integer> elements) {
    if (this.ints == null) {
      this.ints = new LinkedHashSet<Integer>();
    } else {
      this.ints.clear();
    }
    addAllInts(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion.NullableAndDefault#ints() ints} set.
   * @param elements An iterable of ints elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault addAllInts(Iterable<Integer> elements) {
    if (elements == null) return this;
    if (this.ints == null) {
      this.ints = new LinkedHashSet<Integer>();
    }
    for (int e : elements) {
      addInts(e);
    }
    optBits |= OPT_BIT_INTS;
    return this;
  }

  /**
   * Assigns a value to the {@link Companion.NullableAndDefault#arrayInts() arrayInts} attribute.
   * <p><em>If not set, this attribute will have a default value as defined by {@link Companion.NullableAndDefault#arrayInts() arrayInts}.</em>
   * @param elements The elements for arrayInts
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableNullableAndDefault setArrayInts(int... elements) {
    this.arrayInts = elements.clone();
    return this;
  }

  /**
   * Adds one element to {@link Companion.NullableAndDefault#ords() ords} sortedSet.
   * @param element The ords element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault addOrds(int element) {
    if (this.ords == null) {
      this.ords = new TreeSet<Integer>();
    }
    this.ords.add(element);
    optBits |= OPT_BIT_ORDS;
    return this;
  }

  /**
   * Adds elements to {@link Companion.NullableAndDefault#ords() ords} sortedSet.
   * @param elements An array of ords elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableNullableAndDefault addOrds(int... elements) {
    for (int e : elements) {
      addOrds(Objects.requireNonNull(e, "ords element"));
    }
    optBits |= OPT_BIT_ORDS;
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion.NullableAndDefault#ords() ords} sortedSet.
   * @param elements An iterable of ords elements, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault setOrds(@Nullable Iterable<Integer> elements) {
    if (elements == null) {
      this.ords = null;
      optBits |= OPT_BIT_ORDS;
      return this;
    }
    if (this.ords == null) {
      this.ords = new TreeSet<Integer>();
    } else {
      this.ords.clear();
    }
    addAllOrds(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion.NullableAndDefault#ords() ords} sortedSet.
   * @param elements An iterable of ords elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault addAllOrds(Iterable<Integer> elements) {
    if (elements == null) return this;
    if (this.ords == null) {
      this.ords = new TreeSet<Integer>();
    }
    for (int e : elements) {
      addOrds(e);
    }
    optBits |= OPT_BIT_ORDS;
    return this;
  }

  /**
   * Adds one element to {@link Companion.NullableAndDefault#pols() pols} set.
   * @param element The pols element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault addPols(RetentionPolicy element) {
    if (this.pols == null) {
      this.pols = EnumSet.noneOf(RetentionPolicy.class);
    }
    Objects.requireNonNull(element, "pols element");
    this.pols.add(element);
    optBits |= OPT_BIT_POLS;
    return this;
  }

  /**
   * Adds elements to {@link Companion.NullableAndDefault#pols() pols} set.
   * @param elements An array of pols elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableNullableAndDefault addPols(RetentionPolicy... elements) {
    for (RetentionPolicy e : elements) {
      addPols(e);
    }
    optBits |= OPT_BIT_POLS;
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion.NullableAndDefault#pols() pols} set.
   * @param elements An iterable of pols elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault setPols(Iterable<RetentionPolicy> elements) {
    if (this.pols == null) {
      this.pols = EnumSet.noneOf(RetentionPolicy.class);
    } else {
      this.pols.clear();
    }
    addAllPols(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion.NullableAndDefault#pols() pols} set.
   * @param elements An iterable of pols elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault addAllPols(Iterable<RetentionPolicy> elements) {
    if (elements == null) return this;
    if (this.pols == null) {
      this.pols = EnumSet.noneOf(RetentionPolicy.class);
    }
    for (RetentionPolicy e : elements) {
      addPols(e);
    }
    optBits |= OPT_BIT_POLS;
    return this;
  }

  /**
   * Adds one element to {@link Companion.NullableAndDefault#navs() navs} sortedSet.
   * @param element The navs element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault addNavs(int element) {
    if (this.navs == null) {
      this.navs = new TreeSet<Integer>(Collections.<Integer>reverseOrder());
    }
    this.navs.add(element);
    optBits |= OPT_BIT_NAVS;
    return this;
  }

  /**
   * Adds elements to {@link Companion.NullableAndDefault#navs() navs} sortedSet.
   * @param elements An array of navs elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableNullableAndDefault addNavs(int... elements) {
    for (int e : elements) {
      addNavs(Objects.requireNonNull(e, "navs element"));
    }
    optBits |= OPT_BIT_NAVS;
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion.NullableAndDefault#navs() navs} sortedSet.
   * @param elements An iterable of navs elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault setNavs(Iterable<Integer> elements) {
    if (this.navs == null) {
      this.navs = new TreeSet<Integer>(Collections.<Integer>reverseOrder());
    } else {
      this.navs.clear();
    }
    addAllNavs(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion.NullableAndDefault#navs() navs} sortedSet.
   * @param elements An iterable of navs elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableNullableAndDefault addAllNavs(Iterable<Integer> elements) {
    if (elements == null) return this;
    if (this.navs == null) {
      this.navs = new TreeSet<Integer>(Collections.<Integer>reverseOrder());
    }
    for (int e : elements) {
      addNavs(e);
    }
    optBits |= OPT_BIT_NAVS;
    return this;
  }

  /**
   * Returns {@code true} if the default attribute {@link Companion.NullableAndDefault#str() str} is set.
   * @return {@code true} if set
   */
  public final boolean strIsSet() {
    return (optBits & OPT_BIT_STR) != 0;
  }

  /**
   * Returns {@code true} if the default attribute {@link Companion.NullableAndDefault#ints() ints} is set.
   * @return {@code true} if set
   */
  public final boolean intsIsSet() {
    return (optBits & OPT_BIT_INTS) != 0;
  }

  /**
   * Returns {@code true} if the default attribute {@link Companion.NullableAndDefault#ords() ords} is set.
   * @return {@code true} if set
   */
  public final boolean ordsIsSet() {
    return (optBits & OPT_BIT_ORDS) != 0;
  }

  /**
   * Returns {@code true} if the default attribute {@link Companion.NullableAndDefault#pols() pols} is set.
   * @return {@code true} if set
   */
  public final boolean polsIsSet() {
    return (optBits & OPT_BIT_POLS) != 0;
  }

  /**
   * Returns {@code true} if the default attribute {@link Companion.NullableAndDefault#navs() navs} is set.
   * @return {@code true} if set
   */
  public final boolean navsIsSet() {
    return (optBits & OPT_BIT_NAVS) != 0;
  }

  /**
   * Returns {@code true} if the {@link Companion.NullableAndDefault#lst() lst} has not been initialized
   * and will default to an empty list.
   * @return {@code true} if set
   */
  public final boolean lstIsSet() {
    return lst != null;
  }

  /**
   * Returns {@code true} if the default attribute {@link Companion.NullableAndDefault#arrayInts() arrayInts} is set.
   * @return {@code true} if set
   */
  public final boolean arrayIntsIsSet() {
    return arrayInts != null;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableNullableAndDefault unsetStr() {
    optBits |= 0;
    str = null;
    return this;
  }
  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableNullableAndDefault unsetInts() {
    optBits |= 0;
    if (ints != null) {
      ints.clear();
    }
    return this;
  }
  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableNullableAndDefault unsetOrds() {
    optBits |= 0;
    ords = null;
    return this;
  }
  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableNullableAndDefault unsetPols() {
    optBits |= 0;
    if (pols != null) {
      pols.clear();
    }
    return this;
  }
  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableNullableAndDefault unsetNavs() {
    optBits |= 0;
    if (navs != null) {
      navs.clear();
    }
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableNullableAndDefault ImmutableNullableAndDefault}.
   * @return An immutable instance of NullableAndDefault
   */
  public final ImmutableNullableAndDefault toImmutable() {
    return ImmutableNullableAndDefault.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableNullableAndDefault} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableNullableAndDefault)) return false;
    ModifiableNullableAndDefault other = (ModifiableNullableAndDefault) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableNullableAndDefault another) {
    List<String> lst = this.lst != null
        ? this.lst
        : Collections.<String>emptyList();
    List<String> str = str();
    Set<Integer> ints = ints();
    int[] arrayInts = arrayInts();
    SortedSet<Integer> ords = ords();
    Set<RetentionPolicy> pols = pols();
    NavigableSet<Integer> navs = navs();
    return lst.equals(another.lst())
        && Objects.equals(str, another.str())
        && ints.equals(another.ints())
        && Arrays.equals(arrayInts, another.arrayInts())
        && Objects.equals(ords, another.ords())
        && pols.equals(another.pols())
        && navs.equals(another.navs());
  }

  /**
   * Computes a hash code from attributes: {@code lst}, {@code str}, {@code ints}, {@code arrayInts}, {@code ords}, {@code pols}, {@code navs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + (lst == null ? 1 : lst.hashCode());
    List<String> str = str();
    h += (h << 5) + Objects.hashCode(str);
    Set<Integer> ints = ints();
    h += (h << 5) + (ints == null ? 0 : ints.hashCode());
    int[] arrayInts = arrayInts();
    h += (h << 5) + Arrays.hashCode(arrayInts);
    SortedSet<Integer> ords = ords();
    h += (h << 5) + Objects.hashCode(ords);
    Set<RetentionPolicy> pols = pols();
    h += (h << 5) + (pols == null ? 0 : pols.hashCode());
    NavigableSet<Integer> navs = navs();
    h += (h << 5) + (navs == null ? 0 : navs.hashCode());
    return h;
  }

  /**
   * Generates a string representation of this {@code NullableAndDefault}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableNullableAndDefault")
        .add("lst", lst())
        .add("str", str())
        .add("ints", ints())
        .add("arrayInts", Arrays.toString(arrayInts()))
        .add("ords", ords())
        .add("pols", pols())
        .add("navs", navs())
        .toString();
  }
}
