package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Companion.JdkComp JdkComp} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableJdkComp is not thread-safe</em>
 * @see ImmutableJdkComp
 */
@Generated(from = "Companion.JdkComp", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "Companion.JdkComp"})
@NotThreadSafe
public final class ModifiableJdkComp implements Companion.JdkComp {
  private static final long INIT_BIT_INTEGER = 0x1L;
  private static final long INIT_BIT_STRING = 0x2L;
  private static final long INIT_BIT_ARRAY_INTS = 0x4L;
  private static final long INIT_BIT_ARRAY_STRINGS = 0x8L;
  private long initBits = 0xfL;

  private int integer;
  private String string;
  private @Nullable Boolean bools;
  private final ArrayList<String> str = new ArrayList<String>();
  private final LinkedHashSet<Integer> ints = new LinkedHashSet<Integer>();
  private int[] arrayInts;
  private String[] arrayStrings;
  private final TreeSet<Integer> ords = new TreeSet<Integer>();
  private final EnumSet<RetentionPolicy> pols = EnumSet.noneOf(RetentionPolicy.class);
  private final TreeSet<Integer> navs = new TreeSet<Integer>(Collections.<Integer>reverseOrder());

  private ModifiableJdkComp() {}

  /**
   * Construct a modifiable instance of {@code JdkComp}.
   * @return A new modifiable instance
   */
  public static ModifiableJdkComp create() {
    return new ModifiableJdkComp();
  }

  /**
   * @return value of {@code integer} attribute
   */
  @Override
  public final int integer() {
    if (!integerIsSet()) {
      checkRequiredAttributes();
    }
    return integer;
  }

  /**
   * @return value of {@code string} attribute
   */
  @Override
  public final String string() {
    if (!stringIsSet()) {
      checkRequiredAttributes();
    }
    return string;
  }

  /**
   * @return value of {@code bools} attribute, may be {@code null}
   */
  @Override
  public final @Nullable Boolean bools() {
    return bools;
  }

  /**
   * @return modifiable list {@code str}
   */
  @Override
  public final List<String> str() {
    return str;
  }

  /**
   * @return modifiable set {@code ints}
   */
  @Override
  public final Set<Integer> ints() {
    return ints;
  }

  /**
   * @return assigned modifiable {@code arrayInts} array
   */
  @Override
  public final int[] arrayInts() {
    if (!arrayIntsIsSet()) {
      checkRequiredAttributes();
    }
    return arrayInts;
  }

  /**
   * @return assigned modifiable {@code arrayStrings} array
   */
  @Override
  public final String[] arrayStrings() {
    if (!arrayStringsIsSet()) {
      checkRequiredAttributes();
    }
    return arrayStrings;
  }

  /**
   * @return modifiable sortedSet {@code ords}
   */
  @Override
  public final SortedSet<Integer> ords() {
    return ords;
  }

  /**
   * @return modifiable set {@code pols}
   */
  @Override
  public final Set<RetentionPolicy> pols() {
    return pols;
  }

  /**
   * @return modifiable sortedSet {@code navs}
   */
  @Override
  public final NavigableSet<Integer> navs() {
    return navs;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp clear() {
    initBits = 0xfL;
    integer = 0;
    string = null;
    bools = null;
    str.clear();
    ints.clear();
    arrayInts = null;
    arrayStrings = null;
    ords.clear();
    pols.clear();
    navs.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Companion.JdkComp} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableJdkComp from(Companion.JdkComp instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableJdkComp) {
      from((ModifiableJdkComp) instance);
      return this;
    }
    setInteger(instance.integer());
    setString(instance.string());
    @Nullable Boolean boolsValue = instance.bools();
    if (boolsValue != null) {
      setBools(boolsValue);
    }
    addAllStr(instance.str());
    addAllInts(instance.ints());
    setArrayInts(instance.arrayInts());
    setArrayStrings(instance.arrayStrings());
    addAllOrds(instance.ords());
    addAllPols(instance.pols());
    addAllNavs(instance.navs());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Companion.JdkComp} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableJdkComp from(ModifiableJdkComp instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.integerIsSet()) {
      setInteger(instance.integer());
    }
    if (instance.stringIsSet()) {
      setString(instance.string());
    }
    @Nullable Boolean boolsValue = instance.bools();
    if (boolsValue != null) {
      setBools(boolsValue);
    }
    addAllStr(instance.str());
    addAllInts(instance.ints());
    if (instance.arrayIntsIsSet()) {
      setArrayInts(instance.arrayInts());
    }
    if (instance.arrayStringsIsSet()) {
      setArrayStrings(instance.arrayStrings());
    }
    addAllOrds(instance.ords());
    addAllPols(instance.pols());
    addAllNavs(instance.navs());
    return this;
  }

  /**
   * Assigns a value to the {@link Companion.JdkComp#integer() integer} attribute.
   * @param integer The value for integer
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp setInteger(int integer) {
    this.integer = integer;
    initBits &= ~INIT_BIT_INTEGER;
    return this;
  }

  /**
   * Assigns a value to the {@link Companion.JdkComp#string() string} attribute.
   * @param string The value for string
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp setString(String string) {
    this.string = Objects.requireNonNull(string, "string");
    initBits &= ~INIT_BIT_STRING;
    return this;
  }

  /**
   * Assigns a value to the {@link Companion.JdkComp#bools() bools} attribute.
   * @param bools The value for bools, can be {@code null}
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp setBools(@Nullable Boolean bools) {
    this.bools = bools;
    return this;
  }

  /**
   * Adds one element to {@link Companion.JdkComp#str() str} list.
   * @param element The str element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp addStr(String element) {
    Objects.requireNonNull(element, "str element");
    this.str.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Companion.JdkComp#str() str} list.
   * @param elements An array of str elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableJdkComp addStr(String... elements) {
    for (String e : elements) {
      addStr(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion.JdkComp#str() str} list.
   * @param elements An iterable of str elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp setStr(Iterable<String> elements) {
    this.str.clear();
    addAllStr(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion.JdkComp#str() str} list.
   * @param elements An iterable of str elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp addAllStr(Iterable<String> elements) {
    for (String e : elements) {
      addStr(e);
    }
    return this;
  }

  /**
   * Adds one element to {@link Companion.JdkComp#ints() ints} set.
   * @param element The ints element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp addInts(int element) {
    this.ints.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Companion.JdkComp#ints() ints} set.
   * @param elements An array of ints elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableJdkComp addInts(int... elements) {
    for (int e : elements) {
      addInts(Objects.requireNonNull(e, "ints element"));
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion.JdkComp#ints() ints} set.
   * @param elements An iterable of ints elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp setInts(Iterable<Integer> elements) {
    this.ints.clear();
    addAllInts(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion.JdkComp#ints() ints} set.
   * @param elements An iterable of ints elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp addAllInts(Iterable<Integer> elements) {
    for (int e : elements) {
      addInts(e);
    }
    return this;
  }

  /**
   * Assigns a value to the {@link Companion.JdkComp#arrayInts() arrayInts} attribute.
   * @param elements The elements for arrayInts
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableJdkComp setArrayInts(int... elements) {
    this.arrayInts = elements.clone();
    initBits &= ~INIT_BIT_ARRAY_INTS;
    return this;
  }

  /**
   * Assigns a value to the {@link Companion.JdkComp#arrayStrings() arrayStrings} attribute.
   * @param elements The elements for arrayStrings
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableJdkComp setArrayStrings(String... elements) {
    this.arrayStrings = elements.clone();
    initBits &= ~INIT_BIT_ARRAY_STRINGS;
    return this;
  }

  /**
   * Adds one element to {@link Companion.JdkComp#ords() ords} sortedSet.
   * @param element The ords element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp addOrds(int element) {
    this.ords.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Companion.JdkComp#ords() ords} sortedSet.
   * @param elements An array of ords elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableJdkComp addOrds(int... elements) {
    for (int e : elements) {
      addOrds(Objects.requireNonNull(e, "ords element"));
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion.JdkComp#ords() ords} sortedSet.
   * @param elements An iterable of ords elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp setOrds(Iterable<Integer> elements) {
    this.ords.clear();
    addAllOrds(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion.JdkComp#ords() ords} sortedSet.
   * @param elements An iterable of ords elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp addAllOrds(Iterable<Integer> elements) {
    for (int e : elements) {
      addOrds(e);
    }
    return this;
  }

  /**
   * Adds one element to {@link Companion.JdkComp#pols() pols} set.
   * @param element The pols element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp addPols(RetentionPolicy element) {
    Objects.requireNonNull(element, "pols element");
    this.pols.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Companion.JdkComp#pols() pols} set.
   * @param elements An array of pols elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableJdkComp addPols(RetentionPolicy... elements) {
    for (RetentionPolicy e : elements) {
      addPols(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion.JdkComp#pols() pols} set.
   * @param elements An iterable of pols elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp setPols(Iterable<RetentionPolicy> elements) {
    this.pols.clear();
    addAllPols(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion.JdkComp#pols() pols} set.
   * @param elements An iterable of pols elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp addAllPols(Iterable<RetentionPolicy> elements) {
    for (RetentionPolicy e : elements) {
      addPols(e);
    }
    return this;
  }

  /**
   * Adds one element to {@link Companion.JdkComp#navs() navs} sortedSet.
   * @param element The navs element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp addNavs(int element) {
    this.navs.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Companion.JdkComp#navs() navs} sortedSet.
   * @param elements An array of navs elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableJdkComp addNavs(int... elements) {
    for (int e : elements) {
      addNavs(Objects.requireNonNull(e, "navs element"));
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Companion.JdkComp#navs() navs} sortedSet.
   * @param elements An iterable of navs elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp setNavs(Iterable<Integer> elements) {
    this.navs.clear();
    addAllNavs(elements);
    return this;
  }

  /**
   * Adds elements to {@link Companion.JdkComp#navs() navs} sortedSet.
   * @param elements An iterable of navs elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableJdkComp addAllNavs(Iterable<Integer> elements) {
    for (int e : elements) {
      addNavs(e);
    }
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link Companion.JdkComp#integer() integer} is set.
   * @return {@code true} if set
   */
  public final boolean integerIsSet() {
    return (initBits & INIT_BIT_INTEGER) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link Companion.JdkComp#string() string} is set.
   * @return {@code true} if set
   */
  public final boolean stringIsSet() {
    return (initBits & INIT_BIT_STRING) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link Companion.JdkComp#arrayInts() arrayInts} is set.
   * @return {@code true} if set
   */
  public final boolean arrayIntsIsSet() {
    return (initBits & INIT_BIT_ARRAY_INTS) == 0;
  }

  /**
   * Returns {@code true} if the required attribute {@link Companion.JdkComp#arrayStrings() arrayStrings} is set.
   * @return {@code true} if set
   */
  public final boolean arrayStringsIsSet() {
    return (initBits & INIT_BIT_ARRAY_STRINGS) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableJdkComp unsetInteger() {
    initBits |= INIT_BIT_INTEGER;
    integer = 0;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableJdkComp unsetString() {
    initBits |= INIT_BIT_STRING;
    string = null;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableJdkComp unsetArrayInts() {
    initBits |= INIT_BIT_ARRAY_INTS;
    arrayInts = null;
    return this;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableJdkComp unsetArrayStrings() {
    initBits |= INIT_BIT_ARRAY_STRINGS;
    arrayStrings = null;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!integerIsSet()) attributes.add("integer");
    if (!stringIsSet()) attributes.add("string");
    if (!arrayIntsIsSet()) attributes.add("arrayInts");
    if (!arrayStringsIsSet()) attributes.add("arrayStrings");
    return "JdkComp is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableJdkComp ImmutableJdkComp}.
   * @return An immutable instance of JdkComp
   */
  public final ImmutableJdkComp toImmutable() {
    checkRequiredAttributes();
    return ImmutableJdkComp.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableJdkComp} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableJdkComp)) return false;
    ModifiableJdkComp other = (ModifiableJdkComp) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableJdkComp another) {
    return integer == another.integer
        && string.equals(another.string)
        && Objects.equals(bools, another.bools)
        && str.equals(another.str)
        && ints.equals(another.ints)
        && Arrays.equals(arrayInts, another.arrayInts)
        && Arrays.equals(arrayStrings, another.arrayStrings)
        && ords.equals(another.ords)
        && pols.equals(another.pols)
        && navs.equals(another.navs);
  }

  /**
   * Computes a hash code from attributes: {@code integer}, {@code string}, {@code bools}, {@code str}, {@code ints}, {@code arrayInts}, {@code arrayStrings}, {@code ords}, {@code pols}, {@code navs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + integer;
    h += (h << 5) + string.hashCode();
    h += (h << 5) + Objects.hashCode(bools);
    h += (h << 5) + str.hashCode();
    h += (h << 5) + ints.hashCode();
    h += (h << 5) + Arrays.hashCode(arrayInts);
    h += (h << 5) + Arrays.hashCode(arrayStrings);
    h += (h << 5) + ords.hashCode();
    h += (h << 5) + pols.hashCode();
    h += (h << 5) + navs.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code JdkComp}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableJdkComp{"
        + "integer="  + (integerIsSet() ? integer() : "?")
        + ", string="  + (stringIsSet() ? string() : "?")
        + ", bools=" + bools()
        + ", str=" + str()
        + ", ints=" + ints()
        + ", arrayInts=" + (arrayIntsIsSet() ? Arrays.toString(arrayInts()) : "?")
        + ", arrayStrings=" + (arrayStringsIsSet() ? Arrays.toString(arrayStrings()) : "?")
        + ", ords=" + ords()
        + ", pols=" + pols()
        + ", navs=" + navs()
        + "}";
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }

  @SuppressWarnings("unchecked")
  private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
    if (iterable instanceof EnumSet<?>) {
      return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet<T>) iterable));
    }
    List<T> list = createSafeList(iterable, true, false);
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default: return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }
  }

  private static <T extends Comparable<T>> NavigableSet<T> createUnmodifiableSortedSet(boolean reverse, List<T> list) {
    TreeSet<T> set = reverse
        ? new TreeSet<T>(Collections.<T>reverseOrder())
        : new TreeSet<T>();
    set.addAll(list);
    return Collections.unmodifiableNavigableSet(set);
  }
}
