package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link DefaultMap DefaultMap} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableDefaultMap is not thread-safe</em>
 * @see ImmutableDefaultMap
 */
@Generated(from = "DefaultMap", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "DefaultMap"})
@NotThreadSafe
public final class ModifiableDefaultMap implements DefaultMap {
  private static final long OPT_BIT_MAP = 0x1L;
  private long optBits;

  private final Map<String, String> map = new LinkedHashMap<String, String>();

  private ModifiableDefaultMap() {}

  /**
   * Construct a modifiable instance of {@code DefaultMap}.
   * @return A new modifiable instance
   */
  public static ModifiableDefaultMap create() {
    return new ModifiableDefaultMap();
  }

  /**
   * @return assigned or, otherwise, newly computed, not cached value of {@code map} attribute
   */
  @Override
  public final Map<String, String> getMap() {
    if (mapIsSet()) {
      return map;
    } else {
      return DefaultMap.super.getMap();
    }
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableDefaultMap clear() {
    optBits = 0;
    map.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link DefaultMap} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableDefaultMap from(DefaultMap instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableDefaultMap) {
      from((ModifiableDefaultMap) instance);
      return this;
    }
    putAllMap(instance.getMap());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link DefaultMap} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableDefaultMap from(ModifiableDefaultMap instance) {
    Objects.requireNonNull(instance, "instance");
    putAllMap(instance.getMap());
    return this;
  }

  /**
   * Put one entry to the {@link DefaultMap#getMap() map} map.
   * @param key The key in map map
   * @param value The associated value in the map map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableDefaultMap putMap(String key, String value) {
    this.map.put(
        Objects.requireNonNull(key, "map key"),
        Objects.requireNonNull(value, "map value"));
    optBits |= OPT_BIT_MAP;
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link DefaultMap#getMap() map} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the map map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableDefaultMap setMap(Map<String, ? extends String> entries) {
    this.map.clear();
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.map.put(
          Objects.requireNonNull(k, "map key"),
          Objects.requireNonNull(v, "map value"));
    }
    optBits |= OPT_BIT_MAP;
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link DefaultMap#getMap() map} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to map map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableDefaultMap putAllMap(Map<String, ? extends String> entries) {
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.map.put(
          Objects.requireNonNull(k, "map key"),
          Objects.requireNonNull(v, "map value"));
    }
    optBits |= OPT_BIT_MAP;
    return this;
  }

  /**
   * Returns {@code true} if the default attribute {@link DefaultMap#getMap() map} is set.
   * @return {@code true} if set
   */
  public final boolean mapIsSet() {
    return (optBits & OPT_BIT_MAP) != 0;
  }

  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableDefaultMap unsetMap() {
    optBits |= 0;
    map.clear();
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableDefaultMap ImmutableDefaultMap}.
   * @return An immutable instance of DefaultMap
   */
  public final ImmutableDefaultMap toImmutable() {
    return ImmutableDefaultMap.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableDefaultMap} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableDefaultMap)) return false;
    ModifiableDefaultMap other = (ModifiableDefaultMap) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableDefaultMap another) {
    Map<String, String> map = getMap();
    return map.equals(another.getMap());
  }

  /**
   * Computes a hash code from attributes: {@code map}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    Map<String, String> map = getMap();
    h += (h << 5) + map.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code DefaultMap}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableDefaultMap{"
        + "map=" + getMap()
        + "}";
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
