package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link CreateFromDetect.Bbb Bbb} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableBbb is not thread-safe</em>
 * @see ImmutableBbb
 */
@Generated(from = "CreateFromDetect.Bbb", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "CreateFromDetect.Bbb"})
@NotThreadSafe
public final class ModifiableBbb implements CreateFromDetect.Bbb {
  private static final long INIT_BIT_ZZZ = 0x1L;
  private long initBits = 0x1L;

  private int zzz;

  private ModifiableBbb() {}

  /**
   * Construct a modifiable instance of {@code Bbb}.
   * @return A new modifiable instance
   */
  public static ModifiableBbb create() {
    return new ModifiableBbb();
  }

  /**
   * @return value of {@code zzz} attribute
   */
  @Override
  public final int zzz() {
    if (!zzzIsSet()) {
      checkRequiredAttributes();
    }
    return zzz;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableBbb clear() {
    initBits = 0x1L;
    zzz = 0;
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link CreateFromDetect.Bbb} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableBbb from(CreateFromDetect.Bbb instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableBbb) {
      from((ModifiableBbb) instance);
      return this;
    }
    setZzz(instance.zzz());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link CreateFromDetect.Bbb} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableBbb from(ModifiableBbb instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.zzzIsSet()) {
      setZzz(instance.zzz());
    }
    return this;
  }

  /**
   * Assigns a value to the {@link CreateFromDetect.Bbb#zzz() zzz} attribute.
   * @param zzz The value for zzz
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableBbb setZzz(int zzz) {
    this.zzz = zzz;
    initBits &= ~INIT_BIT_ZZZ;
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link CreateFromDetect.Bbb#zzz() zzz} is set.
   * @return {@code true} if set
   */
  public final boolean zzzIsSet() {
    return (initBits & INIT_BIT_ZZZ) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableBbb unsetZzz() {
    initBits |= INIT_BIT_ZZZ;
    zzz = 0;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!zzzIsSet()) attributes.add("zzz");
    return "Bbb is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableBbb ImmutableBbb}.
   * @return An immutable instance of Bbb
   */
  public final ImmutableBbb toImmutable() {
    checkRequiredAttributes();
    return ImmutableBbb.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableBbb} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableBbb)) return false;
    ModifiableBbb other = (ModifiableBbb) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableBbb another) {
    return zzz == another.zzz;
  }

  /**
   * Computes a hash code from attributes: {@code zzz}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + zzz;
    return h;
  }

  /**
   * Generates a string representation of this {@code Bbb}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableBbb")
        .add("zzz", zzzIsSet() ? zzz() : "?")
        .toString();
  }
}
