package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link AllowNullsObject AllowNullsObject} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableAllowNullsObject is not thread-safe</em>
 * @see ImmutableAllowNullsObject
 */
@Generated(from = "AllowNullsObject", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "AllowNullsObject"})
@NotThreadSafe
public final class ModifiableAllowNullsObject implements AllowNullsObject {
  private final Map<String, String> map = new LinkedHashMap<String, String>();
  private final ArrayList<String> list = new ArrayList<String>();

  private ModifiableAllowNullsObject() {}

  /**
   * Construct a modifiable instance of {@code AllowNullsObject}.
   * @return A new modifiable instance
   */
  public static ModifiableAllowNullsObject create() {
    return new ModifiableAllowNullsObject();
  }

  /**
   * @return value of {@code map} attribute
   */
  @Override
  public final Map<String, String> getMap() {
    return map;
  }

  /**
   * @return modifiable list {@code list}
   */
  @Override
  public final List<String> getList() {
    return list;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAllowNullsObject clear() {
    map.clear();
    list.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link AllowNullsObject} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableAllowNullsObject from(AllowNullsObject instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableAllowNullsObject) {
      from((ModifiableAllowNullsObject) instance);
      return this;
    }
    putAllMap(instance.getMap());
    addAllList(instance.getList());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link AllowNullsObject} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableAllowNullsObject from(ModifiableAllowNullsObject instance) {
    Objects.requireNonNull(instance, "instance");
    putAllMap(instance.getMap());
    addAllList(instance.getList());
    return this;
  }

  /**
   * Put one entry to the {@link AllowNullsObject#getMap() map} map.
   * @param key The key in map map
   * @param value The associated value in the map map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAllowNullsObject putMap(String key, String value) {
    this.map.put(
        Objects.requireNonNull(key, "map key"),
        value);
    return this;
  }

  /**
   * Sets or replaces all mappings from the specified map as entries for the {@link AllowNullsObject#getMap() map} map.
   * Nulls are not permitted as keys or values.
   * @param entries The entries that will be added to the map map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAllowNullsObject setMap(Map<String, ? extends String> entries) {
    this.map.clear();
    this.putAllMap(entries);
    return this;
  }

  /**
   * Put all mappings from the specified map as entries to the {@link AllowNullsObject#getMap() map} map.
   * Nulls are not permitted as keys or values.
   * @param entries to be added to map map
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAllowNullsObject putAllMap(Map<String, ? extends String> entries) {
    for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
      String k = e.getKey();
      String v = e.getValue();
      this.map.put(
          Objects.requireNonNull(k, "map key"),
          v);
    }
    return this;
  }

  /**
   * Adds one element to {@link AllowNullsObject#getList() list} list.
   * @param element The list element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAllowNullsObject addList(String element) {
    this.list.add(element);
    return this;
  }

  /**
   * Adds elements to {@link AllowNullsObject#getList() list} list.
   * @param elements An array of list elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableAllowNullsObject addList(String... elements) {
    for (String e : elements) {
      addList(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link AllowNullsObject#getList() list} list.
   * @param elements An iterable of list elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAllowNullsObject setList(Iterable<String> elements) {
    this.list.clear();
    addAllList(elements);
    return this;
  }

  /**
   * Adds elements to {@link AllowNullsObject#getList() list} list.
   * @param elements An iterable of list elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableAllowNullsObject addAllList(Iterable<String> elements) {
    for (String e : elements) {
      addList(e);
    }
    return this;
  }


  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return true;
  }

  /**
   * Converts to {@link ImmutableAllowNullsObject ImmutableAllowNullsObject}.
   * @return An immutable instance of AllowNullsObject
   */
  public final ImmutableAllowNullsObject toImmutable() {
    return ImmutableAllowNullsObject.copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableAllowNullsObject} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableAllowNullsObject)) return false;
    ModifiableAllowNullsObject other = (ModifiableAllowNullsObject) another;
    return equalTo(other);
  }

  private boolean equalTo(ModifiableAllowNullsObject another) {
    return map.equals(another.map)
        && list.equals(another.list);
  }

  /**
   * Computes a hash code from attributes: {@code map}, {@code list}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + map.hashCode();
    h += (h << 5) + list.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code AllowNullsObject}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return "ModifiableAllowNullsObject{"
        + "map=" + getMap()
        + ", list=" + getList()
        + "}";
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
