package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AbstractImmutableWithModifiable}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWithModifiable.builder()}.
 */
@Generated(from = "AbstractImmutableWithModifiable", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableWithModifiable
    implements AbstractImmutableWithModifiable {
  private final int id;
  private final String description;
  private final List<String> names;

  private ImmutableWithModifiable(int id, String description, List<String> names) {
    this.id = id;
    this.description = description;
    this.names = names;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public int getId() {
    return id;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code names} attribute
   */
  @Override
  public List<String> getNames() {
    return names;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractImmutableWithModifiable#getId() id} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWithModifiable withId(int value) {
    if (this.id == value) return this;
    return validate(new ImmutableWithModifiable(value, this.description, this.names));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractImmutableWithModifiable#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWithModifiable withDescription(String value) {
    if (Objects.equals(this.description, value)) return this;
    return validate(new ImmutableWithModifiable(this.id, value, this.names));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractImmutableWithModifiable#getNames() names}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithModifiable withNames(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableWithModifiable(this.id, this.description, newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractImmutableWithModifiable#getNames() names}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of names elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableWithModifiable withNames(Iterable<String> elements) {
    if (this.names == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableWithModifiable(this.id, this.description, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWithModifiable} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWithModifiable
        && equalTo(0, (ImmutableWithModifiable) another);
  }

  private boolean equalTo(int synthetic, ImmutableWithModifiable another) {
    return id == another.id
        && Objects.equals(description, another.description)
        && names.equals(another.names);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code description}, {@code names}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id;
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + names.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ImmutableWithModifiable} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ImmutableWithModifiable{"
        + "id=" + id
        + ", description=" + description
        + ", names=" + names
        + "}";
  }

  private static final Validator validator = Validation.buildDefaultValidatorFactory().getValidator();

  private static ImmutableWithModifiable validate(ImmutableWithModifiable instance) {
    Set<ConstraintViolation<ImmutableWithModifiable>> constraintViolations = validator.validate(instance);
    if (!constraintViolations.isEmpty()) {
      throw new ConstraintViolationException(constraintViolations);
    }
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link AbstractImmutableWithModifiable} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ImmutableWithModifiable instance
   */
  public static ImmutableWithModifiable copyOf(AbstractImmutableWithModifiable instance) {
    if (instance instanceof ImmutableWithModifiable) {
      return (ImmutableWithModifiable) instance;
    }
    return ImmutableWithModifiable.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWithModifiable ImmutableWithModifiable}.
   * <pre>
   * ImmutableWithModifiable.builder()
   *    .setId(int) // optional {@link AbstractImmutableWithModifiable#getId() id}
   *    .setDescription(String | null) // nullable {@link AbstractImmutableWithModifiable#getDescription() description}
   *    .addNames|addAllNames(String) // {@link AbstractImmutableWithModifiable#getNames() names} elements
   *    .build();
   * </pre>
   * @return A new ImmutableWithModifiable builder
   */
  public static ImmutableWithModifiable.Builder builder() {
    return new ImmutableWithModifiable.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWithModifiable ImmutableWithModifiable}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AbstractImmutableWithModifiable", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private int id;
    private @Nullable String description;
    private List<String> names = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableImmutableWithModifiable} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableImmutableWithModifiable instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        setDescription(descriptionValue);
      }
      addAllNames(instance.getNames());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code AbstractImmutableWithModifiable} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AbstractImmutableWithModifiable instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableImmutableWithModifiable) {
        return from((ModifiableImmutableWithModifiable) instance);
      }
      setId(instance.getId());
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        setDescription(descriptionValue);
      }
      addAllNames(instance.getNames());
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractImmutableWithModifiable#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder setId(int id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractImmutableWithModifiable#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder setDescription(String description) {
      this.description = description;
      return this;
    }

    /**
     * Adds one element to {@link AbstractImmutableWithModifiable#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNames(String element) {
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractImmutableWithModifiable#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNames(String... elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AbstractImmutableWithModifiable#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder setNames(Iterable<String> elements) {
      this.names.clear();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link AbstractImmutableWithModifiable#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNames(Iterable<String> elements) {
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableWithModifiable ImmutableWithModifiable}.
     * @return An immutable instance of ImmutableWithModifiable
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWithModifiable build() {
      return ImmutableWithModifiable.validate(new ImmutableWithModifiable(id, description, createUnmodifiableList(true, names)));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
