package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ModStricBuilderAndDefault}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableModStricBuilderAndDefault.builder()}.
 */
@Generated(from = "ModStricBuilderAndDefault", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableModStricBuilderAndDefault
    extends ModStricBuilderAndDefault {
  private final String a;
  private final String b;
  private final @Nullable Integer c;

  private ImmutableModStricBuilderAndDefault(ImmutableModStricBuilderAndDefault.Builder builder) {
    this.a = builder.a;
    if (builder.bIsSet()) {
      initShim.b(builder.b);
    }
    if (builder.cIsSet()) {
      initShim.c(builder.c);
    }
    this.b = initShim.b();
    this.c = initShim.c();
    this.initShim = null;
  }

  private ImmutableModStricBuilderAndDefault(String a, String b, @Nullable Integer c) {
    this.a = a;
    this.b = b;
    this.c = c;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "ModStricBuilderAndDefault", generator = "Immutables")
  private final class InitShim {
    private byte bBuildStage = STAGE_UNINITIALIZED;
    private String b;

    String b() {
      if (bBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (bBuildStage == STAGE_UNINITIALIZED) {
        bBuildStage = STAGE_INITIALIZING;
        this.b = Objects.requireNonNull(ImmutableModStricBuilderAndDefault.super.b(), "b");
        bBuildStage = STAGE_INITIALIZED;
      }
      return this.b;
    }

    void b(String b) {
      this.b = b;
      bBuildStage = STAGE_INITIALIZED;
    }

    private byte cBuildStage = STAGE_UNINITIALIZED;
    private Integer c;

    Integer c() {
      if (cBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (cBuildStage == STAGE_UNINITIALIZED) {
        cBuildStage = STAGE_INITIALIZING;
        this.c = ImmutableModStricBuilderAndDefault.super.c();
        cBuildStage = STAGE_INITIALIZED;
      }
      return this.c;
    }

    void c(Integer c) {
      this.c = c;
      cBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (bBuildStage == STAGE_INITIALIZING) attributes.add("b");
      if (cBuildStage == STAGE_INITIALIZING) attributes.add("c");
      return "Cannot build ModStricBuilderAndDefault, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public String a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @Override
  public String b() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.b()
        : this.b;
  }

  /**
   * @return The value of the {@code c} attribute
   */
  @Override
  public @Nullable Integer c() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.c()
        : this.c;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModStricBuilderAndDefault#a() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModStricBuilderAndDefault withA(String value) {
    String newValue = Objects.requireNonNull(value, "a");
    if (this.a.equals(newValue)) return this;
    return new ImmutableModStricBuilderAndDefault(newValue, this.b, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModStricBuilderAndDefault#b() b} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for b
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModStricBuilderAndDefault withB(String value) {
    String newValue = Objects.requireNonNull(value, "b");
    if (this.b.equals(newValue)) return this;
    return new ImmutableModStricBuilderAndDefault(this.a, newValue, this.c);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ModStricBuilderAndDefault#c() c} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for c (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableModStricBuilderAndDefault withC(@Nullable Integer value) {
    if (Objects.equals(this.c, value)) return this;
    return new ImmutableModStricBuilderAndDefault(this.a, this.b, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableModStricBuilderAndDefault} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableModStricBuilderAndDefault
        && equalTo(0, (ImmutableModStricBuilderAndDefault) another);
  }

  private boolean equalTo(int synthetic, ImmutableModStricBuilderAndDefault another) {
    return a.equals(another.a)
        && b.equals(another.b)
        && Objects.equals(c, another.c);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code c}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    h += (h << 5) + Objects.hashCode(c);
    return h;
  }

  /**
   * Prints the immutable value {@code ModStricBuilderAndDefault} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModStricBuilderAndDefault")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .add("c", c)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ModStricBuilderAndDefault} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ModStricBuilderAndDefault instance
   */
  public static ImmutableModStricBuilderAndDefault copyOf(ModStricBuilderAndDefault instance) {
    if (instance instanceof ImmutableModStricBuilderAndDefault) {
      return (ImmutableModStricBuilderAndDefault) instance;
    }
    return ImmutableModStricBuilderAndDefault.builder()
        .a(instance.a())
        .b(instance.b())
        .c(instance.c())
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableModStricBuilderAndDefault ImmutableModStricBuilderAndDefault}.
   * <pre>
   * ImmutableModStricBuilderAndDefault.builder()
   *    .a(String) // required {@link ModStricBuilderAndDefault#a() a}
   *    .b(String) // optional {@link ModStricBuilderAndDefault#b() b}
   *    .c(Integer | null) // nullable {@link ModStricBuilderAndDefault#c() c}
   *    .build();
   * </pre>
   * @return A new ImmutableModStricBuilderAndDefault builder
   */
  public static ImmutableModStricBuilderAndDefault.Builder builder() {
    return new ImmutableModStricBuilderAndDefault.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableModStricBuilderAndDefault ImmutableModStricBuilderAndDefault}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ModStricBuilderAndDefault", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private static final long OPT_BIT_B = 0x1L;
    private static final long OPT_BIT_C = 0x2L;
    private long initBits = 0x1L;
    private long optBits;

    private @Nullable String a;
    private @Nullable String b;
    private @Nullable Integer c;

    private Builder() {
    }

    /**
     * Initializes the value for the {@link ModStricBuilderAndDefault#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder a(String a) {
      checkNotIsSet(aIsSet(), "a");
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Initializes the value for the {@link ModStricBuilderAndDefault#b() b} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ModStricBuilderAndDefault#b() b}.</em>
     * @param b The value for b 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder b(String b) {
      checkNotIsSet(bIsSet(), "b");
      this.b = Objects.requireNonNull(b, "b");
      optBits |= OPT_BIT_B;
      return this;
    }

    /**
     * Initializes the value for the {@link ModStricBuilderAndDefault#c() c} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ModStricBuilderAndDefault#c() c}.</em>
     * @param c The value for c (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder c(@Nullable Integer c) {
      checkNotIsSet(cIsSet(), "c");
      this.c = c;
      optBits |= OPT_BIT_C;
      return this;
    }

    /**
     * Builds a new {@link ImmutableModStricBuilderAndDefault ImmutableModStricBuilderAndDefault}.
     * @return An immutable instance of ModStricBuilderAndDefault
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableModStricBuilderAndDefault build() {
      checkRequiredAttributes();
      return new ImmutableModStricBuilderAndDefault(this);
    }

    private boolean bIsSet() {
      return (optBits & OPT_BIT_B) != 0;
    }

    private boolean cIsSet() {
      return (optBits & OPT_BIT_C) != 0;
    }

    private boolean aIsSet() {
      return (initBits & INIT_BIT_A) == 0;
    }

    private static void checkNotIsSet(boolean isSet, String name) {
      if (isSet) throw new IllegalStateException("Builder of ModStricBuilderAndDefault is strict, attribute is already set: ".concat(name));
    }

    private void checkRequiredAttributes() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if (!aIsSet()) attributes.add("a");
      return "Cannot build ModStricBuilderAndDefault, some of required attributes are not set " + attributes;
    }
  }
}
