package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GenericHolder}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGenericHolder.builder()}.
 */
@Generated(from = "GenericHolder", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGenericHolder<T> implements GenericHolder<T> {
  private final T mandatory;
  private final @Nullable T optional;

  private ImmutableGenericHolder(T mandatory, @Nullable T optional) {
    this.mandatory = mandatory;
    this.optional = optional;
  }

  /**
   * @return The value of the {@code mandatory} attribute
   */
  @Override
  public T mandatory() {
    return mandatory;
  }

  /**
   * @return The value of the {@code optional} attribute
   */
  @Override
  public @Nullable T optional() {
    return optional;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericHolder#mandatory() mandatory} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mandatory
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGenericHolder<T> withMandatory(T value) {
    if (this.mandatory == value) return this;
    T newValue = Objects.requireNonNull(value, "mandatory");
    return new ImmutableGenericHolder<>(newValue, this.optional);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GenericHolder#optional() optional} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for optional (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGenericHolder<T> withOptional(@Nullable T value) {
    if (this.optional == value) return this;
    return new ImmutableGenericHolder<>(this.mandatory, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGenericHolder} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGenericHolder<?>
        && equalTo(0, (ImmutableGenericHolder<?>) another);
  }

  private boolean equalTo(int synthetic, ImmutableGenericHolder<?> another) {
    return mandatory.equals(another.mandatory)
        && Objects.equals(optional, another.optional);
  }

  /**
   * Computes a hash code from attributes: {@code mandatory}, {@code optional}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + mandatory.hashCode();
    h += (h << 5) + Objects.hashCode(optional);
    return h;
  }

  /**
   * Prints the immutable value {@code GenericHolder} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GenericHolder")
        .omitNullValues()
        .add("mandatory", mandatory)
        .add("optional", optional)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GenericHolder} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable GenericHolder instance
   */
  public static <T> ImmutableGenericHolder<T> copyOf(GenericHolder<T> instance) {
    if (instance instanceof ImmutableGenericHolder<?>) {
      return (ImmutableGenericHolder<T>) instance;
    }
    return ImmutableGenericHolder.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGenericHolder ImmutableGenericHolder}.
   * <pre>
   * ImmutableGenericHolder.&amp;lt;T&amp;gt;builder()
   *    .mandatory(T) // required {@link GenericHolder#mandatory() mandatory}
   *    .optional(T | null) // nullable {@link GenericHolder#optional() optional}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableGenericHolder builder
   */
  public static <T> ImmutableGenericHolder.Builder<T> builder() {
    return new ImmutableGenericHolder.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableGenericHolder ImmutableGenericHolder}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GenericHolder", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_MANDATORY = 0x1L;
    private long initBits = 0x1L;

    private @Nullable T mandatory;
    private @Nullable T optional;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableGenericHolder} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(ModifiableGenericHolder<T> instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.mandatoryIsSet()) {
        mandatory(instance.mandatory());
      }
      @Nullable T optionalValue = instance.optional();
      if (optionalValue != null) {
        optional(optionalValue);
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GenericHolder} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> from(GenericHolder<T> instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableGenericHolder<?>) {
        return from((ModifiableGenericHolder<T>) instance);
      }
      mandatory(instance.mandatory());
      @Nullable T optionalValue = instance.optional();
      if (optionalValue != null) {
        optional(optionalValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GenericHolder#mandatory() mandatory} attribute.
     * @param mandatory The value for mandatory 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> mandatory(T mandatory) {
      this.mandatory = Objects.requireNonNull(mandatory, "mandatory");
      initBits &= ~INIT_BIT_MANDATORY;
      return this;
    }

    /**
     * Initializes the value for the {@link GenericHolder#optional() optional} attribute.
     * @param optional The value for optional (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder<T> optional(@Nullable T optional) {
      this.optional = optional;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGenericHolder ImmutableGenericHolder}.
     * @return An immutable instance of GenericHolder
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGenericHolder<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGenericHolder<>(mandatory, optional);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_MANDATORY) != 0) attributes.add("mandatory");
      return "Cannot build GenericHolder, some of required attributes are not set " + attributes;
    }
  }
}
