package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link FromTypesModifiables.FromType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new FromTypesModifiables.FromType.Builder()}.
 */
@Generated(from = "FromTypesModifiables.FromType", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableFromType
    implements FromTypesModifiables.FromType {
  private final int a;

  private ImmutableFromType(int a) {
    this.a = a;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @Override
  public int a() {
    return a;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FromTypesModifiables.FromType#a() a} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFromType withA(int value) {
    if (this.a == value) return this;
    return new ImmutableFromType(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFromType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFromType
        && equalTo(0, (ImmutableFromType) another);
  }

  private boolean equalTo(int synthetic, ImmutableFromType another) {
    return a == another.a;
  }

  /**
   * Computes a hash code from attributes: {@code a}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a;
    return h;
  }

  /**
   * Prints the immutable value {@code FromType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("FromType")
        .omitNullValues()
        .add("a", a)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link FromTypesModifiables.FromType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FromType instance
   */
  public static ImmutableFromType copyOf(FromTypesModifiables.FromType instance) {
    if (instance instanceof ImmutableFromType) {
      return (ImmutableFromType) instance;
    }
    return new FromTypesModifiables.FromType.Builder()
        .mergeFrom(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableFromType ImmutableFromType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "FromTypesModifiables.FromType", generator = "Immutables")
  @NotThreadSafe
  public static class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private int a;

    /**
     * Creates a builder for {@link ImmutableFromType ImmutableFromType} instances.
     * <pre>
     * new FromTypesModifiables.FromType.Builder()
     *    .a(int) // required {@link FromTypesModifiables.FromType#a() a}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof FromTypesModifiables.FromType.Builder)) {
        throw new UnsupportedOperationException("Use: new FromTypesModifiables.FromType.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableFromType} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final FromTypesModifiables.FromType.Builder mergeFrom(ModifiableFromType instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.aIsSet()) {
        a(instance.a());
      }
      return (FromTypesModifiables.FromType.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code FromType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final FromTypesModifiables.FromType.Builder mergeFrom(FromTypesModifiables.FromType instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableFromType) {
        return mergeFrom((ModifiableFromType) instance);
      }
      a(instance.a());
      return (FromTypesModifiables.FromType.Builder) this;
    }

    /**
     * Initializes the value for the {@link FromTypesModifiables.FromType#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final FromTypesModifiables.FromType.Builder a(int a) {
      this.a = a;
      initBits &= ~INIT_BIT_A;
      return (FromTypesModifiables.FromType.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableFromType ImmutableFromType}.
     * @return An immutable instance of FromType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFromType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFromType(a);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build FromType, some of required attributes are not set " + attributes;
    }
  }
}
