package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DefaultMap}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDefaultMap.builder()}.
 */
@Generated(from = "DefaultMap", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDefaultMap implements DefaultMap {
  private final Map<String, String> map;

  private ImmutableDefaultMap(ImmutableDefaultMap.Builder builder) {
    this.map = builder.mapIsSet()
        ? createUnmodifiableMap(false, false, builder.map)
        : createUnmodifiableMap(true, false, DefaultMap.super.getMap());
  }

  private ImmutableDefaultMap(Map<String, String> map) {
    this.map = map;
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @Override
  public Map<String, String> getMap() {
    return map;
  }

  /**
   * Copy the current immutable object by replacing the {@link DefaultMap#getMap() map} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the map map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultMap withMap(Map<String, ? extends String> entries) {
    if (this.map == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableDefaultMap(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDefaultMap} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDefaultMap
        && equalTo(0, (ImmutableDefaultMap) another);
  }

  private boolean equalTo(int synthetic, ImmutableDefaultMap another) {
    return map.equals(another.map);
  }

  /**
   * Computes a hash code from attributes: {@code map}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + map.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DefaultMap} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DefaultMap{"
        + "map=" + map
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DefaultMap} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DefaultMap instance
   */
  public static ImmutableDefaultMap copyOf(DefaultMap instance) {
    if (instance instanceof ImmutableDefaultMap) {
      return (ImmutableDefaultMap) instance;
    }
    return ImmutableDefaultMap.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDefaultMap ImmutableDefaultMap}.
   * <pre>
   * ImmutableDefaultMap.builder()
   *    .putMap|putAllMap(String =&gt; String) // {@link DefaultMap#getMap() map} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableDefaultMap builder
   */
  public static ImmutableDefaultMap.Builder builder() {
    return new ImmutableDefaultMap.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDefaultMap ImmutableDefaultMap}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DefaultMap", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_MAP = 0x1L;
    private long optBits;

    private Map<String, String> map = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableDefaultMap} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableDefaultMap instance) {
      Objects.requireNonNull(instance, "instance");
      putAllMap(instance.getMap());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code DefaultMap} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DefaultMap instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableDefaultMap) {
        return from((ModifiableDefaultMap) instance);
      }
      putAllMap(instance.getMap());
      return this;
    }

    /**
     * Put one entry to the {@link DefaultMap#getMap() map} map.
     * @param key The key in the map map
     * @param value The associated value in the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(String key, String value) {
      this.map.put(
          Objects.requireNonNull(key, "map key"),
          Objects.requireNonNull(value, "map value"));
      optBits |= OPT_BIT_MAP;
      return this;
    }

    /**
     * Put one entry to the {@link DefaultMap#getMap() map} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.map.put(
          Objects.requireNonNull(k, "map key"),
          Objects.requireNonNull(v, "map value"));
      optBits |= OPT_BIT_MAP;
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link DefaultMap#getMap() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder map(Map<String, ? extends String> entries) {
      this.map.clear();
      optBits |= OPT_BIT_MAP;
      return putAllMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link DefaultMap#getMap() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMap(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.map.put(
            Objects.requireNonNull(k, "map key"),
            Objects.requireNonNull(v, "map value"));
      }
      optBits |= OPT_BIT_MAP;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDefaultMap ImmutableDefaultMap}.
     * @return An immutable instance of DefaultMap
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDefaultMap build() {
      return new ImmutableDefaultMap(this);
    }

    private boolean mapIsSet() {
      return (optBits & OPT_BIT_MAP) != 0;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
