package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link BeanFriendly}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBeanFriendly.builder()}.
 */
@Generated(from = "BeanFriendly", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBeanFriendly implements BeanFriendly {
  private final boolean primary;
  private final int id;
  private final String description;
  private final ImmutableSet<String> names;
  private final ImmutableMap<String, String> options;
  private final @Nullable ImmutableMod mod;
  private final ImmutableMod defaultMod;
  private final @Nullable ImmutableMod defaultNullableMod;
  private transient final ImmutableMod derivedMod;
  private transient final @Nullable ImmutableMod derivedNullableMod;
  private final @Nullable ImmutableList<Integer> extra;

  private ImmutableBeanFriendly(ImmutableBeanFriendly.Builder builder) {
    this.primary = builder.primary;
    this.id = builder.id;
    this.description = builder.description;
    this.names = builder.names.build();
    this.options = builder.options.build();
    this.mod = builder.mod == null ? null : ImmutableMod.copyOf(builder.mod);
    this.extra = builder.extra == null ? null : builder.extra.build();
    if (builder.defaultMod != null) {
      initShim.defaultMod(ImmutableMod.copyOf(builder.defaultMod));
    }
    if (builder.defaultNullableModIsSet()) {
      initShim.defaultNullableMod(builder.defaultNullableMod == null ? null : ImmutableMod.copyOf(builder.defaultNullableMod));
    }
    this.defaultMod = initShim.getDefaultMod();
    this.defaultNullableMod = initShim.getDefaultNullableMod();
    this.derivedMod = initShim.getDerivedMod();
    this.derivedNullableMod = initShim.getDerivedNullableMod();
    this.initShim = null;
  }

  private ImmutableBeanFriendly(
      boolean primary,
      int id,
      String description,
      ImmutableSet<String> names,
      ImmutableMap<String, String> options,
      @Nullable ImmutableMod mod,
      ImmutableMod defaultMod,
      @Nullable ImmutableMod defaultNullableMod,
      @Nullable ImmutableList<Integer> extra) {
    this.primary = primary;
    this.id = id;
    this.description = description;
    this.names = names;
    this.options = options;
    this.mod = mod;
    initShim.defaultMod(defaultMod);
    initShim.defaultNullableMod(defaultNullableMod);
    this.extra = extra;
    this.defaultMod = initShim.getDefaultMod();
    this.defaultNullableMod = initShim.getDefaultNullableMod();
    this.derivedMod = initShim.getDerivedMod();
    this.derivedNullableMod = initShim.getDerivedNullableMod();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "BeanFriendly", generator = "Immutables")
  private final class InitShim {
    private byte defaultModBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMod defaultMod;

    ImmutableMod getDefaultMod() {
      if (defaultModBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defaultModBuildStage == STAGE_UNINITIALIZED) {
        defaultModBuildStage = STAGE_INITIALIZING;
        this.defaultMod = ImmutableMod.copyOf(getDefaultModInitialize());
        defaultModBuildStage = STAGE_INITIALIZED;
      }
      return this.defaultMod;
    }

    void defaultMod(ImmutableMod defaultMod) {
      this.defaultMod = defaultMod;
      defaultModBuildStage = STAGE_INITIALIZED;
    }

    private byte defaultNullableModBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMod defaultNullableMod;

    ImmutableMod getDefaultNullableMod() {
      if (defaultNullableModBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defaultNullableModBuildStage == STAGE_UNINITIALIZED) {
        defaultNullableModBuildStage = STAGE_INITIALIZING;
        this.defaultNullableMod = getDefaultNullableModInitialize() == null ? null : ImmutableMod.copyOf(getDefaultNullableModInitialize());
        defaultNullableModBuildStage = STAGE_INITIALIZED;
      }
      return this.defaultNullableMod;
    }

    void defaultNullableMod(ImmutableMod defaultNullableMod) {
      this.defaultNullableMod = defaultNullableMod;
      defaultNullableModBuildStage = STAGE_INITIALIZED;
    }

    private byte derivedModBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMod derivedMod;

    ImmutableMod getDerivedMod() {
      if (derivedModBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (derivedModBuildStage == STAGE_UNINITIALIZED) {
        derivedModBuildStage = STAGE_INITIALIZING;
        this.derivedMod = ImmutableMod.copyOf(getDerivedModInitialize());
        derivedModBuildStage = STAGE_INITIALIZED;
      }
      return this.derivedMod;
    }

    private byte derivedNullableModBuildStage = STAGE_UNINITIALIZED;
    private ImmutableMod derivedNullableMod;

    ImmutableMod getDerivedNullableMod() {
      if (derivedNullableModBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (derivedNullableModBuildStage == STAGE_UNINITIALIZED) {
        derivedNullableModBuildStage = STAGE_INITIALIZING;
        this.derivedNullableMod = getDerivedNullableModInitialize() == null ? null : ImmutableMod.copyOf(getDerivedNullableModInitialize());
        derivedNullableModBuildStage = STAGE_INITIALIZED;
      }
      return this.derivedNullableMod;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (defaultModBuildStage == STAGE_INITIALIZING) attributes.add("defaultMod");
      if (defaultNullableModBuildStage == STAGE_INITIALIZING) attributes.add("defaultNullableMod");
      if (derivedModBuildStage == STAGE_INITIALIZING) attributes.add("derivedMod");
      if (derivedNullableModBuildStage == STAGE_INITIALIZING) attributes.add("derivedNullableMod");
      return "Cannot build BeanFriendly, attribute initializers form cycle " + attributes;
    }
  }

  private BeanFriendly.Mod getDefaultModInitialize() {
    return BeanFriendly.super.getDefaultMod();
  }

  private @Nullable BeanFriendly.Mod getDefaultNullableModInitialize() {
    return BeanFriendly.super.getDefaultNullableMod();
  }

  private BeanFriendly.Mod getDerivedModInitialize() {
    return BeanFriendly.super.getDerivedMod();
  }

  private @Nullable BeanFriendly.Mod getDerivedNullableModInitialize() {
    return BeanFriendly.super.getDerivedNullableMod();
  }

  /**
   * @return The value of the {@code primary} attribute
   */
  @Override
  public boolean isPrimary() {
    return primary;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public int getId() {
    return id;
  }

  /**
   * @return The value of the {@code description} attribute
   */
  @Override
  public String getDescription() {
    return description;
  }

  /**
   * @return The value of the {@code names} attribute
   */
  @Override
  public ImmutableSet<String> getNames() {
    return names;
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @Override
  public ImmutableMap<String, String> getOptions() {
    return options;
  }

  /**
   * @return The value of the {@code mod} attribute
   */
  @Override
  public @Nullable ImmutableMod getMod() {
    return mod;
  }

  /**
   * @return The value of the {@code defaultMod} attribute
   */
  @Override
  public ImmutableMod getDefaultMod() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDefaultMod()
        : this.defaultMod;
  }

  /**
   * @return The value of the {@code defaultNullableMod} attribute
   */
  @Override
  public @Nullable ImmutableMod getDefaultNullableMod() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDefaultNullableMod()
        : this.defaultNullableMod;
  }

  /**
   * @return The computed-at-construction value of the {@code derivedMod} attribute
   */
  @Override
  public ImmutableMod getDerivedMod() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDerivedMod()
        : this.derivedMod;
  }

  /**
   * @return The computed-at-construction value of the {@code derivedNullableMod} attribute
   */
  @Override
  public @Nullable ImmutableMod getDerivedNullableMod() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDerivedNullableMod()
        : this.derivedNullableMod;
  }

  /**
   * @return The value of the {@code extra} attribute
   */
  @Override
  public @Nullable ImmutableList<Integer> getExtra() {
    return extra;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BeanFriendly#isPrimary() primary} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for primary
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBeanFriendly withPrimary(boolean value) {
    if (this.primary == value) return this;
    return new ImmutableBeanFriendly(
        value,
        this.id,
        this.description,
        this.names,
        this.options,
        this.mod,
        this.defaultMod,
        this.defaultNullableMod,
        this.extra);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BeanFriendly#getId() id} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBeanFriendly withId(int value) {
    if (this.id == value) return this;
    return new ImmutableBeanFriendly(
        this.primary,
        value,
        this.description,
        this.names,
        this.options,
        this.mod,
        this.defaultMod,
        this.defaultNullableMod,
        this.extra);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BeanFriendly#getDescription() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBeanFriendly withDescription(String value) {
    String newValue = Objects.requireNonNull(value, "description");
    if (this.description.equals(newValue)) return this;
    return new ImmutableBeanFriendly(
        this.primary,
        this.id,
        newValue,
        this.names,
        this.options,
        this.mod,
        this.defaultMod,
        this.defaultNullableMod,
        this.extra);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BeanFriendly#getNames() names}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBeanFriendly withNames(String... elements) {
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableBeanFriendly(
        this.primary,
        this.id,
        this.description,
        newValue,
        this.options,
        this.mod,
        this.defaultMod,
        this.defaultNullableMod,
        this.extra);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BeanFriendly#getNames() names}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of names elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBeanFriendly withNames(Iterable<String> elements) {
    if (this.names == elements) return this;
    ImmutableSet<String> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableBeanFriendly(
        this.primary,
        this.id,
        this.description,
        newValue,
        this.options,
        this.mod,
        this.defaultMod,
        this.defaultNullableMod,
        this.extra);
  }

  /**
   * Copy the current immutable object by replacing the {@link BeanFriendly#getOptions() options} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the options map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBeanFriendly withOptions(Map<String, ? extends String> entries) {
    if (this.options == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableBeanFriendly(
        this.primary,
        this.id,
        this.description,
        this.names,
        newValue,
        this.mod,
        this.defaultMod,
        this.defaultNullableMod,
        this.extra);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BeanFriendly#getMod() mod} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mod (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBeanFriendly withMod(@Nullable BeanFriendly.Mod value) {
    if (this.mod == value) return this;
    @Nullable ImmutableMod newValue = value == null ? null : ImmutableMod.copyOf(value);
    return new ImmutableBeanFriendly(
        this.primary,
        this.id,
        this.description,
        this.names,
        this.options,
        newValue,
        this.defaultMod,
        this.defaultNullableMod,
        this.extra);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BeanFriendly#getDefaultMod() defaultMod} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultMod
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBeanFriendly withDefaultMod(BeanFriendly.Mod value) {
    if (this.defaultMod == value) return this;
    ImmutableMod newValue = ImmutableMod.copyOf(value);
    return new ImmutableBeanFriendly(
        this.primary,
        this.id,
        this.description,
        this.names,
        this.options,
        this.mod,
        newValue,
        this.defaultNullableMod,
        this.extra);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link BeanFriendly#getDefaultNullableMod() defaultNullableMod} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultNullableMod (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBeanFriendly withDefaultNullableMod(@Nullable BeanFriendly.Mod value) {
    if (this.defaultNullableMod == value) return this;
    @Nullable ImmutableMod newValue = value == null ? null : ImmutableMod.copyOf(value);
    return new ImmutableBeanFriendly(
        this.primary,
        this.id,
        this.description,
        this.names,
        this.options,
        this.mod,
        this.defaultMod,
        newValue,
        this.extra);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BeanFriendly#getExtra() extra}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBeanFriendly withExtra(@Nullable int... elements) {
    if (elements == null) {
      return new ImmutableBeanFriendly(
          this.primary,
          this.id,
          this.description,
          this.names,
          this.options,
          this.mod,
          this.defaultMod,
          this.defaultNullableMod,
          null);
    }
    @Nullable ImmutableList<Integer> newValue = Ints.asList(elements) == null ? null : ImmutableList.copyOf(Ints.asList(elements));
    return new ImmutableBeanFriendly(
        this.primary,
        this.id,
        this.description,
        this.names,
        this.options,
        this.mod,
        this.defaultMod,
        this.defaultNullableMod,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link BeanFriendly#getExtra() extra}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of extra elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBeanFriendly withExtra(@Nullable Iterable<Integer> elements) {
    if (this.extra == elements) return this;
    @Nullable ImmutableList<Integer> newValue = elements == null ? null : ImmutableList.copyOf(elements);
    return new ImmutableBeanFriendly(
        this.primary,
        this.id,
        this.description,
        this.names,
        this.options,
        this.mod,
        this.defaultMod,
        this.defaultNullableMod,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBeanFriendly} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBeanFriendly
        && equalTo(0, (ImmutableBeanFriendly) another);
  }

  private boolean equalTo(int synthetic, ImmutableBeanFriendly another) {
    return primary == another.primary
        && id == another.id
        && description.equals(another.description)
        && names.equals(another.names)
        && options.equals(another.options)
        && Objects.equals(mod, another.mod)
        && defaultMod.equals(another.defaultMod)
        && Objects.equals(defaultNullableMod, another.defaultNullableMod)
        && derivedMod.equals(another.derivedMod)
        && Objects.equals(derivedNullableMod, another.derivedNullableMod)
        && Objects.equals(extra, another.extra);
  }

  /**
   * Computes a hash code from attributes: {@code primary}, {@code id}, {@code description}, {@code names}, {@code options}, {@code mod}, {@code defaultMod}, {@code defaultNullableMod}, {@code derivedMod}, {@code derivedNullableMod}, {@code extra}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Booleans.hashCode(primary);
    h += (h << 5) + id;
    h += (h << 5) + description.hashCode();
    h += (h << 5) + names.hashCode();
    h += (h << 5) + options.hashCode();
    h += (h << 5) + Objects.hashCode(mod);
    h += (h << 5) + defaultMod.hashCode();
    h += (h << 5) + Objects.hashCode(defaultNullableMod);
    h += (h << 5) + derivedMod.hashCode();
    h += (h << 5) + Objects.hashCode(derivedNullableMod);
    h += (h << 5) + Objects.hashCode(extra);
    return h;
  }

  /**
   * Prints the immutable value {@code BeanFriendly} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BeanFriendly")
        .omitNullValues()
        .add("primary", primary)
        .add("id", id)
        .add("description", description)
        .add("names", names)
        .add("options", options)
        .add("mod", mod)
        .add("defaultMod", defaultMod)
        .add("defaultNullableMod", defaultNullableMod)
        .add("derivedMod", derivedMod)
        .add("derivedNullableMod", derivedNullableMod)
        .add("extra", extra)
        .toString();
  }

  @SuppressWarnings("Immutable")
  private transient volatile long lazyInitBitmap;

  private static final long LAZY_MOD_LAZY_INIT_BIT = 0x1L;

  @SuppressWarnings("Immutable")
  private transient BeanFriendly.Mod lazyMod;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link BeanFriendly#getLazyMod() lazyMod} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code lazyMod} attribute
   */
  @Override
  public BeanFriendly.Mod getLazyMod() {
    if ((lazyInitBitmap & LAZY_MOD_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & LAZY_MOD_LAZY_INIT_BIT) == 0) {
          this.lazyMod = Objects.requireNonNull(BeanFriendly.super.getLazyMod(), "lazyMod");
          lazyInitBitmap |= LAZY_MOD_LAZY_INIT_BIT;
        }
      }
    }
    return lazyMod;
  }

  private static final long LAZY_NULLABLE_MOD_LAZY_INIT_BIT = 0x2L;

  @SuppressWarnings("Immutable")
  private transient BeanFriendly.Mod lazyNullableMod;

  /**
   * {@inheritDoc}
   * <p>
   * Returns a lazily initialized value of the {@link BeanFriendly#getLazyNullableMod() lazyNullableMod} attribute.
   * Initialized once and only once and stored for subsequent access with proper synchronization.
   * In case of any exception or error thrown by the lazy value initializer,
   * the result will not be memoised (i.e. remembered) and on next call computation
   * will be attempted again.
   * @return A lazily initialized value of the {@code lazyNullableMod} attribute
   */
  @Override
  public BeanFriendly.Mod getLazyNullableMod() {
    if ((lazyInitBitmap & LAZY_NULLABLE_MOD_LAZY_INIT_BIT) == 0) {
      synchronized (this) {
        if ((lazyInitBitmap & LAZY_NULLABLE_MOD_LAZY_INIT_BIT) == 0) {
          this.lazyNullableMod = BeanFriendly.super.getLazyNullableMod();
          lazyInitBitmap |= LAZY_NULLABLE_MOD_LAZY_INIT_BIT;
        }
      }
    }
    return lazyNullableMod;
  }

  /**
   * Creates an immutable copy of a {@link BeanFriendly} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BeanFriendly instance
   */
  public static ImmutableBeanFriendly copyOf(BeanFriendly instance) {
    if (instance instanceof ImmutableBeanFriendly) {
      return (ImmutableBeanFriendly) instance;
    }
    return ImmutableBeanFriendly.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBeanFriendly ImmutableBeanFriendly}.
   * <pre>
   * ImmutableBeanFriendly.builder()
   *    .primary(boolean) // required {@link BeanFriendly#isPrimary() primary}
   *    .id(int) // required {@link BeanFriendly#getId() id}
   *    .description(String) // required {@link BeanFriendly#getDescription() description}
   *    .addNames|addAllNames(String) // {@link BeanFriendly#getNames() names} elements
   *    .putOptions|putAllOptions(String =&gt; String) // {@link BeanFriendly#getOptions() options} mappings
   *    .mod(org.immutables.fixture.modifiable.BeanFriendly.Mod | null) // nullable {@link BeanFriendly#getMod() mod}
   *    .defaultMod(org.immutables.fixture.modifiable.BeanFriendly.Mod) // optional {@link BeanFriendly#getDefaultMod() defaultMod}
   *    .defaultNullableMod(org.immutables.fixture.modifiable.BeanFriendly.Mod | null) // nullable {@link BeanFriendly#getDefaultNullableMod() defaultNullableMod}
   *    .extra(List&amp;lt;Integer&amp;gt; | null) // nullable {@link BeanFriendly#getExtra() extra}
   *    .build();
   * </pre>
   * @return A new ImmutableBeanFriendly builder
   */
  public static ImmutableBeanFriendly.Builder builder() {
    return new ImmutableBeanFriendly.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBeanFriendly ImmutableBeanFriendly}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "BeanFriendly", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PRIMARY = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_DESCRIPTION = 0x4L;
    private static final long OPT_BIT_DEFAULT_NULLABLE_MOD = 0x1L;
    private long initBits = 0x7L;
    private long optBits;

    private boolean primary;
    private int id;
    private @Nullable String description;
    private ImmutableSet.Builder<String> names = ImmutableSet.builder();
    private ImmutableMap.Builder<String, String> options = ImmutableMap.builder();
    private @Nullable BeanFriendly.Mod mod;
    private @Nullable BeanFriendly.Mod defaultMod;
    private @Nullable BeanFriendly.Mod defaultNullableMod;
    private ImmutableList.Builder<Integer> extra = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableBeanFriendly} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableBeanFriendly instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.primaryIsSet()) {
        primary(instance.isPrimary());
      }
      if (instance.idIsSet()) {
        id(instance.getId());
      }
      if (instance.descriptionIsSet()) {
        description(instance.getDescription());
      }
      addAllNames(instance.getNames());
      putAllOptions(instance.getOptions());
      @Nullable BeanFriendly.Mod modValue = instance.getMod();
      if (modValue != null) {
        mod(modValue);
      }
      defaultMod(instance.getDefaultMod());
      @Nullable BeanFriendly.Mod defaultNullableModValue = instance.getDefaultNullableMod();
      if (defaultNullableModValue != null) {
        defaultNullableMod(defaultNullableModValue);
      }
      @Nullable List<Integer> extraValue = instance.getExtra();
      if (extraValue != null) {
        addAllExtra(extraValue);
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.modifiable.Identifiable} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Identifiable instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.modifiable.BeanFriendly} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(BeanFriendly instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ModifiableBeanFriendly) {
        from((ModifiableBeanFriendly) object);
        return;
      }
      @Var long bits = 0;
      if (object instanceof Identifiable) {
        Identifiable instance = (Identifiable) object;
        if ((bits & 0x1L) == 0) {
          id(instance.getId());
          bits |= 0x1L;
        }
      }
      if (object instanceof BeanFriendly) {
        BeanFriendly instance = (BeanFriendly) object;
        defaultMod(instance.getDefaultMod());
        addAllNames(instance.getNames());
        @Nullable BeanFriendly.Mod modValue = instance.getMod();
        if (modValue != null) {
          mod(modValue);
        }
        @Nullable List<Integer> extraValue = instance.getExtra();
        if (extraValue != null) {
          addAllExtra(extraValue);
        }
        putAllOptions(instance.getOptions());
        description(instance.getDescription());
        @Nullable BeanFriendly.Mod defaultNullableModValue = instance.getDefaultNullableMod();
        if (defaultNullableModValue != null) {
          defaultNullableMod(defaultNullableModValue);
        }
        if ((bits & 0x1L) == 0) {
          id(instance.getId());
          bits |= 0x1L;
        }
        primary(instance.isPrimary());
      }
    }

    /**
     * Initializes the value for the {@link BeanFriendly#isPrimary() primary} attribute.
     * @param primary The value for primary 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder primary(boolean primary) {
      this.primary = primary;
      initBits &= ~INIT_BIT_PRIMARY;
      return this;
    }

    /**
     * Initializes the value for the {@link BeanFriendly#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(int id) {
      this.id = id;
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link BeanFriendly#getDescription() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Adds one element to {@link BeanFriendly#getNames() names} set.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNames(String element) {
      this.names.add(element);
      return this;
    }

    /**
     * Adds elements to {@link BeanFriendly#getNames() names} set.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNames(String... elements) {
      this.names.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BeanFriendly#getNames() names} set.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder names(Iterable<String> elements) {
      this.names = ImmutableSet.builder();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link BeanFriendly#getNames() names} set.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNames(Iterable<String> elements) {
      this.names.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link BeanFriendly#getOptions() options} map.
     * @param key The key in the options map
     * @param value The associated value in the options map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putOptions(String key, String value) {
      this.options.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link BeanFriendly#getOptions() options} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putOptions(Map.Entry<String, ? extends String> entry) {
      this.options.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link BeanFriendly#getOptions() options} map. Nulls are not permitted
     * @param entries The entries that will be added to the options map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder options(Map<String, ? extends String> entries) {
      this.options = ImmutableMap.builder();
      return putAllOptions(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link BeanFriendly#getOptions() options} map. Nulls are not permitted
     * @param entries The entries that will be added to the options map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllOptions(Map<String, ? extends String> entries) {
      this.options.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link BeanFriendly#getMod() mod} attribute.
     * @param mod The value for mod (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mod(@Nullable BeanFriendly.Mod mod) {
      this.mod = mod == null ? null : ImmutableMod.copyOf(mod);
      return this;
    }

    /**
     * Initializes the value for the {@link BeanFriendly#getDefaultMod() defaultMod} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link BeanFriendly#getDefaultMod() defaultMod}.</em>
     * @param defaultMod The value for defaultMod 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultMod(BeanFriendly.Mod defaultMod) {
      this.defaultMod = ImmutableMod.copyOf(defaultMod);
      return this;
    }

    /**
     * Initializes the value for the {@link BeanFriendly#getDefaultNullableMod() defaultNullableMod} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link BeanFriendly#getDefaultNullableMod() defaultNullableMod}.</em>
     * @param defaultNullableMod The value for defaultNullableMod (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultNullableMod(@Nullable BeanFriendly.Mod defaultNullableMod) {
      this.defaultNullableMod = defaultNullableMod == null ? null : ImmutableMod.copyOf(defaultNullableMod);
      optBits |= OPT_BIT_DEFAULT_NULLABLE_MOD;
      return this;
    }

    /**
     * Adds one element to {@link BeanFriendly#getExtra() extra} list.
     * @param element A extra element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtra(int element) {
      if (this.extra == null) {
        this.extra = ImmutableList.builder();
      }
      this.extra.add(element);
      return this;
    }

    /**
     * Adds elements to {@link BeanFriendly#getExtra() extra} list.
     * @param elements An array of extra elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addExtra(int... elements) {
      if (this.extra == null) {
        this.extra = ImmutableList.builder();
      }
      this.extra.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BeanFriendly#getExtra() extra} list.
     * @param elements An iterable of extra elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder extra(@Nullable Iterable<Integer> elements) {
      if (elements == null) {
        this.extra = null;
        return this;
      }
      this.extra = ImmutableList.builder();
      return addAllExtra(elements);
    }

    /**
     * Adds elements to {@link BeanFriendly#getExtra() extra} list.
     * @param elements An iterable of extra elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllExtra(Iterable<Integer> elements) {
      Objects.requireNonNull(elements, "extra element");
      if (this.extra == null) {
        this.extra = ImmutableList.builder();
      }
      this.extra.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableBeanFriendly ImmutableBeanFriendly}.
     * @return An immutable instance of BeanFriendly
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBeanFriendly build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBeanFriendly(this);
    }

    private boolean defaultNullableModIsSet() {
      return (optBits & OPT_BIT_DEFAULT_NULLABLE_MOD) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PRIMARY) != 0) attributes.add("primary");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      return "Cannot build BeanFriendly, some of required attributes are not set " + attributes;
    }
  }
}
