package org.immutables.fixture.modifiable;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CreateFromDetect.Bbb}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBbb.builder()}.
 */
@Generated(from = "CreateFromDetect.Bbb", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBbb implements CreateFromDetect.Bbb {
  private final int zzz;

  private ImmutableBbb(int zzz) {
    this.zzz = zzz;
  }

  /**
   * @return The value of the {@code zzz} attribute
   */
  @Override
  public int zzz() {
    return zzz;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CreateFromDetect.Bbb#zzz() zzz} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for zzz
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBbb withZzz(int value) {
    if (this.zzz == value) return this;
    return new ImmutableBbb(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBbb} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBbb
        && equalTo(0, (ImmutableBbb) another);
  }

  private boolean equalTo(int synthetic, ImmutableBbb another) {
    return zzz == another.zzz;
  }

  /**
   * Computes a hash code from attributes: {@code zzz}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + zzz;
    return h;
  }

  /**
   * Prints the immutable value {@code Bbb} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Bbb")
        .omitNullValues()
        .add("zzz", zzz)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CreateFromDetect.Bbb} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Bbb instance
   */
  public static ImmutableBbb copyOf(CreateFromDetect.Bbb instance) {
    if (instance instanceof ImmutableBbb) {
      return (ImmutableBbb) instance;
    }
    return ImmutableBbb.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBbb ImmutableBbb}.
   * <pre>
   * ImmutableBbb.builder()
   *    .zzz(int) // required {@link CreateFromDetect.Bbb#zzz() zzz}
   *    .build();
   * </pre>
   * @return A new ImmutableBbb builder
   */
  public static ImmutableBbb.Builder builder() {
    return new ImmutableBbb.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBbb ImmutableBbb}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CreateFromDetect.Bbb", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ZZZ = 0x1L;
    private long initBits = 0x1L;

    private int zzz;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableBbb} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableBbb instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance.zzzIsSet()) {
        zzz(instance.zzz());
      }
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code Bbb} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CreateFromDetect.Bbb instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableBbb) {
        return from((ModifiableBbb) instance);
      }
      zzz(instance.zzz());
      return this;
    }

    /**
     * Initializes the value for the {@link CreateFromDetect.Bbb#zzz() zzz} attribute.
     * @param zzz The value for zzz 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder zzz(int zzz) {
      this.zzz = zzz;
      initBits &= ~INIT_BIT_ZZZ;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBbb ImmutableBbb}.
     * @return An immutable instance of Bbb
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBbb build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBbb(zzz);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ZZZ) != 0) attributes.add("zzz");
      return "Cannot build Bbb, some of required attributes are not set " + attributes;
    }
  }
}
