package org.immutables.fixture.modifiable;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ToImmutableCopyFalse.B}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableB.builder()}.
 */
@Generated(from = "ToImmutableCopyFalse.B", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableB implements ToImmutableCopyFalse.B {

  private ImmutableB(ImmutableB.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableB} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableB
        && equalTo(0, (ImmutableB) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableB another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 54852940;
  }

  /**
   * Prints the immutable value {@code B}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "B{}";
  }

  /**
   * Creates a builder for {@link ImmutableB ImmutableB}.
   * <pre>
   * ImmutableB.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableB builder
   */
  public static ImmutableB.Builder builder() {
    return new ImmutableB.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableB ImmutableB}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ToImmutableCopyFalse.B", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Builds a new {@link ImmutableB ImmutableB}.
     * @return An immutable instance of B
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableB build() {
      return new ImmutableB(this);
    }
  }
}
