package org.immutables.fixture.modifiable;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link AllowNullsObject}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAllowNullsObject.builder()}.
 */
@Generated(from = "AllowNullsObject", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableAllowNullsObject implements AllowNullsObject {
  private final Map<String, String> map;
  private final List<String> list;

  private ImmutableAllowNullsObject(Map<String, String> map, List<String> list) {
    this.map = map;
    this.list = list;
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @Override
  public Map<String, String> getMap() {
    return map;
  }

  /**
   * @return The value of the {@code list} attribute
   */
  @Override
  public List<String> getList() {
    return list;
  }

  /**
   * Copy the current immutable object by replacing the {@link AllowNullsObject#getMap() map} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the map map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllowNullsObject withMap(Map<String, ? extends String> entries) {
    if (this.map == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableAllowNullsObject(newValue, this.list);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllowNullsObject#getList() list}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllowNullsObject withList(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableAllowNullsObject(this.map, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AllowNullsObject#getList() list}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of list elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAllowNullsObject withList(Iterable<String> elements) {
    if (this.list == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableAllowNullsObject(this.map, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAllowNullsObject} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAllowNullsObject
        && equalTo(0, (ImmutableAllowNullsObject) another);
  }

  private boolean equalTo(int synthetic, ImmutableAllowNullsObject another) {
    return map.equals(another.map)
        && list.equals(another.list);
  }

  /**
   * Computes a hash code from attributes: {@code map}, {@code list}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + map.hashCode();
    h += (h << 5) + list.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AllowNullsObject} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "AllowNullsObject{"
        + "map=" + map
        + ", list=" + list
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link AllowNullsObject} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AllowNullsObject instance
   */
  public static ImmutableAllowNullsObject copyOf(AllowNullsObject instance) {
    if (instance instanceof ImmutableAllowNullsObject) {
      return (ImmutableAllowNullsObject) instance;
    }
    return ImmutableAllowNullsObject.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAllowNullsObject ImmutableAllowNullsObject}.
   * <pre>
   * ImmutableAllowNullsObject.builder()
   *    .putMap|putAllMap(String =&gt; String) // {@link AllowNullsObject#getMap() map} mappings
   *    .addList|addAllList(String) // {@link AllowNullsObject#getList() list} elements
   *    .build();
   * </pre>
   * @return A new ImmutableAllowNullsObject builder
   */
  public static ImmutableAllowNullsObject.Builder builder() {
    return new ImmutableAllowNullsObject.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAllowNullsObject ImmutableAllowNullsObject}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "AllowNullsObject", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Map<String, String> map = new LinkedHashMap<String, String>();
    private List<String> list = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ModifiableAllowNullsObject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ModifiableAllowNullsObject instance) {
      Objects.requireNonNull(instance, "instance");
      putAllMap(instance.getMap());
      addAllList(instance.getList());
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code AllowNullsObject} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(AllowNullsObject instance) {
      Objects.requireNonNull(instance, "instance");
      if (instance instanceof ModifiableAllowNullsObject) {
        return from((ModifiableAllowNullsObject) instance);
      }
      putAllMap(instance.getMap());
      addAllList(instance.getList());
      return this;
    }

    /**
     * Put one entry to the {@link AllowNullsObject#getMap() map} map.
     * @param key The key in the map map
     * @param value The associated value in the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(@Nullable String key, @Nullable String value) {
      this.map.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link AllowNullsObject#getMap() map} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.map.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link AllowNullsObject#getMap() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder map(Map<String, ? extends String> entries) {
      this.map.clear();
      return putAllMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link AllowNullsObject#getMap() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMap(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.map.put(k, v);
      }
      return this;
    }

    /**
     * Adds one element to {@link AllowNullsObject#getList() list} list.
     * @param element A list element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addList(@Nullable String element) {
      this.list.add(element);
      return this;
    }

    /**
     * Adds elements to {@link AllowNullsObject#getList() list} list.
     * @param elements An array of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addList(String... elements) {
      for (String element : elements) {
        this.list.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link AllowNullsObject#getList() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder list(Iterable<String> elements) {
      this.list.clear();
      return addAllList(elements);
    }

    /**
     * Adds elements to {@link AllowNullsObject#getList() list} list.
     * @param elements An iterable of list elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllList(Iterable<String> elements) {
      for (String element : elements) {
        this.list.add(element);
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableAllowNullsObject ImmutableAllowNullsObject}.
     * @return An immutable instance of AllowNullsObject
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAllowNullsObject build() {
      return new ImmutableAllowNullsObject(createUnmodifiableMap(false, false, map), createUnmodifiableList(true, list));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
