package org.immutables.fixture.jdkonly;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JdkOptionalsSer}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJdkOptionalsSer.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code ImmutableJdkOptionalsSer.of()}.
 */
@Generated(from = "JdkOptionalsSer", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableJdkOptionalsSer implements JdkOptionalsSer {
  private final @Nullable String v2;
  private final @Nullable Integer i1;
  private final @Nullable Long l1;
  private final @Nullable Double d1;

  private ImmutableJdkOptionalsSer() {
    this.v2 = null;
    this.i1 = null;
    this.l1 = null;
    this.d1 = null;
  }

  private ImmutableJdkOptionalsSer(
      Optional<String> v2,
      OptionalInt i1,
      OptionalLong l1,
      OptionalDouble d1) {
    this.v2 = v2.orElse(null);
    this.i1 = i1.isPresent() ? i1.getAsInt() : null;
    this.l1 = l1.isPresent() ? l1.getAsLong() : null;
    this.d1 = d1.isPresent() ? d1.getAsDouble() : null;
  }

  private ImmutableJdkOptionalsSer(
      ImmutableJdkOptionalsSer original,
      @Nullable String v2,
      @Nullable Integer i1,
      @Nullable Long l1,
      @Nullable Double d1) {
    this.v2 = v2;
    this.i1 = i1;
    this.l1 = l1;
    this.d1 = d1;
  }

  /**
   * @return The value of the {@code v2} attribute
   */
  @Override
  public Optional<String> v2() {
    return Optional.ofNullable(v2);
  }

  /**
   * @return The value of the {@code i1} attribute
   */
  @Override
  public OptionalInt i1() {
    return i1 != null
        ? OptionalInt.of(i1)
        : OptionalInt.empty();
  }

  /**
   * @return The value of the {@code l1} attribute
   */
  @Override
  public OptionalLong l1() {
    return l1 != null
        ? OptionalLong.of(l1)
        : OptionalLong.empty();
  }

  /**
   * @return The value of the {@code d1} attribute
   */
  @Override
  public OptionalDouble d1() {
    return d1 != null
        ? OptionalDouble.of(d1)
        : OptionalDouble.empty();
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JdkOptionalsSer#v2() v2} attribute.
   * @param value The value for v2
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsSer withV2(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "v2");
    if (Objects.equals(this.v2, newValue)) return this;
    return new ImmutableJdkOptionalsSer(this, newValue, this.i1, this.l1, this.d1);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JdkOptionalsSer#v2() v2} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for v2
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsSer withV2(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.v2, value)) return this;
    return new ImmutableJdkOptionalsSer(this, value, this.i1, this.l1, this.d1);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JdkOptionalsSer#i1() i1} attribute.
   * @param value The value for i1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsSer withI1(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.i1, newValue)) return this;
    return new ImmutableJdkOptionalsSer(this, this.v2, newValue, this.l1, this.d1);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JdkOptionalsSer#i1() i1} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for i1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsSer withI1(OptionalInt optional) {
    @Nullable Integer value = optional.isPresent() ? optional.getAsInt() : null;
    if (Objects.equals(this.i1, value)) return this;
    return new ImmutableJdkOptionalsSer(this, this.v2, value, this.l1, this.d1);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JdkOptionalsSer#l1() l1} attribute.
   * @param value The value for l1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsSer withL1(long value) {
    @Nullable Long newValue = value;
    if (Objects.equals(this.l1, newValue)) return this;
    return new ImmutableJdkOptionalsSer(this, this.v2, this.i1, newValue, this.d1);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JdkOptionalsSer#l1() l1} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for l1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsSer withL1(OptionalLong optional) {
    @Nullable Long value = optional.isPresent() ? optional.getAsLong() : null;
    if (Objects.equals(this.l1, value)) return this;
    return new ImmutableJdkOptionalsSer(this, this.v2, this.i1, value, this.d1);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link JdkOptionalsSer#d1() d1} attribute.
   * @param value The value for d1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsSer withD1(double value) {
    @Nullable Double newValue = value;
    if (Objects.equals(this.d1, newValue)) return this;
    return new ImmutableJdkOptionalsSer(this, this.v2, this.i1, this.l1, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link JdkOptionalsSer#d1() d1} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for d1
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkOptionalsSer withD1(OptionalDouble optional) {
    @Nullable Double value = optional.isPresent() ? optional.getAsDouble() : null;
    if (Objects.equals(this.d1, value)) return this;
    return new ImmutableJdkOptionalsSer(this, this.v2, this.i1, this.l1, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJdkOptionalsSer} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJdkOptionalsSer
        && equalTo(0, (ImmutableJdkOptionalsSer) another);
  }

  private boolean equalTo(int synthetic, ImmutableJdkOptionalsSer another) {
    return Objects.equals(v2, another.v2)
        && Objects.equals(i1, another.i1)
        && Objects.equals(l1, another.l1)
        && Objects.equals(d1, another.d1);
  }

  /**
   * Computes a hash code from attributes: {@code v2}, {@code i1}, {@code l1}, {@code d1}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(v2);
    h += (h << 5) + Objects.hashCode(i1);
    h += (h << 5) + Objects.hashCode(l1);
    h += (h << 5) + Objects.hashCode(d1);
    return h;
  }

  /**
   * Prints the immutable value {@code JdkOptionalsSer} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("JdkOptionalsSer")
        .omitNullValues()
        .add("v2", v2)
        .add("i1", i1)
        .add("l1", l1)
        .add("d1", d1)
        .toString();
  }

  /**
   * Construct a new immutable {@code JdkOptionalsSer} instance.
   * @param v2 The value for the {@code v2} attribute
   * @param i1 The value for the {@code i1} attribute
   * @param l1 The value for the {@code l1} attribute
   * @param d1 The value for the {@code d1} attribute
   * @return An immutable JdkOptionalsSer instance
   */
  public static ImmutableJdkOptionalsSer of(Optional<String> v2, OptionalInt i1, OptionalLong l1, OptionalDouble d1) {
    return new ImmutableJdkOptionalsSer(v2, i1, l1, d1);
  }

  /**
   * Creates an immutable copy of a {@link JdkOptionalsSer} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JdkOptionalsSer instance
   */
  public static ImmutableJdkOptionalsSer copyOf(JdkOptionalsSer instance) {
    if (instance instanceof ImmutableJdkOptionalsSer) {
      return (ImmutableJdkOptionalsSer) instance;
    }
    return ImmutableJdkOptionalsSer.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJdkOptionalsSer ImmutableJdkOptionalsSer}.
   * <pre>
   * ImmutableJdkOptionalsSer.builder()
   *    .v2(String) // optional {@link JdkOptionalsSer#v2() v2}
   *    .i1(int) // optional {@link JdkOptionalsSer#i1() i1}
   *    .l1(long) // optional {@link JdkOptionalsSer#l1() l1}
   *    .d1(double) // optional {@link JdkOptionalsSer#d1() d1}
   *    .build();
   * </pre>
   * @return A new ImmutableJdkOptionalsSer builder
   */
  public static ImmutableJdkOptionalsSer.Builder builder() {
    return new ImmutableJdkOptionalsSer.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJdkOptionalsSer ImmutableJdkOptionalsSer}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JdkOptionalsSer", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String v2;
    private @Nullable Integer i1;
    private @Nullable Long l1;
    private @Nullable Double d1;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JdkOptionalsSer} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JdkOptionalsSer instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> v2Optional = instance.v2();
      if (v2Optional.isPresent()) {
        v2(v2Optional);
      }
      OptionalInt i1Optional = instance.i1();
      if (i1Optional.isPresent()) {
        i1(i1Optional);
      }
      OptionalLong l1Optional = instance.l1();
      if (l1Optional.isPresent()) {
        l1(l1Optional);
      }
      OptionalDouble d1Optional = instance.d1();
      if (d1Optional.isPresent()) {
        d1(d1Optional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link JdkOptionalsSer#v2() v2} to v2.
     * @param v2 The value for v2
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v2(String v2) {
      this.v2 = Objects.requireNonNull(v2, "v2");
      return this;
    }

    /**
     * Initializes the optional value {@link JdkOptionalsSer#v2() v2} to v2.
     * @param v2 The value for v2
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder v2(Optional<String> v2) {
      this.v2 = v2.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link JdkOptionalsSer#i1() i1} to i1.
     * @param i1 The value for i1
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder i1(int i1) {
      this.i1 = i1;
      return this;
    }

    /**
     * Initializes the optional value {@link JdkOptionalsSer#i1() i1} to i1.
     * @param i1 The value for i1
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder i1(OptionalInt i1) {
      this.i1 = i1.isPresent() ? i1.getAsInt() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link JdkOptionalsSer#l1() l1} to l1.
     * @param l1 The value for l1
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder l1(long l1) {
      this.l1 = l1;
      return this;
    }

    /**
     * Initializes the optional value {@link JdkOptionalsSer#l1() l1} to l1.
     * @param l1 The value for l1
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder l1(OptionalLong l1) {
      this.l1 = l1.isPresent() ? l1.getAsLong() : null;
      return this;
    }

    /**
     * Initializes the optional value {@link JdkOptionalsSer#d1() d1} to d1.
     * @param d1 The value for d1
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder d1(double d1) {
      this.d1 = d1;
      return this;
    }

    /**
     * Initializes the optional value {@link JdkOptionalsSer#d1() d1} to d1.
     * @param d1 The value for d1
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder d1(OptionalDouble d1) {
      this.d1 = d1.isPresent() ? d1.getAsDouble() : null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJdkOptionalsSer ImmutableJdkOptionalsSer}.
     * @return An immutable instance of JdkOptionalsSer
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJdkOptionalsSer build() {
      return new ImmutableJdkOptionalsSer(null, v2, i1, l1, d1);
    }
  }
}
