package org.immutables.fixture.jdkonly;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JdkColl}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJdkColl.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutableJdkColl.of()}.
 */
@Generated(from = "JdkColl", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJdkColl implements JdkColl {
  private final List<String> str;
  private final Set<Integer> ints;
  private final SortedSet<Integer> ords;
  private final Set<RetentionPolicy> pols;
  private final NavigableSet<Integer> navs;

  private ImmutableJdkColl() {
    this.str = Collections.emptyList();
    this.ints = Collections.emptySet();
    this.ords = createUnmodifiableSortedSet(false, Collections.<Integer>emptyList());
    this.pols = Collections.emptySet();
    this.navs = createUnmodifiableSortedSet(true, Collections.<Integer>emptyList());
  }

  private ImmutableJdkColl(
      List<String> str,
      Set<Integer> ints,
      SortedSet<Integer> ords,
      Set<RetentionPolicy> pols,
      NavigableSet<Integer> navs) {
    this.str = str;
    this.ints = ints;
    this.ords = ords;
    this.pols = pols;
    this.navs = navs;
  }

  /**
   * @return The value of the {@code str} attribute
   */
  @Override
  public List<String> str() {
    return str;
  }

  /**
   * @return The value of the {@code ints} attribute
   */
  @Override
  public Set<Integer> ints() {
    return ints;
  }

  /**
   * @return The value of the {@code ords} attribute
   */
  @Override
  public SortedSet<Integer> ords() {
    return ords;
  }

  /**
   * @return The value of the {@code pols} attribute
   */
  @Override
  public Set<RetentionPolicy> pols() {
    return pols;
  }

  /**
   * @return The value of the {@code navs} attribute
   */
  @Override
  public NavigableSet<Integer> navs() {
    return navs;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkColl#str() str}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkColl withStr(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutableJdkColl(newValue, this.ints, this.ords, this.pols, this.navs));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkColl#str() str}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of str elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkColl withStr(Iterable<String> elements) {
    if (this.str == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutableJdkColl(newValue, this.ints, this.ords, this.pols, this.navs));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkColl#ints() ints}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkColl withInts(int... elements) {
    ArrayList<Integer> wrappedList = new ArrayList<>(elements.length);
    for (int element : elements) {
      wrappedList.add(element);
    }
    Set<Integer> newValue = createUnmodifiableSet(wrappedList);
    return validate(new ImmutableJdkColl(this.str, newValue, this.ords, this.pols, this.navs));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkColl#ints() ints}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ints elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkColl withInts(Iterable<Integer> elements) {
    if (this.ints == elements) return this;
    Set<Integer> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return validate(new ImmutableJdkColl(this.str, newValue, this.ords, this.pols, this.navs));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkColl#ords() ords}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkColl withOrds(int... elements) {
    ArrayList<Integer> wrappedList = new ArrayList<>(elements.length);
    for (int element : elements) {
      wrappedList.add(element);
    }
    SortedSet<Integer> newValue = createUnmodifiableSortedSet(false, wrappedList);
    return validate(new ImmutableJdkColl(this.str, this.ints, newValue, this.pols, this.navs));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkColl#ords() ords}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ords elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkColl withOrds(Iterable<Integer> elements) {
    if (this.ords == elements) return this;
    SortedSet<Integer> newValue = createUnmodifiableSortedSet(false, createSafeList(elements, true, false));
    return validate(new ImmutableJdkColl(this.str, this.ints, newValue, this.pols, this.navs));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkColl#pols() pols}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkColl withPols(RetentionPolicy... elements) {
    Set<RetentionPolicy> newValue = createUnmodifiableEnumSet(Arrays.asList(elements));
    return validate(new ImmutableJdkColl(this.str, this.ints, this.ords, newValue, this.navs));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkColl#pols() pols}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of pols elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkColl withPols(Iterable<RetentionPolicy> elements) {
    if (this.pols == elements) return this;
    Set<RetentionPolicy> newValue = createUnmodifiableEnumSet(elements);
    return validate(new ImmutableJdkColl(this.str, this.ints, this.ords, newValue, this.navs));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkColl#navs() navs}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkColl withNavs(int... elements) {
    ArrayList<Integer> wrappedList = new ArrayList<>(elements.length);
    for (int element : elements) {
      wrappedList.add(element);
    }
    NavigableSet<Integer> newValue = createUnmodifiableSortedSet(true, wrappedList);
    return validate(new ImmutableJdkColl(this.str, this.ints, this.ords, this.pols, newValue));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link JdkColl#navs() navs}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of navs elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJdkColl withNavs(Iterable<Integer> elements) {
    if (this.navs == elements) return this;
    NavigableSet<Integer> newValue = createUnmodifiableSortedSet(true, createSafeList(elements, true, false));
    return validate(new ImmutableJdkColl(this.str, this.ints, this.ords, this.pols, newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJdkColl} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJdkColl
        && equalTo(0, (ImmutableJdkColl) another);
  }

  private boolean equalTo(int synthetic, ImmutableJdkColl another) {
    return str.equals(another.str)
        && ints.equals(another.ints)
        && ords.equals(another.ords)
        && pols.equals(another.pols)
        && navs.equals(another.navs);
  }

  /**
   * Computes a hash code from attributes: {@code str}, {@code ints}, {@code ords}, {@code pols}, {@code navs}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + str.hashCode();
    h += (h << 5) + ints.hashCode();
    h += (h << 5) + ords.hashCode();
    h += (h << 5) + pols.hashCode();
    h += (h << 5) + navs.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code JdkColl} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JdkColl{"
        + "str=" + str
        + ", ints=" + ints
        + ", ords=" + ords
        + ", pols=" + pols
        + ", navs=" + navs
        + "}";
  }

  private static final ImmutableJdkColl INSTANCE = validate(new ImmutableJdkColl());

  /**
   * Returns the default immutable singleton value of {@code JdkColl}
   * @return An immutable instance of JdkColl
   */
  public static ImmutableJdkColl of() {
    return INSTANCE;
  }

  private static ImmutableJdkColl validate(ImmutableJdkColl instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link JdkColl} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JdkColl instance
   */
  public static ImmutableJdkColl copyOf(JdkColl instance) {
    if (instance instanceof ImmutableJdkColl) {
      return (ImmutableJdkColl) instance;
    }
    return ImmutableJdkColl.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJdkColl ImmutableJdkColl}.
   * <pre>
   * ImmutableJdkColl.builder()
   *    .addStr|addAllStr(String) // {@link JdkColl#str() str} elements
   *    .addInts|addAllInts(int) // {@link JdkColl#ints() ints} elements
   *    .addOrds|addAllOrds(int) // {@link JdkColl#ords() ords} elements
   *    .addPols|addAllPols(annotation.RetentionPolicy) // {@link JdkColl#pols() pols} elements
   *    .addNavs|addAllNavs(int) // {@link JdkColl#navs() navs} elements
   *    .build();
   * </pre>
   * @return A new ImmutableJdkColl builder
   */
  public static ImmutableJdkColl.Builder builder() {
    return new ImmutableJdkColl.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJdkColl ImmutableJdkColl}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JdkColl", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private List<String> str = new ArrayList<String>();
    private List<Integer> ints = new ArrayList<Integer>();
    private List<Integer> ords = new ArrayList<Integer>();
    private EnumSet<RetentionPolicy> pols = EnumSet.noneOf(RetentionPolicy.class);
    private List<Integer> navs = new ArrayList<Integer>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JdkColl} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JdkColl instance) {
      Objects.requireNonNull(instance, "instance");
      addAllStr(instance.str());
      addAllInts(instance.ints());
      addAllOrds(instance.ords());
      addAllPols(instance.pols());
      addAllNavs(instance.navs());
      return this;
    }

    /**
     * Adds one element to {@link JdkColl#str() str} list.
     * @param element A str element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStr(String element) {
      this.str.add(Objects.requireNonNull(element, "str element"));
      return this;
    }

    /**
     * Adds elements to {@link JdkColl#str() str} list.
     * @param elements An array of str elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addStr(String... elements) {
      for (String element : elements) {
        this.str.add(Objects.requireNonNull(element, "str element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JdkColl#str() str} list.
     * @param elements An iterable of str elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder str(Iterable<String> elements) {
      this.str.clear();
      return addAllStr(elements);
    }

    /**
     * Adds elements to {@link JdkColl#str() str} list.
     * @param elements An iterable of str elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllStr(Iterable<String> elements) {
      for (String element : elements) {
        this.str.add(Objects.requireNonNull(element, "str element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link JdkColl#ints() ints} set.
     * @param element A ints element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInts(int element) {
      this.ints.add(element);
      return this;
    }

    /**
     * Adds elements to {@link JdkColl#ints() ints} set.
     * @param elements An array of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInts(int... elements) {
      for (int element : elements) {
        this.ints.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JdkColl#ints() ints} set.
     * @param elements An iterable of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ints(Iterable<Integer> elements) {
      this.ints.clear();
      return addAllInts(elements);
    }

    /**
     * Adds elements to {@link JdkColl#ints() ints} set.
     * @param elements An iterable of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllInts(Iterable<Integer> elements) {
      for (Integer element : elements) {
        this.ints.add(Objects.requireNonNull(element, "ints element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link JdkColl#ords() ords} sortedSet.
     * @param element A ords element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOrds(int element) {
      this.ords.add(element);
      return this;
    }

    /**
     * Adds elements to {@link JdkColl#ords() ords} sortedSet.
     * @param elements An array of ords elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addOrds(int... elements) {
      for (int element : elements) {
        this.ords.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JdkColl#ords() ords} sortedSet.
     * @param elements An iterable of ords elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ords(Iterable<Integer> elements) {
      this.ords.clear();
      return addAllOrds(elements);
    }

    /**
     * Adds elements to {@link JdkColl#ords() ords} sortedSet.
     * @param elements An iterable of ords elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllOrds(Iterable<Integer> elements) {
      for (Integer element : elements) {
        this.ords.add(Objects.requireNonNull(element, "ords element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link JdkColl#pols() pols} set.
     * @param element A pols element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPols(RetentionPolicy element) {
      this.pols.add(Objects.requireNonNull(element, "pols element"));
      return this;
    }

    /**
     * Adds elements to {@link JdkColl#pols() pols} set.
     * @param elements An array of pols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPols(RetentionPolicy... elements) {
      for (RetentionPolicy element : elements) {
        this.pols.add(Objects.requireNonNull(element, "pols element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JdkColl#pols() pols} set.
     * @param elements An iterable of pols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pols(Iterable<RetentionPolicy> elements) {
      this.pols.clear();
      return addAllPols(elements);
    }

    /**
     * Adds elements to {@link JdkColl#pols() pols} set.
     * @param elements An iterable of pols elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPols(Iterable<RetentionPolicy> elements) {
      for (RetentionPolicy element : elements) {
        this.pols.add(Objects.requireNonNull(element, "pols element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link JdkColl#navs() navs} sortedSet.
     * @param element A navs element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNavs(int element) {
      this.navs.add(element);
      return this;
    }

    /**
     * Adds elements to {@link JdkColl#navs() navs} sortedSet.
     * @param elements An array of navs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNavs(int... elements) {
      for (int element : elements) {
        this.navs.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link JdkColl#navs() navs} sortedSet.
     * @param elements An iterable of navs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder navs(Iterable<Integer> elements) {
      this.navs.clear();
      return addAllNavs(elements);
    }

    /**
     * Adds elements to {@link JdkColl#navs() navs} sortedSet.
     * @param elements An iterable of navs elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNavs(Iterable<Integer> elements) {
      for (Integer element : elements) {
        this.navs.add(Objects.requireNonNull(element, "navs element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableJdkColl ImmutableJdkColl}.
     * @return An immutable instance of JdkColl
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJdkColl build() {
      return ImmutableJdkColl.validate(new ImmutableJdkColl(
          createUnmodifiableList(true, str),
          createUnmodifiableSet(ints),
          createUnmodifiableSortedSet(false, createSafeList(ords, false, false)),
          createUnmodifiableEnumSet(pols),
          createUnmodifiableSortedSet(true, createSafeList(navs, false, false))));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }

  @SuppressWarnings("unchecked")
  private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
    if (iterable instanceof EnumSet<?>) {
      return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet<T>) iterable));
    }
    List<T> list = createSafeList(iterable, true, false);
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default: return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }
  }

  private static <T extends Comparable<T>> NavigableSet<T> createUnmodifiableSortedSet(boolean reverse, List<T> list) {
    TreeSet<T> set = reverse
        ? new TreeSet<T>(Collections.<T>reverseOrder())
        : new TreeSet<T>();
    set.addAll(list);
    return Collections.unmodifiableNavigableSet(set);
  }
}
