package org.immutables.fixture.jdkonly;

import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DefaultArray}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDefaultArray.builder()}.
 */
@Generated(from = "DefaultArray", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableDefaultArray extends DefaultArray {
  private final int[] prop;
  private final ImmutableSet<Integer> ints;

  private ImmutableDefaultArray(ImmutableDefaultArray.Builder builder) {
    if (builder.prop != null) {
      initShim.prop(builder.prop);
    }
    if (builder.intsIsSet()) {
      initShim.ints(builder.ints.build());
    }
    this.prop = initShim.prop();
    this.ints = initShim.ints();
    this.initShim = null;
  }

  private ImmutableDefaultArray(int[] prop, ImmutableSet<Integer> ints) {
    this.prop = prop;
    this.ints = ints;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "DefaultArray", generator = "Immutables")
  private final class InitShim {
    private byte propBuildStage = STAGE_UNINITIALIZED;
    private int[] prop;

    int[] prop() {
      if (propBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (propBuildStage == STAGE_UNINITIALIZED) {
        propBuildStage = STAGE_INITIALIZING;
        this.prop = ImmutableDefaultArray.super.prop().clone();
        propBuildStage = STAGE_INITIALIZED;
      }
      return this.prop;
    }

    void prop(int[] prop) {
      this.prop = prop;
      propBuildStage = STAGE_INITIALIZED;
    }

    private byte intsBuildStage = STAGE_UNINITIALIZED;
    private ImmutableSet<Integer> ints;

    ImmutableSet<Integer> ints() {
      if (intsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (intsBuildStage == STAGE_UNINITIALIZED) {
        intsBuildStage = STAGE_INITIALIZING;
        this.ints = Objects.requireNonNull(ImmutableDefaultArray.super.ints(), "ints");
        intsBuildStage = STAGE_INITIALIZED;
      }
      return this.ints;
    }

    void ints(ImmutableSet<Integer> ints) {
      this.ints = ints;
      intsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (propBuildStage == STAGE_INITIALIZING) attributes.add("prop");
      if (intsBuildStage == STAGE_INITIALIZING) attributes.add("ints");
      return "Cannot build DefaultArray, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return A cloned {@code prop} array
   */
  @Override
  int[] prop() {
    InitShim shim = this.initShim;
    return shim != null
      ? shim.prop().clone()
      : this.prop.clone();
  }

  /**
   * @return The value of the {@code ints} attribute
   */
  @Override
  ImmutableSet<Integer> ints() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.ints()
        : this.ints;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultArray#prop() prop}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for prop
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultArray withProp(int... elements) {
    int[] newValue = elements.clone();
    return new ImmutableDefaultArray(newValue, this.ints);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultArray#ints() ints}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultArray withInts(int... elements) {
    ImmutableSet<Integer> newValue = ImmutableSet.copyOf(Ints.asList(elements));
    return new ImmutableDefaultArray(this.prop, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link DefaultArray#ints() ints}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ints elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableDefaultArray withInts(Iterable<Integer> elements) {
    if (this.ints == elements) return this;
    ImmutableSet<Integer> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableDefaultArray(this.prop, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDefaultArray} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDefaultArray
        && equalTo(0, (ImmutableDefaultArray) another);
  }

  private boolean equalTo(int synthetic, ImmutableDefaultArray another) {
    return Arrays.equals(prop, another.prop)
        && ints.equals(another.ints);
  }

  /**
   * Computes a hash code from attributes: {@code prop}, {@code ints}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Arrays.hashCode(prop);
    h += (h << 5) + ints.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DefaultArray} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DefaultArray{"
        + "prop=" + Arrays.toString(prop)
        + ", ints=" + ints
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DefaultArray} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DefaultArray instance
   */
  public static ImmutableDefaultArray copyOf(DefaultArray instance) {
    if (instance instanceof ImmutableDefaultArray) {
      return (ImmutableDefaultArray) instance;
    }
    return ImmutableDefaultArray.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDefaultArray ImmutableDefaultArray}.
   * <pre>
   * ImmutableDefaultArray.builder()
   *    .prop(int) // optional {@link DefaultArray#prop() prop}
   *    .addInts|addAllInts(int) // {@link DefaultArray#ints() ints} elements
   *    .build();
   * </pre>
   * @return A new ImmutableDefaultArray builder
   */
  public static ImmutableDefaultArray.Builder builder() {
    return new ImmutableDefaultArray.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDefaultArray ImmutableDefaultArray}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DefaultArray", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long OPT_BIT_INTS = 0x1L;
    private long optBits;

    private @Nullable int[] prop;
    private ImmutableSet.Builder<Integer> ints = ImmutableSet.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DefaultArray} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(DefaultArray instance) {
      Objects.requireNonNull(instance, "instance");
      prop(instance.prop());
      addAllInts(instance.ints());
      return this;
    }

    /**
     * Initializes the value for the {@link DefaultArray#prop() prop} attribute.
     * <p><em>If not set, this attribute will have a default value as defined by {@link DefaultArray#prop() prop}.</em>
     * @param prop The elements for prop
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder prop(int... prop) {
      this.prop = prop.clone();
      return this;
    }

    /**
     * Adds one element to {@link DefaultArray#ints() ints} set.
     * @param element A ints element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInts(int element) {
      this.ints.add(element);
      optBits |= OPT_BIT_INTS;
      return this;
    }

    /**
     * Adds elements to {@link DefaultArray#ints() ints} set.
     * @param elements An array of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addInts(int... elements) {
      this.ints.addAll(Ints.asList(elements));
      optBits |= OPT_BIT_INTS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link DefaultArray#ints() ints} set.
     * @param elements An iterable of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ints(Iterable<Integer> elements) {
      this.ints = ImmutableSet.builder();
      return addAllInts(elements);
    }

    /**
     * Adds elements to {@link DefaultArray#ints() ints} set.
     * @param elements An iterable of ints elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllInts(Iterable<Integer> elements) {
      this.ints.addAll(elements);
      optBits |= OPT_BIT_INTS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDefaultArray ImmutableDefaultArray}.
     * @return An immutable instance of DefaultArray
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDefaultArray build() {
      return new ImmutableDefaultArray(this);
    }

    private boolean intsIsSet() {
      return (optBits & OPT_BIT_INTS) != 0;
    }
  }
}
