package org.immutables.fixture.jdkonly;

import com.google.gson.*;
import com.google.gson.reflect.*;
import com.google.gson.stream.*;
import java.io.IOException;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import javax.annotation.Generated;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * A {@code TypeAdapterFactory} that handles all of the immutable types generated under {@code JdkOptionals}.
 * @see ImmutableJdkOptionals
 */
@SuppressWarnings({"all", "MethodCanBeStatic"})
@ParametersAreNonnullByDefault
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "org.immutables.fixture.jdkonly", generator = "Gsons")
public final class GsonAdaptersJdkOptionals implements TypeAdapterFactory {
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  @Override
  public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
    if (JdkOptionalsTypeAdapter.adapts(type)) {
      return (TypeAdapter<T>) new JdkOptionalsTypeAdapter(gson);
    }
    return null;
  }

  @Override
  public String toString() {
    return "GsonAdaptersJdkOptionals(JdkOptionals)";
  }

  @org.immutables.value.Generated(from = "JdkOptionals", generator = "Gsons")
  @SuppressWarnings({"unchecked", "rawtypes"}) // safe unchecked, types are verified in runtime
  private static class JdkOptionalsTypeAdapter extends TypeAdapter<JdkOptionals> {

    JdkOptionalsTypeAdapter(Gson gson) {
    } 

    static boolean adapts(TypeToken<?> type) {
      return JdkOptionals.class == type.getRawType()
          || ImmutableJdkOptionals.class == type.getRawType();
    }

    @Override
    public void write(JsonWriter out, JdkOptionals value) throws IOException {
      if (value == null) {
        out.nullValue();
      } else {
        writeJdkOptionals(out, value);
      }
    }

    @Override
    public JdkOptionals read(JsonReader in) throws IOException {
      return readJdkOptionals(in);
    }

    private void writeJdkOptionals(JsonWriter out, JdkOptionals instance)
        throws IOException {
      out.beginArray();
      Optional<String> v2Optional = instance.v2();
      if (v2Optional.isPresent()) {
        String v2Value = v2Optional.get();
        out.value(v2Value);
      } else {
        out.nullValue();
      }
      OptionalInt i1Optional = instance.i1();
      if (i1Optional.isPresent()) {
        int i1Value = i1Optional.getAsInt();
        out.value(i1Value);
      } else {
        out.nullValue();
      }
      OptionalLong l1Optional = instance.l1();
      if (l1Optional.isPresent()) {
        long l1Value = l1Optional.getAsLong();
        out.value(l1Value);
      } else {
        out.nullValue();
      }
      OptionalDouble d1Optional = instance.d1();
      if (d1Optional.isPresent()) {
        double d1Value = d1Optional.getAsDouble();
        out.value(d1Value);
      } else {
        out.nullValue();
      }
      out.endArray();
    }

    private  JdkOptionals readJdkOptionals(JsonReader in)
        throws IOException {
      if (in.peek() == JsonToken.NULL) {
        in.nextNull();
        return null;
      }
      in.beginArray();
      JdkOptionals instance = ImmutableJdkOptionals.of(
        readParameterV2(in),
        readParameterI1(in),
        readParameterL1(in),
        readParameterD1(in));
      in.endArray();
      return instance;
    }

    private  Optional<String> readParameterV2(JsonReader in)
        throws IOException {
      JsonToken t = in.peek();
      if (t == JsonToken.NULL) {
        in.nextNull();
        return Optional.empty();
      }
      return Optional.<String>of(in.nextString());
    }

    private  OptionalInt readParameterI1(JsonReader in)
        throws IOException {
      JsonToken t = in.peek();
      if (t == JsonToken.NULL) {
        in.nextNull();
        return OptionalInt.empty();
      }
      return OptionalInt.of(in.nextInt());
    }

    private  OptionalLong readParameterL1(JsonReader in)
        throws IOException {
      JsonToken t = in.peek();
      if (t == JsonToken.NULL) {
        in.nextNull();
        return OptionalLong.empty();
      }
      return OptionalLong.of(in.nextLong());
    }

    private  OptionalDouble readParameterD1(JsonReader in)
        throws IOException {
      JsonToken t = in.peek();
      if (t == JsonToken.NULL) {
        in.nextNull();
        return OptionalDouble.empty();
      }
      return OptionalDouble.of(in.nextDouble());
    }
  }
}
