package org.immutables.fixture.jackson.poly2;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _PayloadTwo}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code PayloadTwo.builder()}.
 */
@Generated(from = "_PayloadTwo", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class PayloadTwo extends org.immutables.fixture.jackson.poly2._PayloadTwo {
  private final Integer propertyOne;
  private final Long propertyTwo;

  private PayloadTwo(PayloadTwo.Builder builder) {
    this.propertyOne = builder.propertyOne;
    this.propertyTwo = builder.propertyTwo;
  }

  /**
   * Some property
   */
  @JsonProperty("propertyOne")
  @Override
  public Integer getPropertyOne() {
    return propertyOne;
  }

  /**
   * Another property
   */
  @JsonProperty("propertyTwo")
  @Override
  public Long getPropertyTwo() {
    return propertyTwo;
  }

  /**
   * This instance is equal to all instances of {@code PayloadTwo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof PayloadTwo
        && equalTo(0, (PayloadTwo) another);
  }

  private boolean equalTo(int synthetic, PayloadTwo another) {
    return propertyOne.equals(another.propertyOne)
        && propertyTwo.equals(another.propertyTwo);
  }

  /**
   * Computes a hash code from attributes: {@code propertyOne}, {@code propertyTwo}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + propertyOne.hashCode();
    h += (h << 5) + propertyTwo.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PayloadTwo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("PayloadTwo")
        .omitNullValues()
        .add("propertyOne", propertyOne)
        .add("propertyTwo", propertyTwo)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_PayloadTwo", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.immutables.fixture.jackson.poly2._PayloadTwo {
    @Nullable Integer propertyOne;
    @Nullable Long propertyTwo;
    @JsonProperty("propertyOne")
    public void setPropertyOne(Integer propertyOne) {
      this.propertyOne = propertyOne;
    }
    @JsonProperty("propertyTwo")
    public void setPropertyTwo(Long propertyTwo) {
      this.propertyTwo = propertyTwo;
    }
    @Override
    public Integer getPropertyOne() { throw new UnsupportedOperationException(); }
    @Override
    public Long getPropertyTwo() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static PayloadTwo fromJson(Json json) {
    PayloadTwo.Builder builder = PayloadTwo.builder();
    if (json.propertyOne != null) {
      builder.propertyOne(json.propertyOne);
    }
    if (json.propertyTwo != null) {
      builder.propertyTwo(json.propertyTwo);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link PayloadTwo PayloadTwo}.
   * <pre>
   * PayloadTwo.builder()
   *    .propertyOne(Integer) // required {@link PayloadTwo#getPropertyOne() propertyOne}
   *    .propertyTwo(Long) // required {@link PayloadTwo#getPropertyTwo() propertyTwo}
   *    .build();
   * </pre>
   * @return A new PayloadTwo builder
   */
  public static PayloadTwo.Builder builder() {
    return new PayloadTwo.Builder();
  }

  /**
   * Builds instances of type {@link PayloadTwo PayloadTwo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_PayloadTwo", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PROPERTY_ONE = 0x1L;
    private static final long INIT_BIT_PROPERTY_TWO = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Integer propertyOne;
    private @Nullable Long propertyTwo;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PayloadTwo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PayloadTwo instance) {
      return from((_PayloadTwo) instance);
    }

    /**
     * Copy abstract value type {@code _PayloadTwo} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(_PayloadTwo instance) {
      Objects.requireNonNull(instance, "instance");
      propertyOne(instance.getPropertyOne());
      propertyTwo(instance.getPropertyTwo());
      return this;
    }

    /**
     * Initializes the value for the {@link PayloadTwo#getPropertyOne() propertyOne} attribute.
     * @param propertyOne The value for propertyOne 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("propertyOne")
    public final Builder propertyOne(Integer propertyOne) {
      this.propertyOne = Objects.requireNonNull(propertyOne, "propertyOne");
      initBits &= ~INIT_BIT_PROPERTY_ONE;
      return this;
    }

    /**
     * Initializes the value for the {@link PayloadTwo#getPropertyTwo() propertyTwo} attribute.
     * @param propertyTwo The value for propertyTwo 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("propertyTwo")
    public final Builder propertyTwo(Long propertyTwo) {
      this.propertyTwo = Objects.requireNonNull(propertyTwo, "propertyTwo");
      initBits &= ~INIT_BIT_PROPERTY_TWO;
      return this;
    }

    /**
     * Builds a new {@link PayloadTwo PayloadTwo}.
     * @return An immutable instance of PayloadTwo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public PayloadTwo build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new PayloadTwo(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROPERTY_ONE) != 0) attributes.add("propertyOne");
      if ((initBits & INIT_BIT_PROPERTY_TWO) != 0) attributes.add("propertyTwo");
      return "Cannot build PayloadTwo, some of required attributes are not set " + attributes;
    }
  }
}
