package org.immutables.fixture.jackson.poly2;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _AbstractResponse}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code AbstractResponse.builder()}.
 */
@Generated(from = "_AbstractResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class AbstractResponse extends org.immutables.fixture.jackson.poly2._AbstractResponse {
  private final String type;
  private final Payload payload;

  private AbstractResponse(AbstractResponse.Builder builder) {
    this.type = builder.type;
    this.payload = builder.payload;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return The value of the {@code payload} attribute
   */
  @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type")
  @JsonSubTypes({@JsonSubTypes.Type(name = "one", value = PayloadOne.class), @JsonSubTypes.Type(name = "two", value = PayloadTwo.class)})
  @JsonProperty("payload")
  @Override
  public Payload getPayload() {
    return payload;
  }

  /**
   * This instance is equal to all instances of {@code AbstractResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof AbstractResponse
        && equalTo(0, (AbstractResponse) another);
  }

  private boolean equalTo(int synthetic, AbstractResponse another) {
    return type.equals(another.type)
        && payload.equals(another.payload);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code payload}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + type.hashCode();
    h += (h << 5) + payload.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code AbstractResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("AbstractResponse")
        .omitNullValues()
        .add("type", type)
        .add("payload", payload)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_AbstractResponse", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.immutables.fixture.jackson.poly2._AbstractResponse {
    @Nullable String type;
    @Nullable Payload payload;
    @JsonProperty("type")
    public void setType(String type) {
      this.type = type;
    }
    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type")
    @JsonSubTypes({@JsonSubTypes.Type(name = "one", value = PayloadOne.class), @JsonSubTypes.Type(name = "two", value = PayloadTwo.class)})
    @JsonProperty("payload")
    public void setPayload(Payload payload) {
      this.payload = payload;
    }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
    @Override
    public Payload getPayload() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static AbstractResponse fromJson(Json json) {
    AbstractResponse.Builder builder = AbstractResponse.builder();
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.payload != null) {
      builder.payload(json.payload);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link AbstractResponse AbstractResponse}.
   * <pre>
   * AbstractResponse.builder()
   *    .type(String) // required {@link AbstractResponse#getType() type}
   *    .payload(org.immutables.fixture.jackson.poly2.Payload) // required {@link AbstractResponse#getPayload() payload}
   *    .build();
   * </pre>
   * @return A new AbstractResponse builder
   */
  public static AbstractResponse.Builder builder() {
    return new AbstractResponse.Builder();
  }

  /**
   * Builds instances of type {@link AbstractResponse AbstractResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_AbstractResponse", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_PAYLOAD = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String type;
    private @Nullable Payload payload;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code AbstractResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractResponse instance) {
      return from((_AbstractResponse) instance);
    }

    /**
     * Copy abstract value type {@code _AbstractResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(_AbstractResponse instance) {
      Objects.requireNonNull(instance, "instance");
      type(instance.getType());
      payload(instance.getPayload());
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractResponse#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("type")
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractResponse#getPayload() payload} attribute.
     * @param payload The value for payload 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type")
    @JsonSubTypes({@JsonSubTypes.Type(name = "one", value = PayloadOne.class), @JsonSubTypes.Type(name = "two", value = PayloadTwo.class)})
    @JsonProperty("payload")
    public final Builder payload(Payload payload) {
      this.payload = Objects.requireNonNull(payload, "payload");
      initBits &= ~INIT_BIT_PAYLOAD;
      return this;
    }

    /**
     * Builds a new {@link AbstractResponse AbstractResponse}.
     * @return An immutable instance of AbstractResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public AbstractResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new AbstractResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_PAYLOAD) != 0) attributes.add("payload");
      return "Cannot build AbstractResponse, some of required attributes are not set " + attributes;
    }
  }
}
