package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Builds instances of type {@link PackageHidden PackageHidden}.
 * Initialize attributes and then invoke the {@link #build()} method to create an
 * immutable instance.
 * <p><em>{@code PackageHiddenBuilder} is not thread-safe and generally should not be stored in a field or collection,
 * but instead used immediately to create instances.</em>
 */
@Generated(from = "PackageHidden", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@NotThreadSafe
public final class PackageHiddenBuilder {
  private List<String> strings = new ArrayList<String>();

  /**
   * Creates a builder for {@link PackageHidden PackageHidden} instances.
   * <pre>
   * new PackageHiddenBuilder()
   *    .addStrings|addAllStrings(String) // {@link PackageHidden#getStrings() strings} elements
   *    .build();
   * </pre>
   */
  public PackageHiddenBuilder() {
  }

  /**
   * Fill a builder with attribute values from the provided {@code PackageHidden} instance.
   * Regular attribute values will be replaced with those from the given instance.
   * Absent optional values will not replace present values.
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final PackageHiddenBuilder from(PackageHidden instance) {
    Objects.requireNonNull(instance, "instance");
    addAllStrings(instance.getStrings());
    return this;
  }

  /**
   * Adds one element to {@link PackageHidden#getStrings() strings} list.
   * @param element A strings element
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final PackageHiddenBuilder addStrings(String element) {
    this.strings.add(Objects.requireNonNull(element, "strings element"));
    return this;
  }

  /**
   * Adds elements to {@link PackageHidden#getStrings() strings} list.
   * @param elements An array of strings elements
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final PackageHiddenBuilder addStrings(String... elements) {
    for (String element : elements) {
      this.strings.add(Objects.requireNonNull(element, "strings element"));
    }
    return this;
  }


  /**
   * Sets or replaces all elements for {@link PackageHidden#getStrings() strings} list.
   * @param elements An iterable of strings elements
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  @JsonProperty("strings")
  public final PackageHiddenBuilder strings(Iterable<String> elements) {
    this.strings.clear();
    return addAllStrings(elements);
  }

  /**
   * Adds elements to {@link PackageHidden#getStrings() strings} list.
   * @param elements An iterable of strings elements
   * @return {@code this} builder for use in a chained invocation
   */
  @CanIgnoreReturnValue 
  public final PackageHiddenBuilder addAllStrings(Iterable<String> elements) {
    for (String element : elements) {
      this.strings.add(Objects.requireNonNull(element, "strings element"));
    }
    return this;
  }

  /**
   * Builds a new {@link PackageHidden PackageHidden}.
   * @return An immutable instance of PackageHidden
   * @throws java.lang.IllegalStateException if any required attributes are missing
   */
  public PackageHidden build() {
    return new PackageHiddenBuilder.ImmutablePackageHidden(createUnmodifiableList(true, strings));
  }

  /**
   * Immutable implementation of {@link PackageHidden}.
   * <p>
   * Use the builder to create immutable instances:
   * {@code new PackageHiddenBuilder()}.
   */
  @Generated(from = "PackageHidden", generator = "Immutables")
  @Immutable
  @CheckReturnValue
  static final class ImmutablePackageHidden implements PackageHidden {
    private final List<String> strings;

    private ImmutablePackageHidden(List<String> strings) {
      this.strings = strings;
    }

    /**
     * @return The value of the {@code strings} attribute
     */
    @JsonProperty("strings")
    @Override
    public List<String> getStrings() {
      return strings;
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link PackageHidden#getStrings() strings}.
     * @param elements The elements to set
     * @return A modified copy of {@code this} object
     */
    public final PackageHiddenBuilder.ImmutablePackageHidden withStrings(String... elements) {
      List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
      return new PackageHiddenBuilder.ImmutablePackageHidden(newValue);
    }

    /**
     * Copy the current immutable object with elements that replace the content of {@link PackageHidden#getStrings() strings}.
     * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
     * @param elements An iterable of strings elements to set
     * @return A modified copy of {@code this} object
     */
    public final PackageHiddenBuilder.ImmutablePackageHidden withStrings(Iterable<String> elements) {
      if (this.strings == elements) return this;
      List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
      return new PackageHiddenBuilder.ImmutablePackageHidden(newValue);
    }

    /**
     * This instance is equal to all instances of {@code ImmutablePackageHidden} that have equal attribute values.
     * @return {@code true} if {@code this} is equal to {@code another} instance
     */
    @Override
    public boolean equals(@Nullable Object another) {
      if (this == another) return true;
      return another instanceof PackageHiddenBuilder.ImmutablePackageHidden
          && equalTo(0, (PackageHiddenBuilder.ImmutablePackageHidden) another);
    }

    private boolean equalTo(int synthetic, PackageHiddenBuilder.ImmutablePackageHidden another) {
      return strings.equals(another.strings);
    }

    /**
     * Computes a hash code from attributes: {@code strings}.
     * @return hashCode value
     */
    @Override
    public int hashCode() {
      @Var int h = 5381;
      h += (h << 5) + strings.hashCode();
      return h;
    }

    /**
     * Prints the immutable value {@code PackageHidden} with attribute values.
     * @return A string representation of the value
     */
    @Override
    public String toString() {
      return "PackageHidden{"
          + "strings=" + strings
          + "}";
    }

    /**
     * Utility type used to correctly read immutable object from JSON representation.
     * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Generated(from = "PackageHidden", generator = "Immutables")
    @Deprecated
    @SuppressWarnings("Immutable")
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
    static final class Json implements PackageHidden {
      @Nullable List<String> strings = Collections.emptyList();
      @JsonProperty("strings")
      public void setStrings(List<String> strings) {
        this.strings = strings;
      }
      @Override
      public List<String> getStrings() { throw new UnsupportedOperationException(); }
    }

    /**
     * @param json A JSON-bindable data structure
     * @return An immutable value type
     * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
     */
    @Deprecated
    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    static PackageHiddenBuilder.ImmutablePackageHidden fromJson(Json json) {
      PackageHiddenBuilder builder = new PackageHiddenBuilder();
      if (json.strings != null) {
        builder.addAllStrings(json.strings);
      }
      return (PackageHiddenBuilder.ImmutablePackageHidden) builder.build();
    }

    /**
     * Creates an immutable copy of a {@link PackageHidden} value.
     * Uses accessors to get values to initialize the new immutable instance.
     * If an instance is already immutable, it is returned as is.
     * @param instance The instance to copy
     * @return A copied immutable PackageHidden instance
     */
    public static PackageHidden copyOf(PackageHidden instance) {
      if (instance instanceof PackageHiddenBuilder.ImmutablePackageHidden) {
        return (PackageHiddenBuilder.ImmutablePackageHidden) instance;
      }
      return new PackageHiddenBuilder()
          .from(instance)
          .build();
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
