package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Val}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableVal.builder()}.
 */
@Generated(from = "Val", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutableVal implements Val {

  private ImmutableVal(ImmutableVal.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableVal} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableVal
        && equalTo(0, (ImmutableVal) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableVal another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -167648851;
  }

  /**
   * Prints the immutable value {@code Val}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Val{}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Val", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements Val {
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableVal fromJson(Json json) {
    ImmutableVal.Builder builder = ImmutableVal.builder();
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Val} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Val instance
   */
  public static ImmutableVal copyOf(Val instance) {
    if (instance instanceof ImmutableVal) {
      return (ImmutableVal) instance;
    }
    return ImmutableVal.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableVal ImmutableVal}.
   * <pre>
   * ImmutableVal.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableVal builder
   */
  public static ImmutableVal.Builder builder() {
    return new ImmutableVal.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableVal ImmutableVal}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Val", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Val} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Val instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableVal ImmutableVal}.
     * @return An immutable instance of Val
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableVal build() {
      return new ImmutableVal(this);
    }
  }
}
