package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ToStringAndHashCodeAbstract}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableToStringAndHashCodeAbstract.builder()}.
 */
@Generated(from = "ToStringAndHashCodeAbstract", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableToStringAndHashCodeAbstract
    extends ToStringAndHashCodeAbstract {
  private final long test;

  private ImmutableToStringAndHashCodeAbstract(long test) {
    this.test = test;
  }

  /**
   * @return The value of the {@code test} attribute
   */
  @JsonProperty("test")
  @Override
  public long test() {
    return test;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ToStringAndHashCodeAbstract#test() test} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for test
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableToStringAndHashCodeAbstract withTest(long value) {
    if (this.test == value) return this;
    return new ImmutableToStringAndHashCodeAbstract(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableToStringAndHashCodeAbstract} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableToStringAndHashCodeAbstract
        && equalTo(0, (ImmutableToStringAndHashCodeAbstract) another);
  }

  private boolean equalTo(int synthetic, ImmutableToStringAndHashCodeAbstract another) {
    return test == another.test;
  }

  /**
   * Computes a hash code from attributes: {@code test}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Longs.hashCode(test);
    return h;
  }

  /**
   * Prints the immutable value {@code ToStringAndHashCodeAbstract} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ToStringAndHashCodeAbstract")
        .omitNullValues()
        .add("test", test)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ToStringAndHashCodeAbstract", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends ToStringAndHashCodeAbstract {
    long test;
    boolean testIsSet;
    @JsonProperty("test")
    public void setTest(long test) {
      this.test = test;
      this.testIsSet = true;
    }
    @Override
    public String toString() { throw new UnsupportedOperationException(); }
    @Override
    public int hashCode() { throw new UnsupportedOperationException(); }
    @Override
    public long test() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableToStringAndHashCodeAbstract fromJson(Json json) {
    ImmutableToStringAndHashCodeAbstract.Builder builder = ImmutableToStringAndHashCodeAbstract.builder();
    if (json.testIsSet) {
      builder.test(json.test);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ToStringAndHashCodeAbstract} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ToStringAndHashCodeAbstract instance
   */
  public static ImmutableToStringAndHashCodeAbstract copyOf(ToStringAndHashCodeAbstract instance) {
    if (instance instanceof ImmutableToStringAndHashCodeAbstract) {
      return (ImmutableToStringAndHashCodeAbstract) instance;
    }
    return ImmutableToStringAndHashCodeAbstract.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableToStringAndHashCodeAbstract ImmutableToStringAndHashCodeAbstract}.
   * <pre>
   * ImmutableToStringAndHashCodeAbstract.builder()
   *    .test(long) // required {@link ToStringAndHashCodeAbstract#test() test}
   *    .build();
   * </pre>
   * @return A new ImmutableToStringAndHashCodeAbstract builder
   */
  public static ImmutableToStringAndHashCodeAbstract.Builder builder() {
    return new ImmutableToStringAndHashCodeAbstract.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableToStringAndHashCodeAbstract ImmutableToStringAndHashCodeAbstract}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ToStringAndHashCodeAbstract", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TEST = 0x1L;
    private long initBits = 0x1L;

    private long test;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ToStringAndHashCodeAbstract} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ToStringAndHashCodeAbstract instance) {
      Objects.requireNonNull(instance, "instance");
      test(instance.test());
      return this;
    }

    /**
     * Initializes the value for the {@link ToStringAndHashCodeAbstract#test() test} attribute.
     * @param test The value for test 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("test")
    public final Builder test(long test) {
      this.test = test;
      initBits &= ~INIT_BIT_TEST;
      return this;
    }

    /**
     * Builds a new {@link ImmutableToStringAndHashCodeAbstract ImmutableToStringAndHashCodeAbstract}.
     * @return An immutable instance of ToStringAndHashCodeAbstract
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableToStringAndHashCodeAbstract build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableToStringAndHashCodeAbstract(test);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TEST) != 0) attributes.add("test");
      return "Cannot build ToStringAndHashCodeAbstract, some of required attributes are not set " + attributes;
    }
  }
}
