package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SampleJacksonMapped}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSampleJacksonMapped.builder()}.
 */
@Generated(from = "SampleJacksonMapped", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSampleJacksonMapped implements SampleJacksonMapped {
  private final String a;
  private final ImmutableList<Integer> b;
  private final Optional<SampleJacksonMapped.RegularPojo> pojo;

  private ImmutableSampleJacksonMapped(
      String a,
      ImmutableList<Integer> b,
      Optional<SampleJacksonMapped.RegularPojo> pojo) {
    this.a = a;
    this.b = b;
    this.pojo = pojo;
  }

  /**
   * @return The value of the {@code a} attribute
   */
  @JsonProperty("a")
  @Override
  public String a() {
    return a;
  }

  /**
   * @return The value of the {@code b} attribute
   */
  @JsonProperty("b")
  @Override
  public ImmutableList<Integer> b() {
    return b;
  }

  /**
   * @return The value of the {@code pojo} attribute
   */
  @JsonProperty("pojo")
  @Override
  public Optional<SampleJacksonMapped.RegularPojo> pojo() {
    return pojo;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SampleJacksonMapped#a() a} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for a
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSampleJacksonMapped withA(String value) {
    String newValue = Objects.requireNonNull(value, "a");
    if (this.a.equals(newValue)) return this;
    return new ImmutableSampleJacksonMapped(newValue, this.b, this.pojo);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SampleJacksonMapped#b() b}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSampleJacksonMapped withB(int... elements) {
    ImmutableList<Integer> newValue = ImmutableList.copyOf(Ints.asList(elements));
    return new ImmutableSampleJacksonMapped(this.a, newValue, this.pojo);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SampleJacksonMapped#b() b}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of b elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSampleJacksonMapped withB(Iterable<Integer> elements) {
    if (this.b == elements) return this;
    ImmutableList<Integer> newValue = ImmutableList.copyOf(elements);
    return new ImmutableSampleJacksonMapped(this.a, newValue, this.pojo);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SampleJacksonMapped#pojo() pojo} attribute.
   * @param value The value for pojo
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSampleJacksonMapped withPojo(SampleJacksonMapped.RegularPojo value) {
    Optional<SampleJacksonMapped.RegularPojo> newValue = Optional.of(value);
    if (this.pojo.isPresent() && this.pojo.get() == value) return this;
    return new ImmutableSampleJacksonMapped(this.a, this.b, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SampleJacksonMapped#pojo() pojo} attribute.
   * A shallow reference equality check on the optional value is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for pojo
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableSampleJacksonMapped withPojo(Optional<? extends SampleJacksonMapped.RegularPojo> optional) {
    Optional<SampleJacksonMapped.RegularPojo> value = (Optional<SampleJacksonMapped.RegularPojo>) optional;
    if (!this.pojo.isPresent() && !value.isPresent()) return this;
    if (this.pojo.isPresent() && value.isPresent() && this.pojo.get() == value.get()) return this;
    return new ImmutableSampleJacksonMapped(this.a, this.b, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSampleJacksonMapped} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSampleJacksonMapped
        && equalTo(0, (ImmutableSampleJacksonMapped) another);
  }

  private boolean equalTo(int synthetic, ImmutableSampleJacksonMapped another) {
    return a.equals(another.a)
        && b.equals(another.b)
        && pojo.equals(another.pojo);
  }

  /**
   * Computes a hash code from attributes: {@code a}, {@code b}, {@code pojo}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + a.hashCode();
    h += (h << 5) + b.hashCode();
    h += (h << 5) + pojo.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SampleJacksonMapped} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("SampleJacksonMapped")
        .omitNullValues()
        .add("a", a)
        .add("b", b)
        .add("pojo", pojo.orNull())
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "SampleJacksonMapped", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SampleJacksonMapped {
    @Nullable String a;
    @Nullable List<Integer> b = ImmutableList.of();
    @Nullable Optional<SampleJacksonMapped.RegularPojo> pojo = Optional.absent();
    @JsonProperty("a")
    public void setA(String a) {
      this.a = a;
    }
    @JsonProperty("b")
    public void setB(List<Integer> b) {
      this.b = b;
    }
    @JsonProperty("pojo")
    public void setPojo(Optional<SampleJacksonMapped.RegularPojo> pojo) {
      this.pojo = pojo;
    }
    @Override
    public String a() { throw new UnsupportedOperationException(); }
    @Override
    public List<Integer> b() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<SampleJacksonMapped.RegularPojo> pojo() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableSampleJacksonMapped fromJson(Json json) {
    ImmutableSampleJacksonMapped.Builder builder = ImmutableSampleJacksonMapped.builder();
    if (json.a != null) {
      builder.a(json.a);
    }
    if (json.b != null) {
      builder.addAllB(json.b);
    }
    if (json.pojo != null) {
      builder.pojo(json.pojo);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SampleJacksonMapped} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SampleJacksonMapped instance
   */
  public static ImmutableSampleJacksonMapped copyOf(SampleJacksonMapped instance) {
    if (instance instanceof ImmutableSampleJacksonMapped) {
      return (ImmutableSampleJacksonMapped) instance;
    }
    return ImmutableSampleJacksonMapped.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSampleJacksonMapped ImmutableSampleJacksonMapped}.
   * <pre>
   * ImmutableSampleJacksonMapped.builder()
   *    .a(String) // required {@link SampleJacksonMapped#a() a}
   *    .addB|addAllB(int) // {@link SampleJacksonMapped#b() b} elements
   *    .pojo(org.immutables.fixture.jackson.SampleJacksonMapped.RegularPojo) // optional {@link SampleJacksonMapped#pojo() pojo}
   *    .build();
   * </pre>
   * @return A new ImmutableSampleJacksonMapped builder
   */
  public static ImmutableSampleJacksonMapped.Builder builder() {
    return new ImmutableSampleJacksonMapped.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSampleJacksonMapped ImmutableSampleJacksonMapped}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SampleJacksonMapped", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_A = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String a;
    private ImmutableList.Builder<Integer> b = ImmutableList.builder();
    private Optional<SampleJacksonMapped.RegularPojo> pojo = Optional.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SampleJacksonMapped} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SampleJacksonMapped instance) {
      Objects.requireNonNull(instance, "instance");
      a(instance.a());
      addAllB(instance.b());
      Optional<SampleJacksonMapped.RegularPojo> pojoOptional = instance.pojo();
      if (pojoOptional.isPresent()) {
        pojo(pojoOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SampleJacksonMapped#a() a} attribute.
     * @param a The value for a 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("a")
    public final Builder a(String a) {
      this.a = Objects.requireNonNull(a, "a");
      initBits &= ~INIT_BIT_A;
      return this;
    }

    /**
     * Adds one element to {@link SampleJacksonMapped#b() b} list.
     * @param element A b element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addB(int element) {
      this.b.add(element);
      return this;
    }

    /**
     * Adds elements to {@link SampleJacksonMapped#b() b} list.
     * @param elements An array of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addB(int... elements) {
      this.b.addAll(Ints.asList(elements));
      return this;
    }


    /**
     * Sets or replaces all elements for {@link SampleJacksonMapped#b() b} list.
     * @param elements An iterable of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("b")
    public final Builder b(Iterable<Integer> elements) {
      this.b = ImmutableList.builder();
      return addAllB(elements);
    }

    /**
     * Adds elements to {@link SampleJacksonMapped#b() b} list.
     * @param elements An iterable of b elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllB(Iterable<Integer> elements) {
      this.b.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link SampleJacksonMapped#pojo() pojo} to pojo.
     * @param pojo The value for pojo
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder pojo(SampleJacksonMapped.RegularPojo pojo) {
      this.pojo = Optional.of(pojo);
      return this;
    }

    /**
     * Initializes the optional value {@link SampleJacksonMapped#pojo() pojo} to pojo.
     * @param pojo The value for pojo
     * @return {@code this} builder for use in a chained invocation
     */
    @SuppressWarnings("unchecked") // safe covariant cast
    @CanIgnoreReturnValue 
    @JsonProperty("pojo")
    public final Builder pojo(Optional<? extends SampleJacksonMapped.RegularPojo> pojo) {
      this.pojo = (Optional<SampleJacksonMapped.RegularPojo>) pojo;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSampleJacksonMapped ImmutableSampleJacksonMapped}.
     * @return An immutable instance of SampleJacksonMapped
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSampleJacksonMapped build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSampleJacksonMapped(a, b.build(), pojo);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_A) != 0) attributes.add("a");
      return "Cannot build SampleJacksonMapped, some of required attributes are not set " + attributes;
    }
  }
}
