package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PackageNoBuilderHidden}.
 * <p>
 * Use the static factory method to get the default singleton instance:
 * {@code ImmutablePackageNoBuilderHidden.of()}.
 */
@Generated(from = "PackageNoBuilderHidden", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
final class ImmutablePackageNoBuilderHidden
    implements PackageNoBuilderHidden {
  private final List<String> strings;
  private final @Nullable Integer getInt;

  private ImmutablePackageNoBuilderHidden() {
    this.strings = Collections.emptyList();
    this.getInt = null;
  }

  private ImmutablePackageNoBuilderHidden(List<String> strings, @Nullable Integer getInt) {
    this.strings = strings;
    this.getInt = getInt;
  }

  /**
   * @return The value of the {@code strings} attribute
   */
  @JsonProperty("strings")
  @Override
  public List<String> getStrings() {
    return strings;
  }

  /**
   * @return The value of the {@code getInt} attribute
   */
  @JsonProperty("int")
  @Override
  public Optional<Integer> getInt() {
    return Optional.ofNullable(getInt);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PackageNoBuilderHidden#getStrings() strings}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePackageNoBuilderHidden withStrings(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new ImmutablePackageNoBuilderHidden(newValue, this.getInt));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PackageNoBuilderHidden#getStrings() strings}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of strings elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePackageNoBuilderHidden withStrings(Iterable<String> elements) {
    if (this.strings == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new ImmutablePackageNoBuilderHidden(newValue, this.getInt));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PackageNoBuilderHidden#getInt() int} attribute.
   * @param value The value for getInt
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePackageNoBuilderHidden withInt(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.getInt, newValue)) return this;
    return validate(new ImmutablePackageNoBuilderHidden(this.strings, newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PackageNoBuilderHidden#getInt() int} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for getInt
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePackageNoBuilderHidden withInt(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.getInt, value)) return this;
    return validate(new ImmutablePackageNoBuilderHidden(this.strings, value));
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePackageNoBuilderHidden} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePackageNoBuilderHidden
        && equalTo(0, (ImmutablePackageNoBuilderHidden) another);
  }

  private boolean equalTo(int synthetic, ImmutablePackageNoBuilderHidden another) {
    return strings.equals(another.strings)
        && Objects.equals(getInt, another.getInt);
  }

  /**
   * Computes a hash code from attributes: {@code strings}, {@code getInt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + strings.hashCode();
    h += (h << 5) + Objects.hashCode(getInt);
    return h;
  }

  /**
   * Prints the immutable value {@code PackageNoBuilderHidden} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("PackageNoBuilderHidden{");
    builder.append("strings=").append(strings);
    if (getInt != null) {
      builder.append(", ");
      builder.append("int=").append(getInt);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PackageNoBuilderHidden", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PackageNoBuilderHidden {
    @Nullable List<String> strings = Collections.emptyList();
    @Nullable Optional<Integer> getInt = Optional.empty();
    @JsonProperty("strings")
    public void setStrings(List<String> strings) {
      this.strings = strings;
    }
    @JsonProperty("int")
    public void setInt(Optional<Integer> getInt) {
      this.getInt = getInt;
    }
    @Override
    public List<String> getStrings() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getInt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutablePackageNoBuilderHidden fromJson(Json json) {
    @Var ImmutablePackageNoBuilderHidden instance = (ImmutablePackageNoBuilderHidden) ImmutablePackageNoBuilderHidden.of();
    if (json.strings != null) {
      instance = instance.withStrings(json.strings);
    }
    if (json.getInt != null) {
      instance = instance.withInt(json.getInt);
    }
    return instance;
  }

  private static final ImmutablePackageNoBuilderHidden INSTANCE = validate(new ImmutablePackageNoBuilderHidden());

  /**
   * Returns the default immutable singleton value of {@code PackageNoBuilderHidden}
   * @return An immutable instance of PackageNoBuilderHidden
   */
  public static PackageNoBuilderHidden of() {
    return INSTANCE;
  }

  private static ImmutablePackageNoBuilderHidden validate(ImmutablePackageNoBuilderHidden instance) {
    return instance;
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
