package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link OptionIncludeNonEmpty}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOptionIncludeNonEmpty.builder()}.
 */
@Generated(from = "OptionIncludeNonEmpty", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableOptionIncludeNonEmpty extends OptionIncludeNonEmpty {
  private final @Nullable Integer integer;
  private final Optional<String> relationships;
  private final ImmutableMap<String, Number> map;

  private ImmutableOptionIncludeNonEmpty(
      @Nullable Integer integer,
      Optional<String> relationships,
      ImmutableMap<String, Number> map) {
    this.integer = integer;
    this.relationships = relationships;
    this.map = map;
  }

  /**
   * @return The value of the {@code integer} attribute
   */
  @JsonProperty("integer")
  @JsonInclude(JsonInclude.Include.NON_NULL)
  @Override
  public @Nullable Integer getInteger() {
    return integer;
  }

  /**
   * @return The value of the {@code relationships} attribute
   */
  @JsonProperty("relationships")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public Optional<String> getRelationships() {
    return relationships;
  }

  /**
   * @return The value of the {@code map} attribute
   */
  @JsonProperty("map")
  @JsonInclude(JsonInclude.Include.NON_EMPTY)
  @Override
  public ImmutableMap<String, Number> getMap() {
    return map;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OptionIncludeNonEmpty#getInteger() integer} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for integer (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOptionIncludeNonEmpty withInteger(@Nullable Integer value) {
    if (Objects.equals(this.integer, value)) return this;
    return new ImmutableOptionIncludeNonEmpty(value, this.relationships, this.map);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionIncludeNonEmpty#getRelationships() relationships} attribute.
   * @param value The value for relationships
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionIncludeNonEmpty withRelationships(String value) {
    Optional<String> newValue = Optional.of(value);
    if (this.relationships.equals(newValue)) return this;
    return new ImmutableOptionIncludeNonEmpty(this.integer, newValue, this.map);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionIncludeNonEmpty#getRelationships() relationships} attribute.
   * An equality check is used to prevent copying of the same value by returning {@code this}.
   * @param optional A value for relationships
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionIncludeNonEmpty withRelationships(Optional<String> optional) {
    Optional<String> value = optional;
    if (this.relationships.equals(value)) return this;
    return new ImmutableOptionIncludeNonEmpty(this.integer, value, this.map);
  }

  /**
   * Copy the current immutable object by replacing the {@link OptionIncludeNonEmpty#getMap() map} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the map map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableOptionIncludeNonEmpty withMap(Map<String, ? extends Number> entries) {
    if (this.map == entries) return this;
    ImmutableMap<String, Number> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableOptionIncludeNonEmpty(this.integer, this.relationships, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOptionIncludeNonEmpty} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOptionIncludeNonEmpty
        && equalTo(0, (ImmutableOptionIncludeNonEmpty) another);
  }

  private boolean equalTo(int synthetic, ImmutableOptionIncludeNonEmpty another) {
    return Objects.equals(integer, another.integer)
        && relationships.equals(another.relationships)
        && map.equals(another.map);
  }

  /**
   * Computes a hash code from attributes: {@code integer}, {@code relationships}, {@code map}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(integer);
    h += (h << 5) + relationships.hashCode();
    h += (h << 5) + map.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code OptionIncludeNonEmpty} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("OptionIncludeNonEmpty")
        .omitNullValues()
        .add("integer", integer)
        .add("relationships", relationships.orNull())
        .add("map", map)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "OptionIncludeNonEmpty", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends OptionIncludeNonEmpty {
    @Nullable Integer integer;
    @Nullable Optional<String> relationships = Optional.absent();
    @Nullable Map<String, Number> map = ImmutableMap.of();
    @JsonProperty("integer")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public void setInteger(@Nullable Integer integer) {
      this.integer = integer;
    }
    @JsonProperty("relationships")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setRelationships(Optional<String> relationships) {
      this.relationships = relationships;
    }
    @JsonProperty("map")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public void setMap(Map<String, Number> map) {
      this.map = map;
    }
    @Override
    public OptionIncludeNonEmpty withRelationships(Optional<String> number) { throw new UnsupportedOperationException(); }
    @Override
    public OptionIncludeNonEmpty withMap(Map<String, ? extends Number> number) { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInteger() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getRelationships() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Number> getMap() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableOptionIncludeNonEmpty fromJson(Json json) {
    ImmutableOptionIncludeNonEmpty.Builder builder = ImmutableOptionIncludeNonEmpty.builder();
    if (json.integer != null) {
      builder.integer(json.integer);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    if (json.map != null) {
      builder.putAllMap(json.map);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link OptionIncludeNonEmpty} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OptionIncludeNonEmpty instance
   */
  public static ImmutableOptionIncludeNonEmpty copyOf(OptionIncludeNonEmpty instance) {
    if (instance instanceof ImmutableOptionIncludeNonEmpty) {
      return (ImmutableOptionIncludeNonEmpty) instance;
    }
    return ImmutableOptionIncludeNonEmpty.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOptionIncludeNonEmpty ImmutableOptionIncludeNonEmpty}.
   * <pre>
   * ImmutableOptionIncludeNonEmpty.builder()
   *    .integer(Integer | null) // nullable {@link OptionIncludeNonEmpty#getInteger() integer}
   *    .relationships(String) // optional {@link OptionIncludeNonEmpty#getRelationships() relationships}
   *    .putMap|putAllMap(String =&gt; Number) // {@link OptionIncludeNonEmpty#getMap() map} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableOptionIncludeNonEmpty builder
   */
  public static ImmutableOptionIncludeNonEmpty.Builder builder() {
    return new ImmutableOptionIncludeNonEmpty.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOptionIncludeNonEmpty ImmutableOptionIncludeNonEmpty}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "OptionIncludeNonEmpty", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable Integer integer;
    private Optional<String> relationships = Optional.absent();
    private ImmutableMap.Builder<String, Number> map = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.jackson.OptionIncludeNonEmpty} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(OptionIncludeNonEmpty instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.immutables.fixture.jackson.Inherited} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Inherited instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof OptionIncludeNonEmpty) {
        OptionIncludeNonEmpty instance = (OptionIncludeNonEmpty) object;
        Optional<String> relationshipsOptional = instance.getRelationships();
        if (relationshipsOptional.isPresent()) {
          relationships(relationshipsOptional);
        }
        putAllMap(instance.getMap());
      }
      if (object instanceof Inherited) {
        Inherited instance = (Inherited) object;
        @Nullable Integer integerValue = instance.getInteger();
        if (integerValue != null) {
          integer(integerValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link OptionIncludeNonEmpty#getInteger() integer} attribute.
     * @param integer The value for integer (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("integer")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public final Builder integer(@Nullable Integer integer) {
      this.integer = integer;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionIncludeNonEmpty#getRelationships() relationships} to relationships.
     * @param relationships The value for relationships
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder relationships(String relationships) {
      this.relationships = Optional.of(relationships);
      return this;
    }

    /**
     * Initializes the optional value {@link OptionIncludeNonEmpty#getRelationships() relationships} to relationships.
     * @param relationships The value for relationships
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("relationships")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public final Builder relationships(Optional<String> relationships) {
      this.relationships = relationships;
      return this;
    }

    /**
     * Put one entry to the {@link OptionIncludeNonEmpty#getMap() map} map.
     * @param key The key in the map map
     * @param value The associated value in the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(String key, Number value) {
      this.map.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link OptionIncludeNonEmpty#getMap() map} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMap(Map.Entry<String, ? extends Number> entry) {
      this.map.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link OptionIncludeNonEmpty#getMap() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("map")
    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    public final Builder map(Map<String, ? extends Number> entries) {
      this.map = ImmutableMap.builder();
      return putAllMap(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link OptionIncludeNonEmpty#getMap() map} map. Nulls are not permitted
     * @param entries The entries that will be added to the map map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMap(Map<String, ? extends Number> entries) {
      this.map.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableOptionIncludeNonEmpty ImmutableOptionIncludeNonEmpty}.
     * @return An immutable instance of OptionIncludeNonEmpty
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOptionIncludeNonEmpty build() {
      return new ImmutableOptionIncludeNonEmpty(integer, relationships, map.build());
    }
  }
}
