package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JacksonUsingMeta}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJacksonUsingMeta.builder()}.
 */
@Generated(from = "JacksonUsingMeta", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableJacksonUsingMeta implements JacksonUsingMeta {
  private final ImmutableMap<String, JsonNode> any;
  private final int y;

  private ImmutableJacksonUsingMeta(
      ImmutableMap<String, JsonNode> any,
      int y) {
    this.any = any;
    this.y = y;
  }

  /**
   * @return The value of the {@code any} attribute
   */
  @JsonProperty("any")
  @JsonAnyGetter
  @Override
  public ImmutableMap<String, JsonNode> any() {
    return any;
  }

  /**
   * @return The value of the {@code y} attribute
   */
  @JsonProperty("X")
  @Override
  public int y() {
    return y;
  }

  /**
   * Copy the current immutable object by replacing the {@link JacksonUsingMeta#any() any} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the any map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJacksonUsingMeta withAny(Map<String, ? extends JsonNode> entries) {
    if (this.any == entries) return this;
    ImmutableMap<String, JsonNode> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableJacksonUsingMeta(newValue, this.y);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JacksonUsingMeta#y() y} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for y
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJacksonUsingMeta withY(int value) {
    if (this.y == value) return this;
    return new ImmutableJacksonUsingMeta(this.any, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJacksonUsingMeta} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJacksonUsingMeta
        && equalTo(0, (ImmutableJacksonUsingMeta) another);
  }

  private boolean equalTo(int synthetic, ImmutableJacksonUsingMeta another) {
    return any.equals(another.any)
        && y == another.y;
  }

  /**
   * Computes a hash code from attributes: {@code any}, {@code y}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + any.hashCode();
    h += (h << 5) + y;
    return h;
  }

  /**
   * Prints the immutable value {@code JacksonUsingMeta} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("JacksonUsingMeta")
        .omitNullValues()
        .add("any", any)
        .add("y", y)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "JacksonUsingMeta", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements JacksonUsingMeta {
    int y;
    boolean yIsSet;
    final Map<String, JsonNode> any = new HashMap<String, JsonNode>();
    @JsonProperty("X")
    public void setY(int y) {
      this.y = y;
      this.yIsSet = true;
    }

    @JsonAnySetter
    public void setAny(String key, JsonNode value) {
      this.any.put(key, value);
    }
    @Override
    public Map<String, JsonNode> any() { throw new UnsupportedOperationException(); }
    @Override
    public int y() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableJacksonUsingMeta fromJson(Json json) {
    ImmutableJacksonUsingMeta.Builder builder = ImmutableJacksonUsingMeta.builder();
    if (json.any != null) {
      builder.putAllAny(json.any);
    }
    if (json.yIsSet) {
      builder.y(json.y);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link JacksonUsingMeta} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JacksonUsingMeta instance
   */
  public static ImmutableJacksonUsingMeta copyOf(JacksonUsingMeta instance) {
    if (instance instanceof ImmutableJacksonUsingMeta) {
      return (ImmutableJacksonUsingMeta) instance;
    }
    return ImmutableJacksonUsingMeta.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJacksonUsingMeta ImmutableJacksonUsingMeta}.
   * <pre>
   * ImmutableJacksonUsingMeta.builder()
   *    .putAny|putAllAny(String =&gt; com.fasterxml.jackson.databind.JsonNode) // {@link JacksonUsingMeta#any() any} mappings
   *    .y(int) // required {@link JacksonUsingMeta#y() y}
   *    .build();
   * </pre>
   * @return A new ImmutableJacksonUsingMeta builder
   */
  public static ImmutableJacksonUsingMeta.Builder builder() {
    return new ImmutableJacksonUsingMeta.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJacksonUsingMeta ImmutableJacksonUsingMeta}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JacksonUsingMeta", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_Y = 0x1L;
    private long initBits = 0x1L;

    private ImmutableMap.Builder<String, JsonNode> any = ImmutableMap.builder();
    private int y;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code JacksonUsingMeta} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(JacksonUsingMeta instance) {
      Objects.requireNonNull(instance, "instance");
      putAllAny(instance.any());
      y(instance.y());
      return this;
    }

    /**
     * Put one entry to the {@link JacksonUsingMeta#any() any} map.
     * @param key The key in the any map
     * @param value The associated value in the any map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonAnySetter
    public final Builder putAny(String key, JsonNode value) {
      this.any.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link JacksonUsingMeta#any() any} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAny(Map.Entry<String, ? extends JsonNode> entry) {
      this.any.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link JacksonUsingMeta#any() any} map. Nulls are not permitted
     * @param entries The entries that will be added to the any map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder any(Map<String, ? extends JsonNode> entries) {
      this.any = ImmutableMap.builder();
      return putAllAny(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link JacksonUsingMeta#any() any} map. Nulls are not permitted
     * @param entries The entries that will be added to the any map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllAny(Map<String, ? extends JsonNode> entries) {
      this.any.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link JacksonUsingMeta#y() y} attribute.
     * @param y The value for y 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder y(int y) {
      this.y = y;
      initBits &= ~INIT_BIT_Y;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJacksonUsingMeta ImmutableJacksonUsingMeta}.
     * @return An immutable instance of JacksonUsingMeta
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJacksonUsingMeta build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableJacksonUsingMeta(any.build(), y);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_Y) != 0) attributes.add("y");
      return "Cannot build JacksonUsingMeta, some of required attributes are not set " + attributes;
    }
  }
}
