package org.immutables.fixture.jackson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ConstructorJacksonMapped}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code ImmutableConstructorJacksonMapped.of()}.
 */
@Generated(from = "ConstructorJacksonMapped", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableConstructorJacksonMapped
    implements ConstructorJacksonMapped {
  private final int instance;
  private final String bal;

  private ImmutableConstructorJacksonMapped(int instance, String bal) {
    this.instance = instance;
    this.bal = Objects.requireNonNull(bal, "bal");
  }

  private ImmutableConstructorJacksonMapped(ImmutableConstructorJacksonMapped original, int instance, String bal) {
    this.instance = instance;
    this.bal = bal;
  }

  /**
   * @return The value of the {@code instance} attribute
   */
  @JsonProperty("X")
  @Override
  public int instance() {
    return instance;
  }

  /**
   * @return The value of the {@code bal} attribute
   */
  @JsonProperty("bal")
  @Override
  public String bal() {
    return bal;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConstructorJacksonMapped#instance() instance} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for instance
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConstructorJacksonMapped withInstance(int value) {
    if (this.instance == value) return this;
    return new ImmutableConstructorJacksonMapped(this, value, this.bal);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConstructorJacksonMapped#bal() bal} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bal
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableConstructorJacksonMapped withBal(String value) {
    String newValue = Objects.requireNonNull(value, "bal");
    if (this.bal.equals(newValue)) return this;
    return new ImmutableConstructorJacksonMapped(this, this.instance, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableConstructorJacksonMapped} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableConstructorJacksonMapped
        && equalTo(0, (ImmutableConstructorJacksonMapped) another);
  }

  private boolean equalTo(int synthetic, ImmutableConstructorJacksonMapped another) {
    return instance == another.instance
        && bal.equals(another.bal);
  }

  /**
   * Computes a hash code from attributes: {@code instance}, {@code bal}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + instance;
    h += (h << 5) + bal.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ConstructorJacksonMapped} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ConstructorJacksonMapped")
        .omitNullValues()
        .add("instance", instance)
        .add("bal", bal)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "ConstructorJacksonMapped", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ConstructorJacksonMapped {
    int instance;
    boolean instanceIsSet;
    @Nullable String bal;
    @JsonProperty("X")
    public void setInstance(int instance) {
      this.instance = instance;
      this.instanceIsSet = true;
    }
    @JsonProperty("bal")
    public void setBal(String bal) {
      this.bal = bal;
    }
    @Override
    public int instance() { throw new UnsupportedOperationException(); }
    @Override
    public String bal() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableConstructorJacksonMapped fromJson(Json json) {
    ImmutableConstructorJacksonMapped instance = ImmutableConstructorJacksonMapped.of(json.instance, json.bal);
    return instance;
  }

  /**
   * Construct a new immutable {@code ConstructorJacksonMapped} instance.
   * @param instance The value for the {@code instance} attribute
   * @param bal The value for the {@code bal} attribute
   * @return An immutable ConstructorJacksonMapped instance
   */
  public static ImmutableConstructorJacksonMapped of(int instance, String bal) {
    return new ImmutableConstructorJacksonMapped(instance, bal);
  }

  /**
   * Creates an immutable copy of a {@link ConstructorJacksonMapped} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConstructorJacksonMapped instance
   */
  public static ImmutableConstructorJacksonMapped copyOf(ConstructorJacksonMapped instance) {
    if (instance instanceof ImmutableConstructorJacksonMapped) {
      return (ImmutableConstructorJacksonMapped) instance;
    }
    return ImmutableConstructorJacksonMapped.of(instance.instance(), instance.bal());
  }
}
