package org.immutables.fixture.generics.alpha;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SpecificType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSpecificType.builder()}.
 */
@Generated(from = "SpecificType", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableSpecificType extends SpecificType {

  private ImmutableSpecificType(ImmutableSpecificType.Builder builder) {
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSpecificType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSpecificType
        && equalTo(0, (ImmutableSpecificType) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(int synthetic, ImmutableSpecificType another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return -1284688459;
  }

  /**
   * Prints the immutable value {@code SpecificType}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SpecificType{}";
  }

  /**
   * Creates an immutable copy of a {@link SpecificType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SpecificType instance
   */
  public static ImmutableSpecificType copyOf(SpecificType instance) {
    if (instance instanceof ImmutableSpecificType) {
      return (ImmutableSpecificType) instance;
    }
    return ImmutableSpecificType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSpecificType ImmutableSpecificType}.
   * <pre>
   * ImmutableSpecificType.builder()
   *    .build();
   * </pre>
   * @return A new ImmutableSpecificType builder
   */
  public static ImmutableSpecificType.Builder builder() {
    return new ImmutableSpecificType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSpecificType ImmutableSpecificType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SpecificType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SpecificType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(SpecificType instance) {
      Objects.requireNonNull(instance, "instance");
      return this;
    }

    /**
     * Builds a new {@link ImmutableSpecificType ImmutableSpecificType}.
     * @return An immutable instance of SpecificType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSpecificType build() {
      return new ImmutableSpecificType(this);
    }
  }
}
