package org.immutables.fixture.generics;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * A modifiable implementation of the {@link Firstie Firstie} type.
 * <p>Use the {@link #create()} static factory methods to create new instances.
 * Use the {@link #toImmutable()} method to convert to canonical immutable instances.
 * <p><em>ModifiableFirstie is not thread-safe</em>
 * @param <T> generic parameter T
 * @param <V> generic parameter V
 * @see ImmutableFirstie
 */
@Generated(from = "Firstie", generator = "Modifiables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated({"Modifiables.generator", "Firstie"})
@NotThreadSafe
public final class ModifiableFirstie<T, V extends Runnable & Serializable>
    implements Firstie<T, V> {
  private static final long INIT_BIT_REF = 0x1L;
  private long initBits = 0x1L;

  private T ref;
  private final ArrayList<V> commands = new ArrayList<V>();

  private ModifiableFirstie() {}

  /**
   * Construct a modifiable instance of {@code Firstie}.
   * @param <T> generic parameter T
   * @param <V> generic parameter V
   * @return A new modifiable instance
   */
  public static <T, V extends Runnable & Serializable> ModifiableFirstie<T, V> create() {
    return new ModifiableFirstie<>();
  }

  /**
   * @return value of {@code ref} attribute
   */
  @Override
  public final T ref() {
    if (!refIsSet()) {
      checkRequiredAttributes();
    }
    return ref;
  }

  /**
   * @return modifiable list {@code commands}
   */
  @Override
  public final List<V> commands() {
    return commands;
  }

  /**
   * Clears the object by setting all attributes to their initial values.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableFirstie<T, V> clear() {
    initBits = 0x1L;
    ref = null;
    commands.clear();
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Firstie} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFirstie<T, V> from(Firstie<T, V> instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance instanceof ModifiableFirstie<?, ?>) {
      from((ModifiableFirstie<T, V>) instance);
      return this;
    }
    setRef(instance.ref());
    addAllCommands(instance.commands());
    return this;
  }

  /**
   * Fill this modifiable instance with attribute values from the provided {@link Firstie} instance.
   * Regular attribute values will be overridden, i.e. replaced with ones of an instance.
   * Any of the instance's absent optional values will not be copied (will not override current values).
   * Collection elements and entries will be added, not replaced.
   * @param instance The instance from which to copy values
   * @return {@code this} for use in a chained invocation
   */
  public ModifiableFirstie<T, V> from(ModifiableFirstie<T, V> instance) {
    Objects.requireNonNull(instance, "instance");
    if (instance.refIsSet()) {
      setRef(instance.ref());
    }
    addAllCommands(instance.commands());
    return this;
  }

  /**
   * Assigns a value to the {@link Firstie#ref() ref} attribute.
   * @param ref The value for ref
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableFirstie<T, V> setRef(T ref) {
    this.ref = Objects.requireNonNull(ref, "ref");
    initBits &= ~INIT_BIT_REF;
    return this;
  }

  /**
   * Adds one element to {@link Firstie#commands() commands} list.
   * @param element The commands element
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableFirstie<T, V> addCommands(V element) {
    Objects.requireNonNull(element, "commands element");
    this.commands.add(element);
    return this;
  }

  /**
   * Adds elements to {@link Firstie#commands() commands} list.
   * @param elements An array of commands elements
   * @return {@code this} for use in a chained invocation
   */
  @SafeVarargs
  @CanIgnoreReturnValue
  public final ModifiableFirstie<T, V> addCommands(V... elements) {
    for (V e : elements) {
      addCommands(e);
    }
    return this;
  }

  /**
   * Sets or replaces all elements for {@link Firstie#commands() commands} list.
   * @param elements An iterable of commands elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableFirstie<T, V> setCommands(Iterable<? extends V> elements) {
    this.commands.clear();
    addAllCommands(elements);
    return this;
  }

  /**
   * Adds elements to {@link Firstie#commands() commands} list.
   * @param elements An iterable of commands elements
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public ModifiableFirstie<T, V> addAllCommands(Iterable<? extends V> elements) {
    for (V e : elements) {
      addCommands(e);
    }
    return this;
  }

  /**
   * Returns {@code true} if the required attribute {@link Firstie#ref() ref} is set.
   * @return {@code true} if set
   */
  public final boolean refIsSet() {
    return (initBits & INIT_BIT_REF) == 0;
  }


  /**
   * Reset an attribute to its initial value.
   * @return {@code this} for use in a chained invocation
   */
  @CanIgnoreReturnValue
  public final ModifiableFirstie<T, V> unsetRef() {
    initBits |= INIT_BIT_REF;
    ref = null;
    return this;
  }

  /**
   * Returns {@code true} if all required attributes are set, indicating that the object is initialized.
   * @return {@code true} if set
   */
  public final boolean isInitialized() {
    return initBits == 0;
  }

  private void checkRequiredAttributes() {
    if (!isInitialized()) {
      throw new IllegalStateException(formatRequiredAttributesMessage());
    }
  }

  private String formatRequiredAttributesMessage() {
    List<String> attributes = new ArrayList<>();
    if (!refIsSet()) attributes.add("ref");
    return "Firstie is not initialized, some of the required attributes are not set " + attributes;
  }

  /**
   * Converts to {@link ImmutableFirstie ImmutableFirstie}.
   * @return An immutable instance of Firstie
   */
  public final ImmutableFirstie<T, V> toImmutable() {
    checkRequiredAttributes();
    return ImmutableFirstie.<T, V>copyOf(this);
  }

  /**
   * This instance is equal to all instances of {@code ModifiableFirstie<?, ?>} that have equal attribute values.
   * An uninitialized instance is equal only to itself.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    if (!(another instanceof ModifiableFirstie<?, ?>)) return false;
    ModifiableFirstie<?, ?> other = (ModifiableFirstie<?, ?>) another;
    if (!isInitialized() || !other.isInitialized()) {
      return false;
    }
    return equalTo(other);
  }

  private boolean equalTo(ModifiableFirstie<?, ?> another) {
    return ref.equals(another.ref)
        && commands.equals(another.commands);
  }

  /**
   * Computes a hash code from attributes: {@code ref}, {@code commands}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + ref.hashCode();
    h += (h << 5) + commands.hashCode();
    return h;
  }

  /**
   * Generates a string representation of this {@code Firstie}.
   * If uninitialized, some attribute values may appear as question marks.
   * @return A string representation
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ModifiableFirstie")
        .add("ref", refIsSet() ? ref() : "?")
        .add("commands", commands())
        .toString();
  }
}
